/*
 * Decompiled with CFR 0.152.
 */
package de.howaner.FramePicture.util;

import de.howaner.FramePicture.FramePicturePlugin;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PictureDatabase {
    private final Vector<String> whileDownload = new Vector();
    private final Vector<Thread> threads = new Vector();
    private final List<Runnable> asyncRunnables = new ArrayList<Runnable>();
    private Integer scheduleID = null;
    private File outputFolder = new File("plugins/FramePicture/images/");

    public PictureDatabase() {
        if (!this.outputFolder.exists()) {
            this.outputFolder.mkdirs();
        }
    }

    public void startScheduler() {
        if (this.scheduleID != null) {
            return;
        }
        this.scheduleID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)FramePicturePlugin.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (!PictureDatabase.this.asyncRunnables.isEmpty()) {
                    for (Runnable run : PictureDatabase.this.asyncRunnables) {
                        run.run();
                    }
                    PictureDatabase.this.asyncRunnables.clear();
                }
            }
        }, 5L, 5L);
    }

    public void stopScheduler() {
        if (this.scheduleID == null) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.scheduleID.intValue());
        this.scheduleID = null;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public BufferedImage loadImage(String name) {
        File file;
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (!this.outputFolder.exists()) {
            this.outputFolder.mkdirs();
        }
        if (!(file = new File(this.outputFolder, name)).exists() || file.isDirectory()) {
            return null;
        }
        try {
            return ImageIO.read(file);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public File writeImage(BufferedImage img, String name) {
        if (img == null || name == null || name.isEmpty()) {
            return null;
        }
        if (!this.outputFolder.exists()) {
            this.outputFolder.mkdirs();
        }
        File file = new File(this.outputFolder, String.format("%s.png", name));
        int i = 1;
        while (file.exists()) {
            file = new File(this.outputFolder, String.format("%s_%s.png", name, String.valueOf(i)));
            ++i;
        }
        try {
            ImageIO.write((RenderedImage)img, "png", file);
            return file;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean deleteImage(String name) {
        File file = new File(this.outputFolder, name);
        if (!file.exists()) {
            return false;
        }
        try {
            file.delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void downloadImage(final String path, final FinishDownloadSignal signal) {
        if (this.whileDownload.contains(path.toLowerCase())) {
            return;
        }
        this.whileDownload.add(path);
        FramePicturePlugin.log.info("Download " + path + " ...");
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int count;
                    String fileEnding;
                    String fileName;
                    String[] split;
                    URL url = new URL(path);
                    BufferedInputStream in = new BufferedInputStream(url.openStream());
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    if (path.contains("/")) {
                        split = path.split("/");
                        fileName = split[split.length - 1];
                    } else {
                        fileName = "unknown.png";
                    }
                    if (fileName.contains(".")) {
                        split = fileName.split("\\.");
                        fileName = "";
                        for (int i = 0; i < split.length - 1; ++i) {
                            if (i != 0) {
                                fileName = fileName + '.';
                            }
                            fileName = fileName + split[i];
                        }
                        fileEnding = split[split.length - 1];
                    } else {
                        fileEnding = "png";
                    }
                    byte[] buf = new byte[1024];
                    while ((count = in.read(buf, 0, 1024)) != -1) {
                        out.write(buf, 0, count);
                    }
                    out.flush();
                    out.close();
                    in.close();
                    if (!PictureDatabase.this.outputFolder.exists()) {
                        PictureDatabase.this.outputFolder.mkdirs();
                    }
                    File outputFile = new File(PictureDatabase.this.outputFolder, String.format("%s.%s", fileName, fileEnding));
                    int i = 1;
                    while (outputFile.exists()) {
                        outputFile = new File(PictureDatabase.this.outputFolder, String.format("%s_%s.%s", fileName, String.valueOf(i), fileEnding));
                        ++i;
                    }
                    FileOutputStream output = new FileOutputStream(outputFile);
                    output.write(out.toByteArray());
                    output.flush();
                    output.close();
                    FramePicturePlugin.log.info("Image " + outputFile + " was downloaded!");
                    final File of = outputFile;
                    List list = PictureDatabase.this.asyncRunnables;
                    synchronized (list) {
                        PictureDatabase.this.asyncRunnables.add(new Runnable(){

                            @Override
                            public void run() {
                                signal.downloadSuccess(of);
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    FramePicturePlugin.log.warning("Cant download Image! Error: " + ex.getMessage());
                    List list = PictureDatabase.this.asyncRunnables;
                    synchronized (list) {
                        PictureDatabase.this.asyncRunnables.add(new Runnable(){

                            @Override
                            public void run() {
                                signal.downloadError(ex);
                            }
                        });
                    }
                    ex.printStackTrace();
                }
                Vector vector = PictureDatabase.this.whileDownload;
                synchronized (vector) {
                    PictureDatabase.this.whileDownload.remove(path);
                }
                vector = PictureDatabase.this.threads;
                synchronized (vector) {
                    PictureDatabase.this.threads.remove(this);
                }
            }
        };
        this.threads.add(thread);
        thread.start();
    }

    public void clear() {
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        this.threads.clear();
        this.whileDownload.clear();
    }

    public static interface FinishDownloadSignal {
        public void downloadSuccess(File var1);

        public void downloadError(Exception var1);
    }
}

