/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import redgear.core.block.BlockGeneric;
import redgear.core.block.IDifferentDrop;
import redgear.core.block.MetaItemBlock;
import redgear.core.block.SubBlock;
import redgear.core.util.SimpleItem;
import redgear.core.world.WorldLocation;

public class MetaBlock<S extends SubBlock>
extends BlockGeneric {
    protected BiMap<Integer, S> blocks = HashBiMap.create();

    public MetaBlock(Material material, String name) {
        super(material, name, MetaItemBlock.class);
    }

    public SimpleItem addMetaBlock(S newBlock) throws IndexOutOfBoundsException {
        if (this.blocks.size() > 15 && !(this instanceof ITileEntityProvider)) {
            throw new IndexOutOfBoundsException("MetaBlocks can only have 16 values! (0-15) You can't register 17! Use a MetaTile OR use another MetaBlocks.");
        }
        this.blocks.put((Object)this.blocks.size(), newBlock);
        SimpleItem item = new SimpleItem(this, this.blocks.size() - 1);
        GameRegistry.registerCustomItemStack((String)(this.name + "." + ((SubBlock)newBlock).name), (ItemStack)item.getStack());
        return item;
    }

    protected boolean indexCheck(int index) {
        return this.blocks.size() > index && this.blocks.get((Object)index) != null;
    }

    public S getMetaBlock(int meta) {
        return (S)((SubBlock)this.blocks.get((Object)meta));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.indexCheck(meta)) {
            return ((SubBlock)this.getMetaBlock(meta)).getIcon(side);
        }
        return ((SubBlock)this.getMetaBlock(0)).getIcon(side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int i = 0; i < this.blocks.size(); ++i) {
            subItems.add(new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        for (SubBlock block : this.blocks.values()) {
            block.registerIcons(this.modName, par1IconRegister);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        S called = this.getMetaBlock(meta);
        WorldLocation loc = new WorldLocation(x, y, z, world);
        if (called instanceof IDifferentDrop) {
            return ((IDifferentDrop)called).getDrops(loc, meta, fortune);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(1);
        ret.add(new ItemStack((Block)this, 1, meta));
        return ret;
    }

    public int func_149643_k(World par1World, int par2, int par3, int par4) {
        return par1World.func_72805_g(par2, par3, par4);
    }
}

