/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.asm.RedGearCore;
import redgear.core.block.IDifferentDrop;
import redgear.core.block.MetaBlock;
import redgear.core.block.SubTile;
import redgear.core.tile.IFacedTile;
import redgear.core.tile.IRedstoneTile;
import redgear.core.tile.IWrenchableTile;
import redgear.core.world.WorldLocation;

public class MetaTile
extends MetaBlock<SubTile>
implements ITileEntityProvider {
    public MetaTile(Material par2Material, String name) {
        super(par2Material, name);
        this.field_149758_A = true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this.indexCheck(meta)) {
            return ((SubTile)this.getMetaBlock(meta)).createTile();
        }
        return ((SubTile)this.getMetaBlock(0)).createTile();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float f, float g, float t) {
        SubTile block = (SubTile)this.getMetaBlock(world.func_72805_g(x, y, z));
        if (block != null) {
            TileEntity tile;
            if (!world.field_72995_K && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() != null && IToolWrench.class.isAssignableFrom(player.func_70694_bm().func_77973_b().getClass()) && (tile = world.func_147438_o(x, y, z)) instanceof IWrenchableTile) {
                IWrenchableTile wrenchable = (IWrenchableTile)tile;
                boolean test = player.func_70093_af() ? wrenchable.wrenchedShift(player, ForgeDirection.getOrientation((int)side)) : wrenchable.wrenched(player, ForgeDirection.getOrientation((int)side));
                if (!test) {
                    return true;
                }
            }
            if (block.hasGui() && !player.func_70093_af()) {
                player.openGui((Object)RedGearCore.inst, block.guiId(), world, x, y, z);
                return true;
            }
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (entity == null) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IFacedTile) {
            ((IFacedTile)tile).onBlockPlacedBy(world, x, y, z, entity, stack);
        }
    }

    @Override
    public int func_149643_k(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            for (Map.Entry test : this.blocks.entrySet()) {
                if (!((SubTile)test.getValue()).createTile().getClass().equals(tile.getClass())) continue;
                return (Integer)test.getKey();
            }
        }
        return 0;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        SubTile called = (SubTile)this.getMetaBlock(meta);
        WorldLocation loc = new WorldLocation(x, y, z, world);
        if (called instanceof IDifferentDrop) {
            return ((IDifferentDrop)((Object)called)).getDrops(loc, meta, fortune);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(1);
        ret.add(new ItemStack((Block)this, 1, meta));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (this.indexCheck(meta)) {
            return ((SubTile)this.getMetaBlock(meta)).getBlockTexture(world, x, y, z, side);
        }
        return ((SubTile)this.getMetaBlock(0)).getBlockTexture(world, x, y, z, side);
    }

    public boolean func_149696_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_149696_a(par1World, par2, par3, par4, par5, par6);
        TileEntity tileentity = par1World.func_147438_o(par2, par3, par4);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            this.checkRedstone(world, x, y, z);
        }
    }

    private void checkRedstone(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRedstoneTile) {
            ((IRedstoneTile)tile).updateRedstone(world.func_94577_B(x, y, z));
        }
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRedstoneTile) {
            return ((IRedstoneTile)tile).redstoneSignal(ForgeDirection.getOrientation((int)side).getOpposite());
        }
        return 0;
    }
}

