/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.energy.thermal;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;

public class ThermalMaterial {
    private static final HashMap<Material, Float> materialMap = new HashMap();
    private static final float metal = 0.9f;
    private static final float ice = 0.5f;
    private static final float Default = 0.3f;
    private static final float water = 0.1f;
    private static final float air = 0.05f;

    public static void put(Material mat, float loss) {
        materialMap.put(mat, Float.valueOf(loss));
    }

    public static float getConductivity(Material other) {
        Float value = materialMap.get(other);
        if (value == null) {
            return 0.3f;
        }
        return value.floatValue();
    }

    public static float getSpecificHeat(Material other) {
        return 0.0f;
    }

    public static int getHeat(Material mat) {
        if (ThermalMaterial.isIce(mat)) {
            return 0;
        }
        if (mat == Material.field_151587_i) {
            return 1200;
        }
        if (mat == Material.field_151581_o) {
            return 1000;
        }
        return 27;
    }

    public static float getConductivity(Block other) {
        return 0.0f;
    }

    public static float getSpecificHeat(Block other) {
        return 0.0f;
    }

    public static int getHeat(Block mat) {
        return 27;
    }

    private static boolean isIce(Material mat) {
        return mat == Material.field_151588_w || mat == Material.field_151597_y || mat == Material.field_151596_z;
    }

    static {
        ThermalMaterial.put(Material.field_151573_f, 0.9f);
        ThermalMaterial.put(Material.field_151574_g, 0.9f);
        ThermalMaterial.put(Material.field_151588_w, 0.5f);
        ThermalMaterial.put(Material.field_151597_y, 0.5f);
        ThermalMaterial.put(Material.field_151596_z, 0.5f);
        ThermalMaterial.put(Material.field_151586_h, 0.1f);
        ThermalMaterial.put(Material.field_151592_s, 0.3f);
        ThermalMaterial.put(Material.field_151577_b, 0.3f);
        ThermalMaterial.put(Material.field_151578_c, 0.3f);
        ThermalMaterial.put(Material.field_151575_d, 0.3f);
        ThermalMaterial.put(Material.field_151576_e, 0.3f);
        ThermalMaterial.put(Material.field_151595_p, 0.3f);
        ThermalMaterial.put(Material.field_151590_u, 0.3f);
        ThermalMaterial.put(Material.field_151589_v, 0.3f);
        ThermalMaterial.put(Material.field_151572_C, 0.3f);
        ThermalMaterial.put(Material.field_151580_n, 0.3f);
        ThermalMaterial.put(Material.field_151584_j, 0.05f);
        ThermalMaterial.put(Material.field_151585_k, 0.05f);
        ThermalMaterial.put(Material.field_151582_l, 0.05f);
        ThermalMaterial.put(Material.field_151583_m, 0.05f);
        ThermalMaterial.put(Material.field_151594_q, 0.05f);
        ThermalMaterial.put(Material.field_151591_t, 0.05f);
        ThermalMaterial.put(Material.field_151566_D, 0.05f);
        ThermalMaterial.put(Material.field_151567_E, 0.05f);
        ThermalMaterial.put(Material.field_151568_F, 0.05f);
        ThermalMaterial.put(Material.field_151569_G, 0.05f);
        ThermalMaterial.put(Material.field_76233_E, 0.05f);
        ThermalMaterial.put(Material.field_151571_B, 0.05f);
        ThermalMaterial.put(Material.field_151570_A, 0.05f);
        ThermalMaterial.put(Material.field_151579_a, 0.05f);
        ThermalMaterial.put(Material.field_151593_r, 0.05f);
        ThermalMaterial.put(Material.field_151587_i, 0.05f);
        ThermalMaterial.put(Material.field_151581_o, 0.05f);
    }
}

