/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.fluids;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import redgear.core.inventory.TransferRule;

public class AdvFluidTank
extends FluidTank {
    private final Map<Integer, TransferRule> fluidMap = new HashMap<Integer, TransferRule>();

    public AdvFluidTank(int capacity) {
        this(null, capacity);
    }

    public AdvFluidTank(Fluid fluid, int amount, int capacity) {
        this(new FluidStack(fluid, amount), capacity);
    }

    public AdvFluidTank(FluidStack stack, int capacity) {
        super(stack, capacity);
    }

    public AdvFluidTank addFluidMapFluids(Collection<Fluid> fluids, TransferRule direct) {
        for (Fluid addFluid : fluids) {
            this.addFluidMap(addFluid, direct);
        }
        return this;
    }

    public AdvFluidTank addFluidMap(Fluid addFluid, TransferRule direct) {
        this.addFluidMap(addFluid == null ? -1 : addFluid.getID(), direct);
        return this;
    }

    public AdvFluidTank addFluidMapIds(Collection<Integer> fluidIds, TransferRule direct) {
        for (Integer fluidId : fluidIds) {
            this.addFluidMap(fluidId, direct);
        }
        return this;
    }

    public AdvFluidTank addFluidMap(int addFluidId, TransferRule direct) {
        this.fluidMap.put(addFluidId, direct);
        return this;
    }

    public boolean isFull() {
        return this.fluid != null && this.getFluid().amount == this.capacity;
    }

    public boolean isEmpty() {
        return this.fluid == null || this.fluid.amount == 0;
    }

    public int getSpace() {
        return this.capacity - this.getFluidAmount();
    }

    public int getAmount() {
        return this.getFluidAmount();
    }

    public boolean canFill(FluidStack other, boolean fully) {
        return other != null && this.isEmpty() ? true : this.fluid.isFluidEqual(other) && (!fully || this.canFill(other.amount));
    }

    public boolean canFill(Fluid other) {
        return other == null || this.isEmpty() ? true : this.fluid.fluidID == other.getID();
    }

    public boolean canFill(int amount) {
        return this.getSpace() >= amount;
    }

    public boolean canDrain(FluidStack other, boolean fully) {
        return other != null && this.isEmpty() ? false : (fully ? this.fluid.containsFluid(other) : this.fluid.isFluidEqual(other));
    }

    public boolean canDrain(Fluid other) {
        return other == null || this.isEmpty() ? false : this.fluid.fluidID == other.getID();
    }

    public boolean canDrain(int amount) {
        return this.getAmount() >= amount;
    }

    public boolean canAccept(int fluidId) {
        TransferRule direct = this.getRule(fluidId);
        return direct == TransferRule.INPUT || direct == TransferRule.BOTH;
    }

    public boolean canEject(int fluidId) {
        TransferRule direct = this.getRule(fluidId);
        return direct == TransferRule.OUTPUT || direct == TransferRule.BOTH;
    }

    public boolean canFillWithMap(FluidStack other, boolean fully) {
        return other == null || this.canAccept(other.fluidID) && this.canFill(other, fully);
    }

    public boolean canDrainWithMap(FluidStack other, boolean fully) {
        return other != null && this.canEject(other.fluidID) && this.canDrain(other, fully);
    }

    public boolean canDrainWithMap(int amount) {
        return this.canEject(this.fluid.fluidID) && this.canDrain(amount);
    }

    private TransferRule getRule(int fluidId) {
        TransferRule temp = this.fluidMap.get(fluidId);
        if (temp == null && (temp = this.fluidMap.get(-1)) == null) {
            temp = TransferRule.NEITHER;
        }
        return temp;
    }

    public int fillWithMap(FluidStack resource, boolean doFill) {
        if (this.canFillWithMap(resource, false)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drainWithMap(int maxDrain, boolean doDrain) {
        if (!this.isEmpty() && this.canDrainWithMap(this.fluid, false)) {
            return super.drain(maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drainWithMap(FluidStack resource, boolean doDrain) {
        FluidStack drained = null;
        if (this.canDrain(resource, false)) {
            drained = this.drain(resource.amount, doDrain);
        }
        return drained;
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Empty")) {
            this.fluid = null;
        }
        return super.readFromNBT(nbt);
    }
}

