/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.render.gui.element;

import redgear.core.render.GuiBase;
import redgear.core.render.RenderHelper;
import redgear.core.render.gui.element.ElementBase;

public class ElementDualScaled
extends ElementBase {
    public int quantity;
    public int mode;
    public boolean background = true;

    public ElementDualScaled(GuiBase gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public ElementDualScaled setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public ElementDualScaled setQuantity(int quantity) {
        this.quantity = quantity;
        return this;
    }

    public ElementDualScaled setBackground(boolean background) {
        this.background = background;
        return this;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        RenderHelper.bindTexture(this.texture);
        if (this.background) {
            this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        }
        switch (this.mode) {
            case 0: {
                this.drawTexturedModalRect(this.posX, this.posY + this.sizeY - this.quantity, this.sizeX, this.sizeY - this.quantity, this.sizeX, this.quantity);
                return;
            }
            case 1: {
                this.drawTexturedModalRect(this.posX, this.posY, this.sizeX, 0, this.quantity, this.sizeY);
                return;
            }
            case 2: {
                this.drawTexturedModalRect(this.posX + this.sizeX - this.quantity, this.posY, this.sizeX + this.sizeX - this.quantity, 0, this.quantity, this.sizeY);
                return;
            }
        }
    }
}

