/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.tile.TileEntityInventory;

public abstract class TileEntityElectricMachine
extends TileEntityInventory
implements IEnergyHandler {
    protected EnergyStorage storage;

    public TileEntityElectricMachine() {
        this(4);
    }

    public TileEntityElectricMachine(int idleRate) {
        this(idleRate, 32000);
    }

    public TileEntityElectricMachine(int idleRate, int powerCapacity) {
        super(idleRate);
        this.storage = new EnergyStorage(powerCapacity);
    }

    @Override
    protected final boolean tryUseEnergy(int energyUse) {
        if (this.storage.getEnergyStored() > energyUse) {
            this.storage.extractEnergy(energyUse, false);
            return true;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.storage.writeToNBT(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.storage.readFromNBT(tag);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }
}

