/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;
import redgear.core.api.item.ISimpleItem;
import redgear.core.api.util.HashHelper;
import redgear.core.world.BlockLocation;
import redgear.core.world.Location;
import redgear.core.world.WorldLocation;

public class SimpleItem
implements ISimpleItem,
Serializable {
    private static final long serialVersionUID = -8624739696061804763L;
    public final Item item;
    public final int meta;
    public final int oreID;

    public SimpleItem(ItemStack stack) {
        if (stack == null) {
            stack = new ItemStack(Blocks.field_150350_a);
        }
        this.item = stack.func_77973_b();
        if (this.item == null) {
            this.meta = 0;
            this.oreID = -1;
        } else {
            this.meta = stack.func_77960_j();
            this.oreID = OreDictionary.getOreID((ItemStack)stack);
        }
    }

    public SimpleItem(Item item, int meta) {
        this(new ItemStack(item, 1, meta));
    }

    public SimpleItem(Item item) {
        this(new ItemStack(item, 1, 0));
    }

    public SimpleItem(Block block) {
        this(new ItemStack(block, 1, 0));
    }

    public SimpleItem(Block block, int meta) {
        this(new ItemStack(block, 1, meta));
    }

    public SimpleItem(IBlockAccess world, int x, int y, int z) {
        this(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
    }

    public SimpleItem(IBlockAccess world, Location loc) {
        this(world, loc.field_151329_a, loc.field_151327_b, loc.field_151328_c);
    }

    public SimpleItem(ChunkPosition loc, IBlockAccess world) {
        this(new Location(loc), world);
    }

    public SimpleItem(Location loc, IBlockAccess world) {
        this(loc.getBlock(world), loc.getBlockMeta(world));
    }

    public SimpleItem(WorldLocation loc) {
        this(loc.getBlock(), loc.getBlockMeta());
    }

    public SimpleItem(String oreName) {
        ArrayList ores = OreDictionary.getOres((String)oreName);
        ItemStack stack = ores.isEmpty() ? new ItemStack(Blocks.field_150350_a) : (ItemStack)ores.get(0);
        this.item = stack.func_77973_b();
        this.meta = stack.func_77960_j();
        this.oreID = OreDictionary.getOreID((ItemStack)stack);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public Block getBlock() {
        return Block.func_149634_a((Item)this.getItem());
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public int getOreID() {
        return this.oreID;
    }

    @Override
    public ISimpleItem copy() {
        return new SimpleItem(this.getStack());
    }

    @Override
    public ItemStack getStack() {
        return this.getStack(1);
    }

    @Override
    public ItemStack getStack(int amount) {
        return new ItemStack(this.item, amount, this.meta);
    }

    @Override
    public String oreName() {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)this.getStack()));
    }

    @Override
    public boolean isInOreDict() {
        return this.oreID != -1;
    }

    @Override
    public String getName() {
        return Item.field_150901_e.func_148750_c((Object)this.getItem());
    }

    @Override
    public String getDisplayName() {
        return this.getStack().func_82833_r();
    }

    @Override
    public int getItemId() {
        return Item.func_150891_b((Item)this.item);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public int hashCode() {
        return HashHelper.hash(this.oreID, this.isInOreDict() ? 0 : this.getItemId(), this.isInOreDict() ? 0 : this.meta);
    }

    @Override
    public boolean isItemEqual(ISimpleItem other) {
        if (other == null) {
            return false;
        }
        if (this.getItem() == other.getItem() && (this.getMeta() == Short.MAX_VALUE || other.getMeta() == Short.MAX_VALUE || this.getMeta() == other.getMeta())) {
            return true;
        }
        return this.isInOreDict() && other.isInOreDict() && this.oreID == other.getOreID();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ISimpleItem) {
            return this.isItemEqual((ISimpleItem)obj);
        }
        if (obj instanceof ItemStack) {
            return this.isItemEqual(new SimpleItem((ItemStack)obj));
        }
        if (obj instanceof Block) {
            return this.isItemEqual(new SimpleItem((Block)obj));
        }
        if (obj instanceof Item) {
            return this.isItemEqual(new SimpleItem((Item)obj));
        }
        if (obj instanceof WorldLocation) {
            return this.isItemEqual(new SimpleItem((WorldLocation)((Object)obj)));
        }
        if (obj instanceof BlockLocation) {
            return this.isItemEqual(((BlockLocation)((Object)obj)).block);
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        this.getStack().func_77955_b(tag);
    }

    public SimpleItem(NBTTagCompound tag) {
        this(ItemStack.func_77949_a((NBTTagCompound)tag));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        NBTTagCompound subTag = new NBTTagCompound();
        this.writeToNBT(subTag);
        tag.func_74782_a(name, (NBTBase)subTag);
    }

    public SimpleItem(NBTTagCompound tag, String name) {
        this(tag.func_74775_l(name));
    }
}

