/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.world;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.api.item.ISimpleItem;
import redgear.core.util.SimpleItem;
import redgear.core.world.Location;

public class MultiBlockMap {
    private HashMap<Location, Collection<ISimpleItem>> points;

    public MultiBlockMap() {
        this(1);
    }

    public MultiBlockMap(int size) {
        this.points = new HashMap(size);
    }

    public void addLocation(Location loc, Collection<ISimpleItem> items) {
        this.points.put(loc, items);
    }

    public void addLocation(int x, int y, int z, ItemStack stack) {
        this.addLocation(x, y, z, new SimpleItem(stack));
    }

    public void addLocation(int x, int y, int z, ISimpleItem stack) {
        HashSet<ISimpleItem> temp = new HashSet<ISimpleItem>(1);
        temp.add(stack);
        this.addLocation(x, y, z, temp);
    }

    public void addLocation(int x, int y, int z, Collection<ISimpleItem> stack) {
        this.addLocation(new Location(x, y, z), stack);
    }

    public boolean check(IBlockAccess world, int x, int y, int z) {
        return this.check(world, new Location(x, y, z));
    }

    public boolean check(IBlockAccess world, Location other) {
        for (Map.Entry<Location, Collection<ISimpleItem>> bit : this.points.entrySet()) {
            if (bit.getKey().check(world, bit.getValue(), (ChunkPosition)other)) continue;
            return false;
        }
        return true;
    }

    public void rotate(ForgeDirection direction, int degrees) {
        for (Map.Entry<Location, Collection<ISimpleItem>> bit : this.points.entrySet()) {
            bit.getKey().rotate(direction, degrees);
        }
    }

    public void reflect(ForgeDirection direction) {
        for (Map.Entry<Location, Collection<ISimpleItem>> bit : this.points.entrySet()) {
            bit.getKey().reflect(direction);
        }
    }

    public void translate(int x, int y, int z) {
        this.translate(new Location(x, y, z));
    }

    public void translate(Location other) {
        for (Map.Entry<Location, Collection<ISimpleItem>> bit : this.points.entrySet()) {
            bit.getKey().translate(other);
        }
    }

    public void translaste(int direction, int amount) {
        this.translate(ForgeDirection.getOrientation((int)direction), amount);
    }

    public void translate(ForgeDirection direction, int amount) {
        this.translate(direction.offsetX * amount, direction.offsetY * amount, direction.offsetZ * amount);
    }
}

