/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.world;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import redgear.core.api.item.ISimpleItem;
import redgear.core.util.StringHelper;
import redgear.core.world.Location;

public class WorldLocation
extends Location {
    public final World world;

    public WorldLocation(WorldLocation other) {
        super(other);
        this.world = other.world;
    }

    public WorldLocation(int x, int y, int z, World world) {
        super(x, y, z);
        this.world = world;
    }

    public WorldLocation(ChunkPosition pos, World world) {
        super(pos);
        this.world = world;
    }

    public WorldLocation(TileEntity tile) {
        super(tile);
        this.world = tile.func_145831_w();
    }

    public WorldLocation(MovingObjectPosition pos) {
        super(pos);
        this.world = pos.field_72308_g.field_70170_p;
    }

    public WorldLocation(Vec3 vector, World world) {
        super(vector);
        this.world = world;
    }

    public WorldLocation(NBTTagCompound tag, World world) {
        super(tag);
        this.world = world;
    }

    public WorldLocation(NBTTagCompound tag, String name, World world) {
        super(tag, name);
        this.world = world;
    }

    @Override
    protected WorldLocation create(int x, int y, int z) {
        return new WorldLocation(x, y, z, this.world);
    }

    @Override
    public WorldLocation copy() {
        return new WorldLocation(this);
    }

    public boolean check(ISimpleItem block) {
        return super.check((IBlockAccess)this.world, block);
    }

    public boolean check(ISimpleItem block, ChunkPosition relative) {
        return super.check((IBlockAccess)this.world, block, relative);
    }

    public boolean check(Collection<ISimpleItem> blocks) {
        return super.check((IBlockAccess)this.world, blocks);
    }

    public boolean check(Collection<ISimpleItem> blocks, ChunkPosition relative) {
        return super.check((IBlockAccess)this.world, blocks, relative);
    }

    public boolean check(Class<? extends TileEntity> classes, ChunkPosition relative) {
        return super.check((IBlockAccess)this.world, classes, relative);
    }

    public boolean check(Class<? extends TileEntity> type) {
        return super.check((IBlockAccess)this.world, type);
    }

    public void placeBlock(ISimpleItem block) {
        super.placeBlock(this.world, block);
    }

    public void placeBlock(ISimpleItem block, ChunkPosition relative) {
        super.placeBlock(this.world, block, relative);
    }

    public boolean placeBlock(ISimpleItem block, ISimpleItem target) {
        return super.placeBlock(this.world, block, target);
    }

    public boolean placeBlock(ISimpleItem item, ISimpleItem target, ChunkPosition relative) {
        return super.placeBlock(this.world, item, target, relative);
    }

    public boolean placeBlock(ISimpleItem block, Collection<ISimpleItem> targets) {
        return super.placeBlock(this.world, block, targets);
    }

    public boolean placeBlock(ISimpleItem item, Collection<ISimpleItem> targets, ChunkPosition relative) {
        return super.placeBlock(this.world, item, targets, relative);
    }

    public Block getBlock() {
        return super.getBlock((IBlockAccess)this.world);
    }

    public int getBlockMeta() {
        return super.getBlockMeta((IBlockAccess)this.world);
    }

    public TileEntity getTile() {
        return super.getTile((IBlockAccess)this.world);
    }

    public Material getMaterial() {
        return super.getMaterial((IBlockAccess)this.world);
    }

    public boolean isAir() {
        return super.isAir((IBlockAccess)this.world);
    }

    public void setAir() {
        super.setAir(this.world);
    }

    public boolean isSideSolid(ForgeDirection side) {
        return super.isSideSolid((IBlockAccess)this.world, side);
    }

    @Override
    public WorldLocation rotate(ForgeDirection direction, int degrees) {
        return (WorldLocation)super.rotate(direction, degrees);
    }

    @Override
    public WorldLocation reflect(ForgeDirection direction) {
        return (WorldLocation)super.reflect(direction);
    }

    @Override
    public WorldLocation translate(ChunkPosition other) {
        return (WorldLocation)super.translate(other);
    }

    @Override
    public WorldLocation translate(int direction, int amount) {
        return (WorldLocation)super.translate(direction, amount);
    }

    @Override
    public WorldLocation translate(int x, int y, int z) {
        return (WorldLocation)super.translate(x, y, z);
    }

    @Override
    public WorldLocation translate(ForgeDirection direction, int amount) {
        return (WorldLocation)super.translate(direction, amount);
    }

    public boolean equals(Object other) {
        if (other instanceof WorldLocation) {
            return super.equals(other) && this.world.field_73011_w.field_76574_g == ((WorldLocation)((Object)other)).world.field_73011_w.field_76574_g;
        }
        return super.equals(other);
    }

    @Override
    public String toString() {
        return StringHelper.concat("WorldLocation [x=", this.field_151329_a, ", y=", this.field_151327_b, ", z=", this.field_151328_c, ", Dimension=", this.world.func_72912_H().func_76065_j(), "]");
    }
}

