package me.Phaluh.SnowGrenade;

import java.util.List;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class Main extends JavaPlugin implements Listener{
	@Override
	public void onEnable() {
		getServer().getPluginManager().registerEvents(this, this);
	}
	@EventHandler (priority = EventPriority.NORMAL)
	public void onGrenade(ProjectileHitEvent event) {   
	    if (event.getEntity() instanceof Snowball) {   
	        Snowball snowball = (Snowball) event.getEntity();   
	        if (snowball.getShooter() instanceof Player) {       
	            Player shooter = (Player) snowball.getShooter();       
	            snowball.getWorld().createExplosion(snowball.getLocation(), 4);       
	            List<Entity> nearbyEntities = snowball.getNearbyEntities(3, 3, 3);       
	            for (int i = 0; i < nearbyEntities.size(); i++) {           
	                if (nearbyEntities.get(i) instanceof LivingEntity) {   
	                    LivingEntity living = (LivingEntity) nearbyEntities.get(i);
	                    living.damage(6D);
	                }
	            }
	        }
	    }
	}
	public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) { 
		Player player = (Player) sender;
		if(commandLabel.equalsIgnoreCase("grenade")) {
			player.getInventory().clear();
			player.sendMessage(ChatColor.GOLD + "Bombs Away!");
			ItemStack grenade = new ItemStack(Material.SNOW_BALL);
			ItemMeta meta = grenade.getItemMeta();
			meta.setDisplayName("Grenade");
			player.getInventory().addItem(new ItemStack(Material.SNOW_BALL, 576));

		}
		return false;
	}
}
