/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.MCAccessHolder;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.hooks.NCPHookManager;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.ExecutionHistory;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Check
implements MCAccessHolder {
    protected static Map<String, ExecutionHistory> histories = new HashMap<String, ExecutionHistory>();
    protected final CheckType type;
    protected MCAccess mcAccess;

    protected static ExecutionHistory getHistory(Player player) {
        if (!histories.containsKey(player.getName())) {
            histories.put(player.getName(), new ExecutionHistory());
        }
        return histories.get(player.getName());
    }

    public Check(CheckType type) {
        this.type = type;
        this.mcAccess = NCPAPIProvider.getNoCheatPlusAPI().getMCAccess();
        ViolationHistory.checkTypeMap.put(this.getClass().getName(), type);
        DataManager.registerExecutionHistory(type, histories);
    }

    public boolean executeActions(Player player, double vL, double addedVL, ActionList actions, boolean isMainThread) {
        return this.executeActions(new ViolationData(this, player, vL, addedVL, actions), isMainThread);
    }

    protected boolean executeActions(Player player, double vL, double addedVL, ActionList actions) {
        return this.executeActions(new ViolationData(this, player, vL, addedVL, actions), true);
    }

    protected boolean executeActions(ViolationData violationData) {
        return this.executeActions(violationData, true);
    }

    protected boolean executeActions(ViolationData violationData, boolean isMainThread) {
        if (NCPHookManager.shouldCancelVLProcessing(violationData)) {
            return false;
        }
        boolean hasCancel = violationData.hasCancel();
        if (isMainThread) {
            return violationData.executeActions();
        }
        TickTask.requestActionsExecution(violationData);
        return hasCancel;
    }

    protected Map<ParameterName, String> getParameterMap(ViolationData violationData) {
        HashMap<ParameterName, String> params = new HashMap<ParameterName, String>();
        return params;
    }

    public CheckType getType() {
        return this.type;
    }

    public boolean isEnabled(Player player) {
        try {
            if (!this.type.isEnabled(player) || player.hasPermission(this.type.getPermission())) {
                return false;
            }
        }
        catch (Exception e) {
            LogUtil.logSevere(e);
        }
        return !NCPExemptionManager.isExempted(player, this.type);
    }

    @Override
    public void setMCAccess(MCAccess mcAccess) {
        this.mcAccess = mcAccess;
    }

    @Override
    public MCAccess getMCAccess() {
        return this.mcAccess;
    }
}

