/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockbreak;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakConfig;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Direction
extends Check {
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public Direction() {
        super(CheckType.BLOCKBREAK_DIRECTION);
    }

    public boolean check(Player player, Block block, BlockBreakData data) {
        boolean cancel = false;
        Location loc = player.getLocation(this.useLoc);
        Vector direction = loc.getDirection();
        double off = TrigUtil.directionCheck(loc, player.getEyeHeight(), direction, block, 2.6);
        if (off > 0.1) {
            Vector blockEyes = new Vector(0.5 + (double)block.getX() - loc.getX(), 0.5 + (double)block.getY() - loc.getY() - player.getEyeHeight(), 0.5 + (double)block.getZ() - loc.getZ());
            double distance = blockEyes.crossProduct(direction).length() / direction.length();
            data.directionVL += distance;
            cancel = this.executeActions(player, data.directionVL, distance, BlockBreakConfig.getConfig((Player)player).directionActions);
        } else {
            data.directionVL *= 0.9;
        }
        this.useLoc.setWorld(null);
        return cancel;
    }
}

