/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockbreak;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakConfig;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class WrongBlock
extends Check {
    public WrongBlock() {
        super(CheckType.BLOCKBREAK_WRONGBLOCK);
    }

    public boolean check(Player player, Block block, BlockBreakConfig cc, BlockBreakData data, boolean isInstaBreak) {
        boolean wrongBlock;
        boolean cancel = false;
        boolean wrongTime = data.fastBreakfirstDamage < data.fastBreakBreakTime;
        int dist = Math.min(4, data.clickedX == Integer.MAX_VALUE ? 100 : TrigUtil.manhattan(data.clickedX, data.clickedY, data.clickedZ, block));
        long now = System.currentTimeMillis();
        if (dist == 0) {
            if (wrongTime) {
                data.fastBreakBreakTime = now;
                data.fastBreakfirstDamage = now;
            }
            wrongBlock = false;
        } else {
            wrongBlock = dist == 1 ? now - data.wasInstaBreak >= 60L : true;
        }
        if (wrongBlock) {
            if ((cc.fastBreakDebug || cc.debug) && player.hasPermission("nocheatplus.admin.debug")) {
                player.sendMessage("WrongBlock failure with dist: " + dist);
            }
            data.wrongBlockVL.add(now, (float)(dist + 1) / 2.0f);
            float score = data.wrongBlockVL.score(0.9f);
            if (score > cc.wrongBLockLevel) {
                if (this.executeActions(player, score, 1.0, cc.wrongBlockActions)) {
                    cancel = true;
                }
                if (Improbable.check(player, 2.0f, now, "blockbreak.wrongblock")) {
                    cancel = true;
                }
            }
        }
        return cancel;
    }
}

