/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;

public class BlockInteractData
extends ACheckData {
    public static final CheckDataFactory factory = new CheckDataFactory(){

        public final ICheckData getData(Player player) {
            return BlockInteractData.getData(player);
        }

        public ICheckData removeData(String playerName) {
            return BlockInteractData.removeData(playerName);
        }

        public void removeAllData() {
            BlockInteractData.clear();
        }
    };
    private static final Map<String, BlockInteractData> playersMap = new HashMap<String, BlockInteractData>();
    public double directionVL = 0.0;
    public double reachVL = 0.0;
    public double speedVL = 0.0;
    public double visibleVL = 0.0;
    public int lastX = Integer.MAX_VALUE;
    public int lastY;
    public int lastZ;
    public Material lastType = null;
    public long lastTick;
    public Action lastAction = null;
    public double reachDistance;
    public long speedTime = 0L;
    public int speedCount = 0;

    public static BlockInteractData getData(Player player) {
        if (!playersMap.containsKey(player.getName())) {
            playersMap.put(player.getName(), new BlockInteractData());
        }
        return playersMap.get(player.getName());
    }

    public static ICheckData removeData(String playerName) {
        return playersMap.remove(playerName);
    }

    public static void clear() {
        playersMap.clear();
    }

    public void setLastBlock(Block block, Action action) {
        this.lastX = block.getX();
        this.lastY = block.getY();
        this.lastZ = block.getZ();
        this.lastType = block.getType();
        if (this.lastType == Material.AIR) {
            this.lastType = null;
        }
        this.lastTick = TickTask.getTick();
        this.lastAction = action;
    }

    public void resetLastBlock() {
        this.lastTick = 0L;
        this.lastAction = null;
        this.lastX = Integer.MAX_VALUE;
        this.lastType = null;
    }
}

