/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Direction
extends Check {
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public Direction() {
        super(CheckType.BLOCKPLACE_DIRECTION);
    }

    public boolean check(Player player, Block placed, Block against, BlockPlaceData data, BlockPlaceConfig cc) {
        boolean cancel = false;
        Location loc = player.getLocation(this.useLoc);
        Vector direction = loc.getDirection();
        double off = TrigUtil.directionCheck(loc, player.getEyeHeight(), direction, against, 2.6);
        double off2 = 0.0;
        if (placed.getX() > against.getX()) {
            off2 = (double)against.getX() + 0.5 - loc.getX();
        } else if (placed.getX() < against.getX()) {
            off2 = -((double)against.getX() + 0.5 - loc.getX());
        } else if (placed.getY() > against.getY()) {
            off2 = (double)against.getY() + 0.5 - loc.getY() - player.getEyeHeight();
        } else if (placed.getY() < against.getY()) {
            off2 = -((double)against.getY() + 0.5 - loc.getY() - player.getEyeHeight());
        } else if (placed.getZ() > against.getZ()) {
            off2 = (double)against.getZ() + 0.5 - loc.getZ();
        } else if (placed.getZ() < against.getZ()) {
            off2 = -((double)against.getZ() + 0.5 - loc.getZ());
        }
        if (off2 > 0.0) {
            off += off2;
        }
        if (off > 0.1) {
            Vector blockEyes = new Vector(0.5 + (double)placed.getX() - loc.getX(), 0.5 + (double)placed.getY() - loc.getY() - player.getEyeHeight(), 0.5 + (double)placed.getZ() - loc.getZ());
            double distance = blockEyes.crossProduct(direction).length() / direction.length();
            data.directionVL += distance;
            cancel = this.executeActions(player, data.directionVL, distance, cc.directionActions);
        } else {
            data.directionVL *= 0.9;
        }
        this.useLoc.setWorld(null);
        return cancel;
    }
}

