/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reach
extends Check {
    public static final double CREATIVE_DISTANCE = 5.6;
    public static final double SURVIVAL_DISTANCE = 5.2;
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public Reach() {
        super(CheckType.BLOCKPLACE_REACH);
    }

    public boolean check(Player player, Block block, BlockPlaceData data, BlockPlaceConfig cc) {
        boolean cancel = false;
        double distanceLimit = player.getGameMode() == GameMode.CREATIVE ? 5.6 : 5.2;
        Location eyeLoc = player.getLocation(this.useLoc);
        eyeLoc.setY(eyeLoc.getY() + player.getEyeHeight());
        double distance = TrigUtil.distance(eyeLoc, block) - distanceLimit;
        if (distance > 0.0) {
            data.reachVL += distance;
            data.reachDistance = distance;
            cancel = this.executeActions(player, data.reachVL, distance, cc.reachActions);
        } else {
            data.reachVL *= 0.9;
        }
        this.useLoc.setWorld(null);
        return cancel;
    }

    @Override
    protected Map<ParameterName, String> getParameterMap(ViolationData violationData) {
        Map<ParameterName, String> parameters = super.getParameterMap(violationData);
        parameters.put(ParameterName.REACH_DISTANCE, "" + Math.round(BlockPlaceData.getData((Player)violationData.player).reachDistance));
        return parameters;
    }
}

