/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors;

import fr.neatmonster.nocheatplus.checks.chat.analysis.MessageLetterCount;
import fr.neatmonster.nocheatplus.checks.chat.analysis.WordLetterCount;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.WordProcessor;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWordProcessor
implements WordProcessor {
    protected String name;
    protected float weight = 1.0f;

    public static final <K> void releaseMap(Map<K, ?> map, int number) {
        LinkedList<K> rem = new LinkedList<K>();
        int i = 0;
        for (Object key : map.keySet()) {
            rem.add(key);
            if (++i <= number) continue;
            break;
        }
        for (Object key : rem) {
            map.remove(key);
        }
    }

    public AbstractWordProcessor(String name) {
        this.name = name;
    }

    @Override
    public String getProcessorName() {
        return this.name;
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    @Override
    public float process(MessageLetterCount message) {
        this.start(message);
        long ts = System.currentTimeMillis();
        float score = 0.0f;
        for (int index = 0; index < message.words.length; ++index) {
            WordLetterCount word = message.words[index];
            String key = word.word.toLowerCase();
            score += this.loop(ts, index, key, word) * (float)(word.word.length() + 1);
        }
        return score /= (float)(message.message.length() + message.words.length);
    }

    public void start(MessageLetterCount message) {
    }

    @Override
    public void clear() {
    }

    public abstract float loop(long var1, int var3, String var4, WordLetterCount var5);
}

