/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.fight.DirectionContext;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.moving.LocationTrace;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Direction
extends Check {
    public Direction() {
        super(CheckType.FIGHT_DIRECTION);
    }

    public boolean check(Player player, Location loc, Entity damaged, Location dLoc, FightData data, FightConfig cc) {
        boolean cancel = false;
        if (this.mcAccess.isComplexPart(damaged)) {
            return false;
        }
        double width = this.mcAccess.getWidth(damaged);
        double height = this.mcAccess.getHeight(damaged);
        Vector direction = loc.getDirection();
        double off = cc.directionStrict ? TrigUtil.combinedDirectionCheck(loc, player.getEyeHeight(), direction, dLoc.getX(), dLoc.getY() + height / 2.0, dLoc.getZ(), width, height, 2.6, 80.0) : TrigUtil.directionCheck(loc, player.getEyeHeight(), direction, dLoc.getX(), dLoc.getY() + height / 2.0, dLoc.getZ(), width, height, 2.6);
        if (off > 0.1) {
            Vector blockEyes = new Vector(dLoc.getX() - loc.getX(), dLoc.getY() + height / 2.0 - loc.getY() - player.getEyeHeight(), dLoc.getZ() - loc.getZ());
            double distance = blockEyes.crossProduct(direction).length() / direction.length();
            data.directionVL += distance;
            cancel = this.executeActions(player, data.directionVL, distance, cc.directionActions);
            if (cancel) {
                data.attackPenalty.applyPenalty(cc.directionPenalty);
            }
        } else {
            data.directionVL *= 0.8;
        }
        return cancel;
    }

    public DirectionContext getContext(Player player, Location loc, Entity damaged, Location damagedLoc, FightData data, FightConfig cc) {
        DirectionContext context = new DirectionContext();
        context.damagedComplex = this.mcAccess.isComplexPart(damaged);
        context.damagedWidth = this.mcAccess.getWidth(damaged);
        context.damagedHeight = this.mcAccess.getHeight(damaged);
        context.direction = loc.getDirection();
        context.lengthDirection = context.direction.length();
        return context;
    }

    public boolean loopCheck(Player player, Location loc, Entity damaged, LocationTrace.TraceEntry dLoc, DirectionContext context, FightData data, FightConfig cc) {
        if (context.damagedComplex) {
            return false;
        }
        boolean cancel = false;
        double off = cc.directionStrict ? TrigUtil.combinedDirectionCheck(loc, player.getEyeHeight(), context.direction, dLoc.x, dLoc.y + context.damagedHeight / 2.0, dLoc.z, context.damagedWidth, context.damagedHeight, 2.6, 80.0) : TrigUtil.directionCheck(loc, player.getEyeHeight(), context.direction, dLoc.x, dLoc.y + context.damagedHeight / 2.0, dLoc.z, context.damagedWidth, context.damagedHeight, 2.6);
        if (off > 0.1) {
            Vector blockEyes = new Vector(dLoc.x - loc.getX(), dLoc.y + context.damagedHeight / 2.0 - loc.getY() - player.getEyeHeight(), dLoc.z - loc.getZ());
            double distance = blockEyes.crossProduct(context.direction).length() / context.lengthDirection;
            context.minViolation = Math.min(context.minViolation, distance);
        }
        context.minResult = Math.min(context.minResult, off);
        return cancel;
    }

    public boolean loopFinish(Player player, Location loc, Entity damaged, DirectionContext context, boolean forceViolation, FightData data, FightConfig cc) {
        double off;
        boolean cancel = false;
        double d = off = forceViolation && context.minViolation != Double.MAX_VALUE ? context.minViolation : context.minResult;
        if (off == Double.MAX_VALUE) {
            return false;
        }
        if (off > 0.1) {
            data.directionVL += context.minViolation;
            cancel = this.executeActions(player, data.directionVL, context.minViolation, cc.directionActions);
            if (cancel) {
                data.attackPenalty.applyPenalty(cc.directionPenalty);
            }
        } else {
            data.directionVL *= 0.8;
        }
        return cancel;
    }
}

