/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.fight.Angle;
import fr.neatmonster.nocheatplus.checks.fight.Critical;
import fr.neatmonster.nocheatplus.checks.fight.Direction;
import fr.neatmonster.nocheatplus.checks.fight.DirectionContext;
import fr.neatmonster.nocheatplus.checks.fight.FastHeal;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.fight.GodMode;
import fr.neatmonster.nocheatplus.checks.fight.Knockback;
import fr.neatmonster.nocheatplus.checks.fight.NoSwing;
import fr.neatmonster.nocheatplus.checks.fight.Reach;
import fr.neatmonster.nocheatplus.checks.fight.ReachContext;
import fr.neatmonster.nocheatplus.checks.fight.SelfHit;
import fr.neatmonster.nocheatplus.checks.fight.Speed;
import fr.neatmonster.nocheatplus.checks.inventory.Items;
import fr.neatmonster.nocheatplus.checks.moving.LocationTrace;
import fr.neatmonster.nocheatplus.checks.moving.MediumLiftOff;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.MovingListener;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.components.JoinLeaveListener;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class FightListener
extends CheckListener
implements JoinLeaveListener {
    private final Angle angle = this.addCheck(new Angle());
    private final Critical critical = this.addCheck(new Critical());
    private final Direction direction = this.addCheck(new Direction());
    private final FastHeal fastHeal = this.addCheck(new FastHeal());
    private final GodMode godMode = this.addCheck(new GodMode());
    private final Knockback knockback = this.addCheck(new Knockback());
    private final NoSwing noSwing = this.addCheck(new NoSwing());
    private final Reach reach = this.addCheck(new Reach());
    private final SelfHit selfHit = this.addCheck(new SelfHit());
    private final Speed speed = this.addCheck(new Speed());
    private final Location useLoc1 = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLoc2 = new Location(null, 0.0, 0.0, 0.0);

    public FightListener() {
        super(CheckType.FIGHT);
    }

    private boolean handleNormalDamage(Player player, Entity damaged, double damage, int tick, FightData data) {
        boolean directionEnabled;
        LocationTrace damagedTrace;
        Player damagedPlayer;
        long msAge;
        double normalizedMove;
        double targetMove;
        int tickAge;
        FightConfig cc = FightConfig.getConfig(player);
        ItemStack stack = player.getItemInHand();
        if (Items.checkIllegalEnchantments(player, stack)) {
            return true;
        }
        boolean cancelled = false;
        String worldName = player.getWorld().getName();
        long now = System.currentTimeMillis();
        boolean worldChanged = !worldName.equals(data.lastWorld);
        Location loc = player.getLocation(this.useLoc1);
        Location damagedLoc = damaged.getLocation(this.useLoc2);
        if (data.lastAttackedX == Double.MAX_VALUE || tick < data.lastAttackTick || worldChanged || tick - data.lastAttackTick > 20) {
            tickAge = 0;
            targetMove = 0.0;
            normalizedMove = 0.0;
            msAge = 0L;
        } else {
            tickAge = tick - data.lastAttackTick;
            targetMove = TrigUtil.distance(data.lastAttackedX, data.lastAttackedZ, damagedLoc.getX(), damagedLoc.getZ());
            msAge = (long)(50.0f * TickTask.getLag(50L * (long)tickAge) * (float)tickAge);
            double d = normalizedMove = msAge == 0L ? targetMove : targetMove * Math.min(20.0, 1000.0 / (double)msAge);
        }
        if (damaged instanceof Player) {
            damagedPlayer = (Player)damaged;
            if (cc.debug && damagedPlayer.hasPermission("nocheatplus.admin.debug")) {
                damagedPlayer.sendMessage("Attacked by " + player.getName() + ": inv=" + this.mcAccess.getInvulnerableTicks(damagedPlayer) + " ndt=" + damagedPlayer.getNoDamageTicks());
            }
            if (this.selfHit.isEnabled(player) && this.selfHit.check(player, damagedPlayer, data, cc)) {
                cancelled = true;
            }
            damagedTrace = MovingData.getData(damagedPlayer).updateTrace(damagedPlayer, damagedLoc, tick);
        } else {
            damagedPlayer = null;
            MovingConfig mcc = MovingConfig.getConfig(damagedLoc.getWorld().getName());
            damagedTrace = null;
        }
        if (cc.cancelDead) {
            if (damaged.isDead()) {
                cancelled = true;
            }
            if (player.isDead() && data.damageTakenByEntityTick != (long)TickTask.getTick()) {
                cancelled = true;
            }
        }
        if (damage <= 4.0 && (long)tick == data.damageTakenByEntityTick && data.thornsId != Integer.MIN_VALUE && data.thornsId == damaged.getEntityId()) {
            data.thornsId = Integer.MIN_VALUE;
            return cancelled;
        }
        data.thornsId = Integer.MIN_VALUE;
        if (!cancelled && this.speed.isEnabled(player)) {
            if (this.speed.check(player, now)) {
                cancelled = true;
                if (data.speedVL > 50.0) {
                    Improbable.check(player, 2.0f, now, "fight.speed");
                } else {
                    Improbable.feed(player, 2.0f, now);
                }
            } else if (normalizedMove > 2.0 && Improbable.check(player, 1.0f, now, "fight.speed")) {
                cancelled = true;
            }
        }
        if (!cancelled && this.critical.isEnabled(player) && this.critical.check(player, loc, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && this.knockback.isEnabled(player) && this.knockback.check(player, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && this.noSwing.isEnabled(player) && this.noSwing.check(player, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && player.isBlocking() && !player.hasPermission("nocheatplus.checks.moving.survivalfly.blocking")) {
            cancelled = true;
        }
        boolean reachEnabled = !cancelled && this.reach.isEnabled(player);
        boolean bl = directionEnabled = !cancelled && this.direction.isEnabled(player);
        if (reachEnabled || directionEnabled) {
            if (damagedPlayer != null) {
                boolean directionPassed;
                ReachContext reachContext = reachEnabled ? this.reach.getContext(player, loc, damaged, damagedLoc, data, cc) : null;
                DirectionContext directionContext = directionEnabled ? this.direction.getContext(player, loc, damaged, damagedLoc, data, cc) : null;
                long traceOldest = tick;
                LocationTrace.TraceIterator traceIt = damagedTrace.maxAgeIterator(traceOldest);
                boolean violation = true;
                boolean reachPassed = !reachEnabled;
                boolean bl2 = directionPassed = !directionEnabled;
                while (traceIt.hasNext()) {
                    LocationTrace.TraceEntry entry = (LocationTrace.TraceEntry)traceIt.next();
                    boolean thisPassed = true;
                    if (reachEnabled) {
                        if (this.reach.loopCheck(player, loc, (Entity)damagedPlayer, entry, reachContext, data, cc)) {
                            thisPassed = false;
                        } else {
                            reachPassed = true;
                        }
                    }
                    if (directionEnabled && (reachPassed || !directionPassed)) {
                        if (this.direction.loopCheck(player, damagedLoc, (Entity)damagedPlayer, entry, directionContext, data, cc)) {
                            thisPassed = false;
                        } else {
                            directionPassed = true;
                        }
                    }
                    if (!thisPassed) continue;
                    violation = false;
                    break;
                }
                if (reachEnabled && this.reach.loopFinish(player, loc, (Entity)damagedPlayer, reachContext, violation, data, cc)) {
                    cancelled = true;
                }
                if (directionEnabled && this.direction.loopFinish(player, loc, (Entity)damagedPlayer, directionContext, violation, data, cc)) {
                    cancelled = true;
                }
            } else {
                if (reachEnabled && this.reach.check(player, loc, damaged, damagedLoc, data, cc)) {
                    cancelled = true;
                }
                if (directionEnabled && this.direction.check(player, loc, damaged, damagedLoc, data, cc)) {
                    cancelled = true;
                }
            }
        }
        if (this.angle.isEnabled(player)) {
            if (Combined.checkYawRate(player, loc.getYaw(), now, worldName, cc.yawRateCheck)) {
                cancelled = true;
            }
            if (this.angle.check(player, worldChanged, data, cc)) {
                if (!cancelled && cc.debug) {
                    System.out.println(player.getName() + " fight.angle cancel without yawrate cancel.");
                }
                cancelled = true;
            }
        }
        data.lastWorld = worldName;
        data.lastAttackTick = tick;
        data.lastAttackedX = damagedLoc.getX();
        data.lastAttackedY = damagedLoc.getY();
        data.lastAttackedZ = damagedLoc.getZ();
        if (!cancelled && TrigUtil.distance(loc.getX(), loc.getZ(), damagedLoc.getX(), damagedLoc.getZ()) < 4.5) {
            double hDist;
            MovingData mData = MovingData.getData(player);
            if (mData.fromX != Double.MAX_VALUE && mData.mediumLiftOff != MediumLiftOff.LIMIT_JUMP && (hDist = TrigUtil.distance(loc.getX(), loc.getZ(), mData.fromX, mData.fromZ)) >= 0.23) {
                MovingConfig mc = MovingConfig.getConfig(player);
                if (now <= mData.timeSprinting + mc.sprintingGrace && MovingListener.shouldCheckSurvivalFly(player, mData, mc)) {
                    mData.lostSprintCount = 7;
                    if ((cc.debug || mc.debug) && BuildParameters.debugLevel > 0) {
                        System.out.println(player.getName() + " (lostsprint) hDist to last from: " + hDist + " | targetdist=" + TrigUtil.distance(loc.getX(), loc.getZ(), damagedLoc.getX(), damagedLoc.getZ()) + " | sprinting=" + player.isSprinting() + " | food=" + player.getFoodLevel() + " | hbuf=" + mData.sfHorizontalBuffer);
                    }
                }
            }
        }
        if (!cancelled && data.attackPenalty.isPenalty(now)) {
            cancelled = true;
            if (cc.debug) {
                System.out.println(player.getName() + " ~ attack penalty.");
            }
        }
        this.useLoc1.setWorld(null);
        this.useLoc2.setWorld(null);
        return cancelled;
    }

    public static final boolean hasThorns(Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack[] contents = inv.getArmorContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getEnchantmentLevel(Enchantment.THORNS) <= 0) continue;
            return true;
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity damaged = event.getEntity();
        Player damagedPlayer = damaged instanceof Player ? (Player)damaged : null;
        FightData damagedData = damagedPlayer == null ? null : FightData.getData(damagedPlayer);
        boolean damagedIsDead = damaged.isDead();
        if (damagedPlayer != null && !damagedIsDead) {
            if (!damagedPlayer.isDead() && this.godMode.isEnabled(damagedPlayer) && this.godMode.check(damagedPlayer, BridgeHealth.getDamage(event), damagedData)) {
                damagedPlayer.setNoDamageTicks(0);
            }
            if (BridgeHealth.getHealth((LivingEntity)damagedPlayer) >= BridgeHealth.getMaxHealth((LivingEntity)damagedPlayer)) {
                if (damagedData.fastHealBuffer < 0L) {
                    damagedData.fastHealBuffer /= 2L;
                }
                damagedData.fastHealRefTime = System.currentTimeMillis();
            }
        }
        if (event instanceof EntityDamageByEntityEvent) {
            Entity source;
            Player player;
            EntityDamageByEntityEvent e = (EntityDamageByEntityEvent)event;
            Entity damager = e.getDamager();
            int tick = TickTask.getTick();
            if (damagedPlayer != null && !damagedIsDead) {
                FightData.getData((Player)damagedPlayer).damageTakenByEntityTick = tick;
                damagedData.thornsId = FightListener.hasThorns(damagedPlayer) ? damager.getEntityId() : Integer.MIN_VALUE;
            }
            EntityDamageEvent.DamageCause damageCause = event.getCause();
            Player attacker = player = damager instanceof Player ? (Player)damager : null;
            if (damager instanceof TNTPrimed && (source = ((TNTPrimed)damager).getSource()) instanceof Player) {
                attacker = (Player)source;
            }
            if (attacker != null && (damageCause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || damageCause == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION)) {
                FightData data = FightData.getData(attacker);
                data.lastExplosionEntityId = damaged.getEntityId();
                data.lastExplosionDamageTick = tick;
                return;
            }
            if (player != null) {
                double damage = BridgeHealth.getDamage((EntityDamageEvent)e);
                FightData data = FightData.getData(player);
                if (damageCause == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                    if (damaged.getEntityId() == data.lastExplosionEntityId && tick == data.lastExplosionDamageTick) {
                        data.lastExplosionDamageTick = -1;
                        data.lastExplosionEntityId = Integer.MAX_VALUE;
                    } else if (this.handleNormalDamage(player, damaged, damage, tick, data)) {
                        e.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityDamageMonitor(EntityDamageEvent event) {
        Entity damaged = event.getEntity();
        if (damaged instanceof Player) {
            Player player = (Player)damaged;
            FightData data = FightData.getData(player);
            int ndt = player.getNoDamageTicks();
            if (data.lastDamageTick == TickTask.getTick() && data.lastNoDamageTicks != ndt) {
                data.lastNoDamageTicks = ndt;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onEntityDeathEvent(EntityDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && this.godMode.isEnabled(player = (Player)entity)) {
            this.godMode.death(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onPlayerAnimation(PlayerAnimationEvent event) {
        FightData.getData((Player)event.getPlayer()).noSwingArmSwung = true;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        if (event.isSprinting()) {
            FightData.getData((Player)event.getPlayer()).knockbackSprintTime = System.currentTimeMillis();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityRegainHealthLow(EntityRegainHealthEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        if (this.fastHeal.isEnabled(player) && this.fastHeal.check(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        FightData data = FightData.getData(player);
        data.regainHealthTime = System.currentTimeMillis();
        double health = Math.min(BridgeHealth.getHealth((LivingEntity)player) + BridgeHealth.getAmount(event), BridgeHealth.getMaxHealth((LivingEntity)player));
        data.godModeHealth = Math.max(data.godModeHealth, health);
    }

    public void playerJoins(Player player) {
    }

    public void playerLeaves(Player player) {
        FightData data = FightData.getData(player);
        data.angleHits.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        FightData.getData(event.getPlayer()).onWorldChange();
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        long penalty = FightConfig.getConfig((Player)player).toolChangeAttackPenalty;
        if (penalty > 0L) {
            FightData.getData((Player)player).attackPenalty.applyPenalty(penalty);
        }
    }
}

