/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;

public class FastConsume
extends Check
implements Listener {
    public static void testAvailability() {
        if (!PlayerItemConsumeEvent.class.getSimpleName().equals("PlayerItemConsumeEvent")) {
            throw new RuntimeException("This exception should not even get thrown.");
        }
    }

    public FastConsume() {
        super(CheckType.INVENTORY_FASTCONSUME);
        ConfigManager.setForAllConfigs("checks.inventory.instanteat.active", false);
        LogUtil.logInfo("[NoCheatPlus] Inventory checks: FastConsume is available, disabled InstantEat.");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabled(player)) {
            return;
        }
        InventoryData data = InventoryData.getData(player);
        if (this.check(player, event.getItem(), data)) {
            event.setCancelled(true);
            DataManager.getPlayerData((String)player.getName(), (boolean)true).task.updateInventory();
        }
        data.instantEatInteract = 0L;
        data.instantEatFood = null;
    }

    private boolean check(Player player, ItemStack stack, InventoryData data) {
        long expectedDuration;
        Material mat;
        long ref;
        if (stack == null) {
            return false;
        }
        long time = System.currentTimeMillis();
        if (time < (ref = Math.max(data.instantEatInteract, data.lastClickTime))) {
            return false;
        }
        InventoryConfig cc = InventoryConfig.getConfig(player);
        Material material = mat = stack == null ? null : stack.getType();
        if (mat != null && (cc.fastConsumeWhitelist ? !cc.fastConsumeItems.contains(mat.getId()) : cc.fastConsumeItems.contains(mat.getId()))) {
            return false;
        }
        long timeSpent = ref == 0L ? 0L : time - ref;
        if (timeSpent < (expectedDuration = cc.fastConsumeDuration)) {
            float lag = TickTask.getLag(expectedDuration);
            if ((float)timeSpent * lag < (float)expectedDuration) {
                double difference = (double)((float)expectedDuration - (float)timeSpent * lag) / 100.0;
                data.instantEatVL += difference;
                ViolationData vd = new ViolationData(this, player, data.instantEatVL, difference, cc.fastConsumeActions);
                vd.setParameter(ParameterName.FOOD, "" + mat);
                if (data.instantEatFood != mat) {
                    vd.setParameter(ParameterName.TAGS, "inconsistent(" + data.instantEatFood + ")");
                } else {
                    vd.setParameter(ParameterName.TAGS, "");
                }
                if (this.executeActions(vd)) {
                    return true;
                }
            }
        } else {
            data.instantEatVL *= 0.6;
        }
        return false;
    }
}

