/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import org.bukkit.Location;
import org.bukkit.World;

public class LocUtil {
    public static final Location clone(Location loc) {
        return new Location(LocUtil.testWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public static final Location clone(Location loc, float yaw, float pitch) {
        return new Location(LocUtil.testWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ(), yaw, pitch);
    }

    public static final Location clone(Location setBack, Location ref) {
        if (setBack == null) {
            return LocUtil.clone(ref);
        }
        return LocUtil.clone(setBack, ref.getYaw(), ref.getPitch());
    }

    public static final Location clone(Location setBack, PlayerLocation ref) {
        if (setBack == null) {
            return ref.getLocation();
        }
        return LocUtil.clone(setBack, ref.getYaw(), ref.getPitch());
    }

    public static final void set(Location setBack, Location loc) {
        setBack.setWorld(LocUtil.testWorld(loc.getWorld()));
        setBack.setX(loc.getX());
        setBack.setY(loc.getY());
        setBack.setZ(loc.getZ());
        setBack.setYaw(loc.getYaw());
        setBack.setPitch(loc.getPitch());
    }

    public static final void set(Location setBack, PlayerLocation loc) {
        setBack.setWorld(LocUtil.testWorld(loc.getWorld()));
        setBack.setX(loc.getX());
        setBack.setY(loc.getY());
        setBack.setZ(loc.getZ());
        setBack.setYaw(loc.getYaw());
        setBack.setPitch(loc.getPitch());
    }

    private static World testWorld(World world) {
        if (world == null) {
            throw new NullPointerException("World must not be null.");
        }
        return world;
    }

    public static final boolean needsYawCorrection(float yaw) {
        return yaw == Float.NaN || yaw < 0.0f || yaw >= 360.0f;
    }

    public static final boolean needsPitchCorrection(float pitch) {
        return pitch == Float.NaN || pitch < -90.0f || pitch > 90.0f;
    }

    public static final boolean needsDirectionCorrection(float yaw, float pitch) {
        return LocUtil.needsYawCorrection(yaw) || LocUtil.needsPitchCorrection(pitch);
    }

    public static final float correctYaw(float yaw) {
        if (yaw == Float.NaN) {
            return 0.0f;
        }
        if (yaw >= 360.0f) {
            if (yaw > 10000.0f) {
                yaw = 0.0f;
            } else {
                while (yaw > 360.0f) {
                    yaw -= 360.0f;
                }
            }
        }
        if (yaw < 0.0f) {
            if (yaw < -10000.0f) {
                yaw = 0.0f;
            } else {
                while (yaw < 0.0f) {
                    yaw += 360.0f;
                }
            }
        }
        return yaw;
    }

    public static final float correctPitch(float pitch) {
        if (pitch == Float.NaN) {
            return 0.0f;
        }
        if (pitch < -90.0f) {
            return -90.0f;
        }
        if (pitch > 90.0f) {
            return 90.0f;
        }
        return pitch;
    }
}

