/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.Iterator;

public class LocationTrace {
    private final TraceEntry[] entries;
    private int index = -1;
    private int size = 0;
    private final double mergeDist;
    private final double mergeDistSq;

    public LocationTrace(int bufferSize, double mergeDist) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Expect bufferSize > 0, got instead: " + bufferSize);
        }
        this.entries = new TraceEntry[bufferSize];
        for (int i = 0; i < bufferSize; ++i) {
            this.entries[i] = new TraceEntry();
        }
        this.mergeDist = mergeDist;
        this.mergeDistSq = mergeDist * mergeDist;
    }

    public final void addEntry(long time, double x, double y, double z) {
        double lastDistSq = 0.0;
        if (this.size > 0) {
            TraceEntry latestEntry = this.entries[this.index];
            if (x == latestEntry.x && y == latestEntry.y && z == latestEntry.z) {
                latestEntry.time = time;
                return;
            }
            lastDistSq = TrigUtil.distanceSquared(x, y, z, latestEntry.x, latestEntry.y, latestEntry.z);
            if (this.size > 1 && lastDistSq <= this.mergeDistSq && latestEntry.lastDistSq <= this.mergeDistSq) {
                TraceEntry secondLatest = this.index - 1 < 0 ? this.entries[this.index - 1 + this.entries.length] : this.entries[this.index - 1];
                lastDistSq = TrigUtil.distanceSquared(x, y, z, secondLatest.x, secondLatest.y, secondLatest.z);
                latestEntry.set(time, x, y, z, lastDistSq);
                return;
            }
        }
        ++this.index;
        if (this.index == this.entries.length) {
            this.index = 0;
        }
        if (this.size < this.entries.length) {
            ++this.size;
        }
        TraceEntry newEntry = this.entries[this.index];
        newEntry.set(time, x, y, z, lastDistSq);
    }

    public void reset() {
        this.index = 0;
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getMaxSize() {
        return this.entries.length;
    }

    public double getMergeDist() {
        return this.mergeDist;
    }

    public TraceIterator latestIterator() {
        return new TraceIterator(this.entries, this.index, this.size, this.index, false);
    }

    public TraceIterator oldestIterator() {
        int currentIndex = this.index - this.size + 1;
        return new TraceIterator(this.entries, this.index, this.size, currentIndex < 0 ? currentIndex + this.entries.length : currentIndex, true);
    }

    public TraceIterator maxAgeIterator(long time) {
        int currentIndex;
        int tempIndex = currentIndex = this.index;
        for (int steps = 1; steps < this.size; ++steps) {
            if (--tempIndex < 0) {
                tempIndex += this.size;
            }
            TraceEntry entry = this.entries[tempIndex];
            if (entry.time < time) break;
            currentIndex = tempIndex;
        }
        return new TraceIterator(this.entries, this.index, this.size, currentIndex, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TraceIterator
    implements Iterator<TraceEntry> {
        private final TraceEntry[] entries;
        private final int index;
        private final int size;
        private int currentIndex;
        private final boolean ascend;

        protected TraceIterator(TraceEntry[] entries, int index, int size, int currentIndex, boolean ascend) {
            if (currentIndex >= entries.length || currentIndex < 0 || currentIndex <= index - size || currentIndex > index && currentIndex <= index - size + entries.length) {
                throw new IllegalArgumentException("startIndex out of bounds.");
            }
            this.entries = entries;
            this.index = index;
            this.size = size;
            this.currentIndex = currentIndex;
            this.ascend = ascend;
        }

        @Override
        public final TraceEntry next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("No more entries to iterate.");
            }
            TraceEntry entry = this.entries[this.currentIndex];
            if (this.ascend) {
                int ref;
                ++this.currentIndex;
                if (this.currentIndex >= this.entries.length) {
                    this.currentIndex = 0;
                }
                if ((ref = this.index - this.size + 1) < 0) {
                    ref += this.entries.length;
                }
                if (this.currentIndex == ref) {
                    this.currentIndex = -1;
                }
            } else {
                --this.currentIndex;
                if (this.currentIndex < 0) {
                    this.currentIndex = this.entries.length - 1;
                }
                if (this.currentIndex == this.index) {
                    this.currentIndex = -1;
                }
            }
            return entry;
        }

        @Override
        public final boolean hasNext() {
            return this.currentIndex >= 0 && this.currentIndex <= this.index && this.currentIndex > this.index - this.size || this.currentIndex > this.index && this.currentIndex >= this.index - this.size + this.entries.length;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class TraceEntry {
        public long time;
        public double x;
        public double y;
        public double z;
        public double lastDistSq;

        public void set(long time, double x, double y, double z, double lastDistSq) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.time = time;
            this.lastDistSq = lastDistSq;
        }
    }
}

