/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.moving.LocUtil;
import fr.neatmonster.nocheatplus.checks.moving.LocationTrace;
import fr.neatmonster.nocheatplus.checks.moving.MediumLiftOff;
import fr.neatmonster.nocheatplus.checks.moving.MoveConsistency;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.Velocity;
import fr.neatmonster.nocheatplus.utilities.ActionAccumulator;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class MovingData
extends ACheckData {
    private static final MediumLiftOff defaultMediumLiftOff = MediumLiftOff.LIMIT_JUMP;
    public static final CheckDataFactory factory = new CheckDataFactory(){

        public final ICheckData getData(Player player) {
            return MovingData.getData(player);
        }

        public ICheckData removeData(String playerName) {
            return MovingData.removeData(playerName);
        }

        public void removeAllData() {
            MovingData.clear();
        }
    };
    private static Map<String, MovingData> playersMap = new HashMap<String, MovingData>();
    public double creativeFlyVL = 0.0;
    public double morePacketsVL = 0.0;
    public double morePacketsVehicleVL = 0.0;
    public double noFallVL = 0.0;
    public double survivalFlyVL = 0.0;
    public int bunnyhopDelay;
    public double jumpAmplifier;
    public long timeSprinting = 0L;
    public int speedTick = 0;
    public float walkSpeed = 0.0f;
    public float flySpeed = 0.0f;
    public int verticalVelocityCounter;
    public double verticalFreedom;
    public double verticalVelocity;
    public int verticalVelocityUsed = 0;
    public final List<Velocity> hVelActive = new LinkedList<Velocity>();
    public final List<Velocity> hVelQueued = new LinkedList<Velocity>();
    public double fromX = Double.MAX_VALUE;
    public double fromY;
    public double fromZ;
    public double toX = Double.MAX_VALUE;
    public double toY;
    public double toZ;
    private LocationTrace trace = null;
    public boolean toWasReset;
    public boolean fromWasReset;
    public MediumLiftOff mediumLiftOff = defaultMediumLiftOff;
    private Location setBack = null;
    private Location teleported = null;
    public boolean creativeFlyPreviousRefused;
    public int morePacketsBuffer = 50;
    public long morePacketsLastTime;
    public int morePacketsPackets;
    private Location morePacketsSetback = null;
    public int morePacketsVehicleBuffer = 50;
    public long morePacketsVehicleLastTime;
    public int morePacketsVehiclePackets;
    private Location morePacketsVehicleSetback = null;
    public int morePacketsVehicleTaskId = -1;
    public float noFallFallDistance = 0.0f;
    public double noFallMaxY = 0.0;
    public boolean noFallAssumeGround = false;
    public boolean noFallSkipAirCheck = false;
    public double passableVL;
    public double sfHorizontalBuffer = 0.0;
    public int lostSprintCount = 0;
    public int sfJumpPhase = 0;
    public boolean sfDirty = false;
    public boolean sfLowJump = false;
    public boolean sfNoLowJump = false;
    public double sfLastYDist = Double.MAX_VALUE;
    public double sfLastHDist = Double.MAX_VALUE;
    public int sfHoverTicks = -1;
    public int sfHoverLoginTicks = 0;
    public int sfOnIce = 0;
    public long sfCobwebTime = 0L;
    public double sfCobwebVL = 0.0;
    public long sfVLTime = 0L;
    public final ActionAccumulator vDistAcc = new ActionAccumulator(3, 3);
    public boolean wasInVehicle = false;
    public MoveConsistency vehicleConsistency = MoveConsistency.INCONSISTENT;

    public static MovingData getData(Player player) {
        MovingData data = playersMap.get(player.getName());
        if (data == null) {
            data = new MovingData();
            playersMap.put(player.getName(), data);
        }
        return data;
    }

    public static ICheckData removeData(String playerName) {
        return playersMap.remove(playerName);
    }

    public static void clear() {
        playersMap.clear();
    }

    public static void onWorldUnload(World world) {
        String worldName = world.getName();
        for (MovingData data : playersMap.values()) {
            data.onWorldUnload(worldName);
        }
    }

    public static void onReload() {
        for (MovingData data : playersMap.values()) {
            data.deleteTrace();
        }
    }

    public void clearFlyData() {
        this.bunnyhopDelay = 0;
        this.sfJumpPhase = 0;
        this.jumpAmplifier = 0.0;
        this.setBack = null;
        this.sfLastHDist = Double.MAX_VALUE;
        this.sfLastYDist = Double.MAX_VALUE;
        this.toX = Double.MAX_VALUE;
        this.fromX = Double.MAX_VALUE;
        this.clearAccounting();
        this.clearNoFallData();
        this.removeAllVelocity();
        this.sfHorizontalBuffer = 0.0;
        this.lostSprintCount = 0;
        this.fromWasReset = false;
        this.toWasReset = false;
        this.sfHoverLoginTicks = -1;
        this.sfHoverTicks = -1;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.mediumLiftOff = defaultMediumLiftOff;
        this.vehicleConsistency = MoveConsistency.INCONSISTENT;
    }

    public void onSetBack(Location setBack) {
        this.resetPositions(this.teleported);
        this.setSetBack(this.teleported);
        this.morePacketsVehicleSetback = null;
        this.morePacketsSetback = null;
        this.clearAccounting();
        this.sfHorizontalBuffer = 0.0;
        this.lostSprintCount = 0;
        this.fromWasReset = false;
        this.toWasReset = false;
        this.sfHoverTicks = -1;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.mediumLiftOff = defaultMediumLiftOff;
        this.removeAllVelocity();
        this.vehicleConsistency = MoveConsistency.INCONSISTENT;
    }

    public void prepareSetBack(Location loc) {
        this.clearAccounting();
        this.sfJumpPhase = 0;
        this.sfLastHDist = Double.MAX_VALUE;
        this.sfLastYDist = Double.MAX_VALUE;
        this.toWasReset = false;
        this.fromWasReset = false;
        this.setTeleported(loc);
    }

    public void resetPositions(Location loc) {
        if (loc == null) {
            this.resetPositions(Double.MAX_VALUE, 0.0, 0.0);
        } else {
            this.resetPositions(loc.getX(), loc.getY(), loc.getZ());
        }
    }

    public void resetPositions(PlayerLocation loc) {
        if (loc == null) {
            this.resetPositions(Double.MAX_VALUE, 0.0, 0.0);
        } else {
            this.resetPositions(loc.getX(), loc.getY(), loc.getZ());
        }
    }

    public void resetPositions(double x, double y, double z) {
        this.fromX = this.toX = x;
        this.fromY = this.toY = y;
        this.fromZ = this.toZ = z;
        this.sfLastHDist = Double.MAX_VALUE;
        this.sfLastYDist = Double.MAX_VALUE;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.mediumLiftOff = defaultMediumLiftOff;
    }

    public void clearAccounting() {
        this.vDistAcc.clear();
    }

    public void clearMorePacketsData() {
        this.morePacketsSetback = null;
        this.morePacketsVehicleSetback = null;
    }

    public void clearNoFallData() {
        this.noFallFallDistance = 0.0f;
        this.noFallMaxY = 0.0;
        this.noFallSkipAirCheck = false;
    }

    public void setSetBack(PlayerLocation loc) {
        if (this.setBack == null) {
            this.setBack = loc.getLocation();
        } else {
            LocUtil.set(this.setBack, loc);
        }
    }

    public void setSetBack(Location loc) {
        if (this.setBack == null) {
            this.setBack = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.setBack, loc);
        }
    }

    public Location getSetBack(Location ref) {
        return LocUtil.clone(this.setBack, ref);
    }

    public Location getSetBack(PlayerLocation ref) {
        return LocUtil.clone(this.setBack, ref);
    }

    public boolean hasSetBack() {
        return this.setBack != null;
    }

    public boolean hasSetBackWorldChanged(Location loc) {
        if (this.setBack == null) {
            return true;
        }
        return this.setBack.getWorld().equals(loc.getWorld());
    }

    public double getSetBackX() {
        return this.setBack.getX();
    }

    public double getSetBackY() {
        return this.setBack.getY();
    }

    public double getSetBackZ() {
        return this.setBack.getZ();
    }

    public void setSetBackY(double y) {
        this.setBack.setY(y);
    }

    public final Location getTeleported() {
        return this.teleported == null ? this.teleported : LocUtil.clone(this.teleported);
    }

    public final void setTeleported(Location loc) {
        this.teleported = LocUtil.clone(loc);
    }

    public boolean hasMorePacketsSetBack() {
        return this.morePacketsSetback != null;
    }

    public final void setMorePacketsSetBack(PlayerLocation loc) {
        if (this.morePacketsSetback == null) {
            this.morePacketsSetback = loc.getLocation();
        } else {
            LocUtil.set(this.morePacketsSetback, loc);
        }
    }

    public final void setMorePacketsSetBack(Location loc) {
        if (this.morePacketsSetback == null) {
            this.morePacketsSetback = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.morePacketsSetback, loc);
        }
    }

    public Location getMorePacketsSetBack() {
        return LocUtil.clone(this.morePacketsSetback);
    }

    public boolean hasMorePacketsVehicleSetBack() {
        return this.morePacketsVehicleSetback != null;
    }

    public final void setMorePacketsVehicleSetBack(PlayerLocation loc) {
        if (this.morePacketsVehicleSetback == null) {
            this.morePacketsVehicleSetback = loc.getLocation();
        } else {
            LocUtil.set(this.morePacketsVehicleSetback, loc);
        }
    }

    public final void setMorePacketsVehicleSetBack(Location loc) {
        if (this.morePacketsVehicleSetback == null) {
            this.morePacketsVehicleSetback = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.morePacketsVehicleSetback, loc);
        }
    }

    public final Location getMorePacketsVehicleSetBack() {
        return LocUtil.clone(this.morePacketsVehicleSetback);
    }

    public final void resetTeleported() {
        this.teleported = null;
    }

    public final void resetSetBack() {
        this.setBack = null;
    }

    public final void setTo(Location to) {
        this.toX = to.getX();
        this.toY = to.getY();
        this.toZ = to.getZ();
    }

    public void addHorizontalVelocity(Velocity vel) {
        this.hVelQueued.add(vel);
    }

    public void removeAllVelocity() {
        this.hVelActive.clear();
        this.hVelQueued.clear();
    }

    public void removeInvalidVelocity(int tick) {
        Velocity vel;
        Iterator<Velocity> it = this.hVelActive.iterator();
        while (it.hasNext()) {
            vel = it.next();
            if (vel.valCount > 0 && !(vel.value <= 0.001)) continue;
            it.remove();
        }
        it = this.hVelQueued.iterator();
        while (it.hasNext()) {
            vel = it.next();
            if (vel.actCount > 0 && vel.tick >= tick) continue;
            it.remove();
        }
    }

    public void velocityTick() {
        for (Velocity vel : this.hVelActive) {
            --vel.valCount;
            vel.sum += vel.value;
            vel.value *= 0.93;
        }
        Iterator<Velocity> it = this.hVelQueued.iterator();
        while (it.hasNext()) {
            --it.next().actCount;
        }
        if (this.verticalVelocity <= 0.09) {
            ++this.verticalVelocityUsed;
            --this.verticalVelocityCounter;
        } else if (this.verticalVelocityCounter > 0) {
            ++this.verticalVelocityUsed;
            this.verticalFreedom += this.verticalVelocity;
            this.verticalVelocity = Math.max(0.0, this.verticalVelocity - 0.09);
        } else if (this.verticalFreedom > 0.001) {
            if (this.verticalVelocityUsed == 1 && this.verticalVelocity > 1.0) {
                this.verticalVelocityUsed = 0;
                this.verticalVelocity = 0.0;
                this.verticalFreedom = 0.0;
            } else {
                ++this.verticalVelocityUsed;
                this.verticalFreedom *= 0.93;
            }
        }
    }

    public double getHorizontalFreedom() {
        double f = 0.0;
        for (Velocity vel : this.hVelActive) {
            f += vel.value;
        }
        return f;
    }

    public double useHorizontalVelocity(double amount) {
        Iterator<Velocity> it = this.hVelQueued.iterator();
        double used = 0.0;
        while (it.hasNext()) {
            Velocity vel = it.next();
            used += vel.value;
            this.hVelActive.add(vel);
            it.remove();
            if (!(used >= amount)) continue;
            break;
        }
        return used;
    }

    public boolean isSetBack(Location loc) {
        if (loc == null || this.setBack == null) {
            return false;
        }
        if (!loc.getWorld().getName().equals(this.setBack.getWorld().getName())) {
            return false;
        }
        return loc.getX() == this.setBack.getX() && loc.getY() == this.setBack.getY() && loc.getZ() == this.setBack.getZ();
    }

    public void onPlayerLeave() {
        this.removeAllVelocity();
        this.deleteTrace();
    }

    public void onWorldUnload(String worldName) {
        if (this.teleported != null && worldName.equalsIgnoreCase(this.teleported.getWorld().getName())) {
            this.resetTeleported();
        }
        if (this.setBack != null && worldName.equalsIgnoreCase(this.setBack.getWorld().getName())) {
            this.clearFlyData();
        }
        if (this.morePacketsSetback != null && worldName.equalsIgnoreCase(this.morePacketsSetback.getWorld().getName()) || this.morePacketsVehicleSetback != null && worldName.equalsIgnoreCase(this.morePacketsVehicleSetback.getWorld().getName())) {
            this.clearMorePacketsData();
            this.clearNoFallData();
        }
    }

    public void adjustWalkSpeed(float walkSpeed, int tick, int speedGrace) {
        if (walkSpeed > this.walkSpeed) {
            this.walkSpeed = walkSpeed;
            this.speedTick = tick;
        } else if (walkSpeed < this.walkSpeed) {
            if (tick - this.speedTick > speedGrace) {
                this.walkSpeed = walkSpeed;
                this.speedTick = tick;
            }
        } else {
            this.speedTick = tick;
        }
    }

    public void adjustFlySpeed(float flySpeed, int tick, int speedGrace) {
        if (flySpeed > this.flySpeed) {
            this.flySpeed = flySpeed;
            this.speedTick = tick;
        } else if (flySpeed < this.flySpeed) {
            if (tick - this.speedTick > speedGrace) {
                this.flySpeed = flySpeed;
                this.speedTick = tick;
            }
        } else {
            this.speedTick = tick;
        }
    }

    public boolean hasTrace() {
        return this.trace != null;
    }

    public LocationTrace getTrace(Player player) {
        if (this.trace == null) {
            MovingConfig cc = MovingConfig.getConfig(player);
            this.trace = new LocationTrace(cc.traceSize, cc.traceMergeDist);
        }
        return this.trace;
    }

    public void resetTrace(Player player, Location loc, long time) {
        MovingConfig cc = MovingConfig.getConfig(player);
        this.resetTrace(loc, time, cc.traceSize, cc.traceMergeDist);
    }

    public LocationTrace updateTrace(Player player, Location loc, long time) {
        LocationTrace trace = this.getTrace(player);
        trace.addEntry(time, loc.getX(), loc.getY(), loc.getZ());
        return trace;
    }

    public void resetTrace(Location loc, long time, int size, double mergeDist) {
        if (this.trace == null || this.trace.getMaxSize() != size || this.trace.getMergeDist() != mergeDist) {
            this.trace = new LocationTrace(size, mergeDist);
        } else {
            this.trace.reset();
        }
        this.trace.addEntry(time, loc.getX(), loc.getY(), loc.getZ());
    }

    public void deleteTrace() {
        this.trace = null;
    }
}

