/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MediumLiftOff;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.Velocity;
import fr.neatmonster.nocheatplus.utilities.ActionAccumulator;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurvivalFly
extends Check {
    private static final String DOUBLE_BUNNY = "doublebunny";
    public static final double walkSpeed = 0.221;
    public static final double modSneak = 0.5882352941176471;
    public static final double modSprint = 1.3122171945701357;
    public static final double modBlock = 0.7239819004524887;
    public static final double modSwim = 0.5203619909502263;
    public static final double modWeb = 0.4751131221719457;
    public static final double modIce = 2.5;
    public static final double modDownStream = 1.6521739130434783;
    public static final double hBufMax = 1.0;
    public static final double climbSpeed = 0.29;
    private static final int bunnyHopMax = 10;
    private static final double bunnyDivFriction = 130.0;
    private final ArrayList<String> tags = new ArrayList(15);
    private final Set<String> reallySneaking = new HashSet<String>(30);
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public SurvivalFly() {
        super(CheckType.MOVING_SURVIVALFLY);
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, long now) {
        double result;
        double hFreedom;
        boolean downStream;
        boolean sprinting;
        this.tags.clear();
        double xDistance = to.getX() - from.getX();
        double yDistance = to.getY() - from.getY();
        double zDistance = to.getZ() - from.getZ();
        double hDistance = Math.sqrt(xDistance * xDistance + zDistance * zDistance);
        if (!data.hasSetBack()) {
            data.setSetBack(from);
        }
        boolean fromOnGround = from.isOnGround();
        boolean toOnGround = to.isOnGround();
        boolean resetTo = toOnGround || to.isResetCond();
        double walkSpeed = 0.221 * ((double)data.walkSpeed / 0.2);
        if (data.lostSprintCount > 0) {
            if (resetTo && (fromOnGround || from.isResetCond()) || hDistance <= walkSpeed) {
                data.lostSprintCount = 0;
                this.tags.add("invalidate_lostsprint");
                sprinting = false;
            } else {
                this.tags.add("lostsprint");
                sprinting = true;
                data.lostSprintCount = data.lostSprintCount < 3 && to.isOnGround() || to.isResetCond() ? 0 : --data.lostSprintCount;
            }
        } else if (now <= data.timeSprinting + cc.sprintingGrace) {
            if (now != data.timeSprinting) {
                this.tags.add("sprintgrace");
            }
            sprinting = true;
        } else {
            sprinting = false;
        }
        boolean resetFrom = fromOnGround || from.isResetCond() ? true : this.lostGround(player, from, to, hDistance, yDistance, sprinting, data, cc);
        --data.bunnyhopDelay;
        boolean bl = downStream = hDistance > walkSpeed * 0.5203619909502263 && from.isInLiquid() && from.isDownStream(xDistance, zDistance);
        if (from.isOnIce() || to.isOnIce()) {
            data.sfOnIce = 20;
        } else if (data.sfOnIce > 0) {
            --data.sfOnIce;
        }
        double hAllowedDistance = this.getAllowedhDist(player, from, to, sprinting, downStream, hDistance, walkSpeed, data, cc, false);
        double hDistanceAboveLimit = hDistance - hAllowedDistance;
        if (hDistanceAboveLimit > 0.0) {
            double[] res = this.hDistAfterFailure(player, from, to, walkSpeed, hAllowedDistance, hDistance, hDistanceAboveLimit, yDistance, sprinting, downStream, data, cc, false);
            hAllowedDistance = res[0];
            hDistanceAboveLimit = res[1];
            hFreedom = res[2];
        } else {
            data.hVelActive.clear();
            hFreedom = 0.0;
            if (resetFrom && data.bunnyhopDelay <= 6) {
                data.bunnyhopDelay = 0;
            }
        }
        if (hDistanceAboveLimit <= 0.0 && hDistance > 0.1 && yDistance == 0.0 && data.sfLastYDist == 0.0 && !toOnGround && !fromOnGround && BlockProperties.isLiquid(to.getTypeId())) {
            hDistanceAboveLimit = Math.max(hDistanceAboveLimit, hDistance);
            this.tags.add("waterwalk");
        }
        if (sprinting && data.lostSprintCount == 0 && !cc.assumeSprint && hDistance > walkSpeed && data.hVelActive.isEmpty() && TrigUtil.isMovingBackwards(xDistance, zDistance, from.getYaw()) && !player.hasPermission("nocheatplus.checks.moving.survivalfly.sprinting")) {
            hDistanceAboveLimit = Math.max(hDistanceAboveLimit, hDistance);
            this.tags.add("sprintback");
        }
        if (data.sfDirty) {
            if (resetFrom || resetTo) {
                data.sfDirty = false;
            } else {
                this.tags.add("dirty");
            }
        }
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        if (from.isInWeb()) {
            double[] res = this.vDistWeb(player, from, to, toOnGround, hDistanceAboveLimit, yDistance, now, data, cc);
            vAllowedDistance = res[0];
            vDistanceAboveLimit = res[1];
            if (res[0] == Double.MIN_VALUE && res[1] == Double.MIN_VALUE) {
                if (cc.debug) {
                    this.tags.add("silentsbcobweb");
                    this.outputDebug(player, to, data, cc, hDistance, hAllowedDistance, hFreedom, yDistance, vAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo);
                }
                return data.getSetBack(to);
            }
        } else if (data.verticalFreedom <= 0.001 && from.isOnClimbable()) {
            vDistanceAboveLimit = this.vDistClimbable(from, fromOnGround, toOnGround, yDistance, data);
        } else if (data.verticalFreedom <= 0.001 && from.isInLiquid() && (Math.abs(yDistance) > 0.2 || to.isInLiquid())) {
            double[] res = this.vDistLiquid(from, to, toOnGround, yDistance, data);
            vAllowedDistance = res[0];
            vDistanceAboveLimit = res[1];
        } else {
            int maxJumpPhase;
            vAllowedDistance = 1.35 + data.verticalFreedom;
            if (data.mediumLiftOff == MediumLiftOff.LIMIT_JUMP) {
                maxJumpPhase = 3;
                data.sfNoLowJump = true;
                if (data.sfJumpPhase > 0) {
                    this.tags.add("limitjump");
                }
            } else if (data.jumpAmplifier > 0.0) {
                vAllowedDistance += 0.6 + data.jumpAmplifier - 1.0;
                maxJumpPhase = (int)(9.0 + (data.jumpAmplifier - 1.0) * 6.0);
            } else {
                maxJumpPhase = 6;
            }
            if (data.sfJumpPhase > maxJumpPhase && data.verticalVelocityCounter <= 0) {
                if (data.sfDirty || yDistance < 0.0 || resetFrom) {
                    if (data.getSetBackY() > to.getY()) {
                        if (data.sfJumpPhase <= 2 * maxJumpPhase) {
                            vAllowedDistance -= Math.max(0.0, (double)(data.sfJumpPhase - maxJumpPhase) * 0.15);
                        }
                    } else {
                        vAllowedDistance -= Math.max(0.0, (double)(data.sfJumpPhase - maxJumpPhase) * 0.15);
                    }
                } else if (!data.sfDirty) {
                    this.tags.add("maxphase");
                    vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.max(yDistance, 0.15));
                }
            }
            if ((vDistanceAboveLimit = Math.max(vDistanceAboveLimit, to.getY() - data.getSetBackY() - vAllowedDistance)) > 0.0) {
                this.tags.add("vdist");
            }
            if (!resetFrom && !resetTo) {
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, this.inAirChecks(now, from, to, hDistance, yDistance, data, cc));
            }
            if ((fromOnGround || data.noFallAssumeGround) && toOnGround && Math.abs(yDistance - 1.0) <= cc.yStep && vDistanceAboveLimit <= 0.0 && yDistance > 0.52 + data.jumpAmplifier * 0.2 && !player.hasPermission("nocheatplus.checks.moving.survivalfly.step")) {
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance));
                this.tags.add("step");
            }
        }
        if (cc.debug) {
            this.outputDebug(player, to, data, cc, hDistance, hAllowedDistance, hFreedom, yDistance, vAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo);
        }
        if ((result = (Math.max(hDistanceAboveLimit, 0.0) + Math.max(vDistanceAboveLimit, 0.0)) * 100.0) > 0.0) {
            Location vLoc = this.handleViolation(now, result, player, from, to, data, cc);
            if (vLoc != null) {
                return vLoc;
            }
        } else {
            if (now - data.sfVLTime > cc.survivalFlyVLFreeze) {
                data.survivalFlyVL *= 0.95;
            }
            if (hDistanceAboveLimit < 0.0 && result <= 0.0 && hDistance > 0.0 && data.sfHorizontalBuffer < 1.0) {
                this.hBufRegain(hDistance, Math.min(0.2, Math.abs(hDistanceAboveLimit)), data);
            }
        }
        if (to.isInLiquid()) {
            data.mediumLiftOff = fromOnGround && !toOnGround && data.mediumLiftOff == MediumLiftOff.GROUND && data.sfJumpPhase <= 0 && !from.isInLiquid() ? MediumLiftOff.GROUND : (to.isNextToGround(0.15, 0.4) ? MediumLiftOff.GROUND : MediumLiftOff.LIMIT_JUMP);
        } else if (to.isInWeb()) {
            data.mediumLiftOff = MediumLiftOff.LIMIT_JUMP;
        } else if (resetTo) {
            data.mediumLiftOff = MediumLiftOff.GROUND;
        } else if (from.isInLiquid()) {
            data.mediumLiftOff = !resetTo && data.mediumLiftOff == MediumLiftOff.GROUND && data.sfJumpPhase <= 0 ? MediumLiftOff.GROUND : (to.isNextToGround(0.15, 0.4) ? MediumLiftOff.GROUND : MediumLiftOff.LIMIT_JUMP);
        } else if (from.isInWeb()) {
            data.mediumLiftOff = MediumLiftOff.LIMIT_JUMP;
        } else if (resetFrom || data.noFallAssumeGround) {
            data.mediumLiftOff = MediumLiftOff.GROUND;
        }
        if (data.verticalVelocityUsed > cc.velocityGraceTicks && yDistance <= 0.0 && data.sfLastYDist > 0.0 && data.sfLastYDist != Double.MAX_VALUE) {
            data.verticalVelocityCounter = 0;
            data.verticalVelocity = 0.0;
        }
        if (resetTo) {
            if (toOnGround) {
                if (data.bunnyhopDelay > 0 && yDistance > 0.0 && to.getY() > data.getSetBackY() && !from.isResetCond() && !to.isResetCond()) {
                    data.bunnyhopDelay = 0;
                }
                if (data.verticalVelocityUsed > cc.velocityGraceTicks && yDistance < 0.0) {
                    data.verticalVelocityCounter = 0;
                    data.verticalFreedom = 0.0;
                    data.verticalVelocity = 0.0;
                    data.verticalVelocityUsed = 0;
                }
            }
            data.setSetBack(to);
            data.sfJumpPhase = 0;
            data.clearAccounting();
            data.sfLowJump = false;
            data.sfNoLowJump = false;
        } else if (resetFrom) {
            data.setSetBack(from);
            data.sfJumpPhase = 1;
            data.clearAccounting();
            data.sfLowJump = false;
        } else {
            ++data.sfJumpPhase;
        }
        double d = cc.velocityStrictInvalidation ? hAllowedDistance : hAllowedDistance / 2.0;
        if (hDistance <= d) {
            data.hVelActive.clear();
        }
        data.sfLastHDist = hDistance;
        data.sfLastYDist = yDistance;
        data.toWasReset = resetTo || data.noFallAssumeGround;
        data.fromWasReset = resetFrom || data.noFallAssumeGround;
        return null;
    }

    private double getAllowedhDist(Player player, PlayerLocation from, PlayerLocation to, boolean sprinting, boolean downStream, double hDistance, double walkSpeed, MovingData data, MovingConfig cc, boolean checkPermissions) {
        double speedAmplifier;
        double hAllowedDistance = 0.0;
        boolean sfDirty = data.sfDirty;
        if (from.isInWeb()) {
            data.sfOnIce = 0;
            hAllowedDistance = 0.4751131221719457 * walkSpeed * (double)cc.survivalFlyWalkingSpeed / 100.0;
        } else if (from.isInLiquid() && to.isInLiquid()) {
            hAllowedDistance = 0.5203619909502263 * walkSpeed * (double)cc.survivalFlySwimmingSpeed / 100.0;
        } else if (!(sfDirty || !player.isSneaking() || !this.reallySneaking.contains(player.getName()) || checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.sneaking"))) {
            hAllowedDistance = 0.5882352941176471 * walkSpeed * (double)cc.survivalFlySneakingSpeed / 100.0;
        } else if (!(sfDirty || !player.isBlocking() || checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.blocking"))) {
            hAllowedDistance = 0.7239819004524887 * walkSpeed * (double)cc.survivalFlyBlockingSpeed / 100.0;
        } else {
            hAllowedDistance = !sprinting ? walkSpeed * (double)cc.survivalFlyWalkingSpeed / 100.0 : walkSpeed * 1.3122171945701357 * (double)cc.survivalFlySprintingSpeed / 100.0;
            if (checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.speeding")) {
                hAllowedDistance *= (double)cc.survivalFlySpeedingSpeed / 100.0;
            }
        }
        if (downStream) {
            hAllowedDistance *= 1.6521739130434783;
        }
        if (hDistance <= hAllowedDistance && !cc.debug) {
            return hAllowedDistance;
        }
        if (data.sfOnIce > 0) {
            hAllowedDistance *= 2.5;
        }
        if ((speedAmplifier = this.mcAccess.getFasterMovementAmplifier(player)) != Double.NEGATIVE_INFINITY) {
            hAllowedDistance *= 1.0 + 0.2 * (speedAmplifier + 1.0);
        }
        return hAllowedDistance;
    }

    private boolean lostGround(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        if (yDistance >= -0.5 && yDistance <= 0.52 + data.jumpAmplifier * 0.2) {
            if (from.isAboveStairs()) {
                this.applyLostGround(player, from, true, data, "stairs");
                return true;
            }
            if (yDistance <= 0.0 && this.lostGroundDescend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
                return true;
            }
            if (yDistance >= 0.0 && this.lostGroundAscend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
                return true;
            }
        } else if (yDistance < -0.5 && hDistance <= 0.5 && this.lostGroundFastDescend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
            return true;
        }
        return false;
    }

    private double inAirChecks(long now, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, MovingData data, MovingConfig cc) {
        boolean yDirChange;
        double vDistanceAboveLimit = 0.0;
        boolean bl = yDirChange = data.sfLastYDist != Double.MAX_VALUE && data.sfLastYDist != yDistance && (yDistance <= 0.0 && data.sfLastYDist >= 0.0 || yDistance >= 0.0 && data.sfLastYDist <= 0.0);
        if (yDirChange) {
            vDistanceAboveLimit = this.yDirChange(from, to, yDistance, vDistanceAboveLimit, data);
        }
        if (cc.survivalFlyAccountingV) {
            if (yDirChange && data.sfLastYDist > 0.0) {
                data.vDistAcc.clear();
                data.vDistAcc.add((float)yDistance);
            } else if (data.verticalFreedom <= 0.001) {
                if (yDistance != 0.0) {
                    data.vDistAcc.add((float)yDistance);
                    double accAboveLimit = SurvivalFly.verticalAccounting(yDistance, data.vDistAcc, this.tags, "vacc");
                    if (accAboveLimit > vDistanceAboveLimit) {
                        vDistanceAboveLimit = accAboveLimit;
                    }
                }
            } else {
                data.vDistAcc.clear();
            }
        }
        return vDistanceAboveLimit;
    }

    private static final double verticalAccounting(double yDistance, ActionAccumulator acc, ArrayList<String> tags, String tag) {
        int i1 = 1;
        int i2 = 2;
        if (acc.bucketCount(i1) > 0 && acc.bucketCount(i2) > 0) {
            float sc1 = acc.bucketScore(i1);
            float sc2 = acc.bucketScore(i2);
            double diff = sc1 - sc2;
            double aDiff = Math.abs(diff);
            if (diff >= 0.0 || yDistance > -1.05 && aDiff < 0.0625) {
                if (yDistance <= -1.05 && (double)sc2 < -10.0 && (double)sc1 < -10.0) {
                    tags.add(tag + "grace");
                    return 0.0;
                }
                tags.add(tag);
                if (diff < 0.0) {
                    return Math.max(Math.abs(-0.0625 - diff), 0.001);
                }
                return 0.0625 + diff;
            }
        }
        return 0.0;
    }

    private double yDirChange(PlayerLocation from, PlayerLocation to, double yDistance, double vDistanceAboveLimit, MovingData data) {
        if (yDistance > 0.0) {
            if (data.toWasReset) {
                this.tags.add("ychinc");
            } else if (data.verticalFreedom <= 0.001 && data.bunnyhopDelay < 9 && (!data.fromWasReset || data.sfLastYDist != 0.0)) {
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance));
                this.tags.add("ychincfly");
            } else {
                this.tags.add("ychincair");
            }
        } else {
            double setBackYDistance;
            this.tags.add("ychdec");
            if (!data.sfNoLowJump && !data.sfDirty && data.mediumLiftOff == MediumLiftOff.GROUND && (setBackYDistance = to.getY() - data.getSetBackY()) > 0.0) {
                Player player = from.getPlayer();
                double estimate = 1.15;
                if (data.jumpAmplifier > 0.0) {
                    estimate += 0.5 * this.getJumpAmplifier(player);
                }
                if (setBackYDistance < estimate) {
                    int refY;
                    long flags = 132L;
                    if ((BlockProperties.getBlockFlags(from.getTypeIdAbove()) & 0x84L) == 0L && ((refY = Location.locToBlock((double)(from.getY() + 0.5))) == from.getBlockY() || (BlockProperties.getBlockFlags(from.getTypeId(from.getBlockX(), refY, from.getBlockZ())) & 0x84L) == 0L)) {
                        this.tags.add("lowjump");
                        data.sfLowJump = true;
                    }
                }
            }
        }
        return vDistanceAboveLimit;
    }

    private double[] hDistAfterFailure(Player player, PlayerLocation from, PlayerLocation to, double walkSpeed, double hAllowedDistance, double hDistance, double hDistanceAboveLimit, double yDistance, boolean sprinting, boolean downStream, MovingData data, MovingConfig cc, boolean skipPermChecks) {
        if ((hDistanceAboveLimit = this.bunnyHop(from, to, hDistance, hAllowedDistance, hDistanceAboveLimit, yDistance, sprinting, data)) > 0.0 && !skipPermChecks) {
            hAllowedDistance = this.getAllowedhDist(player, from, to, sprinting, downStream, hDistance, walkSpeed, data, cc, true);
            hDistanceAboveLimit = hDistance - hAllowedDistance;
            this.tags.add("permchecks");
        }
        double hFreedom = 0.0;
        if (hDistanceAboveLimit > 0.0) {
            hFreedom = data.getHorizontalFreedom();
            if (hFreedom < hDistanceAboveLimit) {
                hFreedom += data.useHorizontalVelocity(hDistanceAboveLimit - hFreedom);
            }
            if (hFreedom > 0.0) {
                this.tags.add("hvel");
                hDistanceAboveLimit = Math.max(0.0, hDistanceAboveLimit - hFreedom);
            }
        }
        if (hDistanceAboveLimit > 0.0) {
            hDistanceAboveLimit = this.bunnyHop(from, to, hDistance, hAllowedDistance, hDistanceAboveLimit, yDistance, sprinting, data);
        }
        if (hDistanceAboveLimit > 0.0 && data.sfHorizontalBuffer > 0.0) {
            this.tags.add("hbufuse");
            double amount = Math.min(data.sfHorizontalBuffer, hDistanceAboveLimit);
            hDistanceAboveLimit -= amount;
            data.sfHorizontalBuffer = Math.max(0.0, data.sfHorizontalBuffer - amount);
        }
        if (hDistanceAboveLimit > 0.0) {
            this.tags.add("hspeed");
        }
        return new double[]{hAllowedDistance, hDistanceAboveLimit, hFreedom};
    }

    private double bunnyHop(PlayerLocation from, PlayerLocation to, double hDistance, double hAllowedDistance, double hDistanceAboveLimit, double yDistance, boolean sprinting, MovingData data) {
        double someThreshold = hAllowedDistance / 3.3;
        boolean allowHop = true;
        if (data.bunnyhopDelay > 0 && hDistance > 0.221) {
            allowHop = false;
            if (data.sfLastHDist != Double.MAX_VALUE && hDistance - data.sfLastHDist >= 0.1105 && data.bunnyhopDelay == 9 && data.sfLastYDist == 0.0 && (data.fromWasReset || data.toWasReset) && yDistance >= 0.4) {
                this.tags.add(DOUBLE_BUNNY);
                allowHop = true;
            }
            if (data.sfLastHDist != Double.MAX_VALUE && data.sfLastHDist - hDistance >= data.sfLastHDist / 130.0 && hDistanceAboveLimit <= someThreshold) {
                hDistanceAboveLimit = 0.0;
                if (data.bunnyhopDelay == 1 && !to.isOnGround() && !to.isResetCond()) {
                    ++data.bunnyhopDelay;
                    this.tags.add("bunnyfly(keep)");
                } else {
                    this.tags.add("bunnyfly(" + data.bunnyhopDelay + ")");
                }
            }
            if (data.bunnyhopDelay <= 6 && (from.isOnGround() || data.noFallAssumeGround)) {
                allowHop = true;
            }
        }
        if (allowHop && hDistance >= 0.221) {
            double d = sprinting ? 0.005 : 0.0016;
            if (hDistanceAboveLimit > d && hDistanceAboveLimit <= hAllowedDistance + someThreshold && (data.mediumLiftOff != MediumLiftOff.LIMIT_JUMP && (data.sfLastHDist == Double.MAX_VALUE || hDistance - data.sfLastHDist >= someThreshold) && (data.sfJumpPhase == 0 && from.isOnGround() || data.sfJumpPhase <= 1 && data.noFallAssumeGround) && !from.isResetCond() && !to.isResetCond() || this.tags.contains(DOUBLE_BUNNY))) {
                data.bunnyhopDelay = 10;
                hDistanceAboveLimit = 0.0;
                this.tags.add("bunnyhop");
            }
        }
        return hDistanceAboveLimit;
    }

    private void hBufRegain(double hDistance, double amount, MovingData data) {
        data.sfHorizontalBuffer = Math.min(1.0, data.sfHorizontalBuffer + amount);
    }

    private double[] vDistLiquid(PlayerLocation from, PlayerLocation to, boolean toOnGround, double yDistance, MovingData data) {
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        data.sfNoLowJump = true;
        if (yDistance >= 0.0 && (vDistanceAboveLimit = yDistance - (vAllowedDistance = 0.135)) > 0.0) {
            if (yDistance <= 0.5 && (data.mediumLiftOff == MediumLiftOff.GROUND && !BlockProperties.isLiquid(from.getTypeIdAbove()) || !to.isInLiquid() || toOnGround || data.sfLastYDist != Double.MAX_VALUE && data.sfLastYDist - yDistance >= 0.01 || to.isAboveStairs())) {
                vAllowedDistance = 0.615;
                vDistanceAboveLimit = yDistance - vAllowedDistance;
            }
            if (vDistanceAboveLimit > 0.0) {
                this.tags.add("swimup");
            }
        }
        return new double[]{vAllowedDistance, vDistanceAboveLimit};
    }

    private double vDistClimbable(PlayerLocation from, boolean fromOnGround, boolean toOnGround, double yDistance, MovingData data) {
        double vDistanceAboveLimit = 0.0;
        data.sfNoLowJump = true;
        double jumpHeight = 1.35 + (data.jumpAmplifier > 0.0 ? 0.6 + data.jumpAmplifier - 1.0 : 0.0);
        if (yDistance > 0.29 && !from.isOnGround(jumpHeight, 0.0, 0.0, 512L)) {
            this.tags.add("climbspeed");
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, yDistance - 0.29);
        }
        if (!(!(yDistance > 0.0) || fromOnGround || toOnGround || data.noFallAssumeGround || from.canClimbUp(jumpHeight))) {
            this.tags.add("climbup");
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, yDistance);
        }
        return vDistanceAboveLimit;
    }

    private double[] vDistWeb(Player player, PlayerLocation from, PlayerLocation to, boolean toOnGround, double hDistanceAboveLimit, double yDistance, long now, MovingData data, MovingConfig cc) {
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        data.sfNoLowJump = true;
        data.jumpAmplifier = 0.0;
        if (yDistance >= 0.0) {
            if (toOnGround && yDistance <= 0.5) {
                vAllowedDistance = yDistance;
                if (yDistance > 0.0) {
                    this.tags.add("web_step");
                }
            } else {
                vAllowedDistance = from.isOnGround() ? 0.1 : 0.0;
            }
            vDistanceAboveLimit = yDistance - vAllowedDistance;
        }
        if (cc.survivalFlyCobwebHack && vDistanceAboveLimit > 0.0 && hDistanceAboveLimit <= 0.0 && this.hackCobweb(player, data, to, now, vDistanceAboveLimit)) {
            return new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
        }
        if (vDistanceAboveLimit > 0.0) {
            this.tags.add("vweb");
        }
        return new double[]{vAllowedDistance, vDistanceAboveLimit};
    }

    private boolean lostGroundAscend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        double dZ;
        double dY;
        double dX;
        double setBackYDistance = to.getY() - data.getSetBackY();
        if (yDistance <= 0.5 && hDistance < 0.5 && setBackYDistance <= 1.3 + 0.2 * data.jumpAmplifier && to.isOnGround() && (data.sfLastYDist < 0.0 || from.isOnGround(0.5 - Math.abs(yDistance)))) {
            return this.applyLostGround(player, from, true, data, "step");
        }
        if (data.fromX != Double.MAX_VALUE && yDistance > 0.0 && data.sfLastYDist < 0.0 && !to.isOnGround() && (setBackYDistance > 0.0 && setBackYDistance <= 1.5 + 0.2 * data.jumpAmplifier || setBackYDistance < 0.0 && Math.abs(setBackYDistance) < 3.0) && (dX = from.getX() - data.fromX) * dX + (dY = from.getY() - data.fromY) * dY + (dZ = from.getZ() - data.fromZ) * dZ < 0.5) {
            double minY;
            double iY = minY = Math.min(data.toY, Math.min(data.fromY, from.getY()));
            double r = from.getWidth() / 2.0;
            double yMargin = cc.yOnGround;
            if (BlockProperties.isOnGround(from.getBlockCache(), Math.min(data.fromX, from.getX()) - r, iY - yMargin, Math.min(data.fromZ, from.getZ()) - r, Math.max(data.fromX, from.getX()) + r, iY + 0.25, Math.max(data.fromZ, from.getZ()) + r, 0L)) {
                return this.applyLostGround(player, from, true, data, "interpolate");
            }
        }
        return false;
    }

    private boolean lostGroundDescend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        double setBackYDistance = to.getY() - data.getSetBackY();
        if (data.sfJumpPhase <= 7) {
            if (data.sfLastYDist <= yDistance && setBackYDistance < 0.0 && !to.isOnGround() && from.isOnGround(0.6, 0.4, 0.0, 0L)) {
                return this.applyLostGround(player, from, true, data, "pyramid");
            }
            if (yDistance == 0.0 && data.sfLastYDist > 0.0 && data.sfLastYDist < 0.25 && (double)data.sfJumpPhase <= 6.0 + data.jumpAmplifier * 3.0 && setBackYDistance > 1.0 && setBackYDistance < 1.5 + 0.2 * data.jumpAmplifier && !to.isOnGround() && from.isOnGround(0.25, 0.4, 0.0, 0L)) {
                return this.applyLostGround(player, from, true, data, "ministep");
            }
        }
        if (yDistance < 0.0 && hDistance <= 0.5 && data.sfLastYDist < 0.0 && yDistance > data.sfLastYDist && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.2, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return this.applyLostGround(player, from, true, data, "edge");
        }
        return false;
    }

    private boolean lostGroundFastDescend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        if (yDistance > data.sfLastYDist && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.3, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return this.applyLostGround(player, from, true, data, "fastedge");
        }
        return false;
    }

    private boolean applyLostGround(Player player, PlayerLocation from, boolean setBackSafe, MovingData data, String tag) {
        if (setBackSafe) {
            data.setSetBack(from);
        }
        data.sfJumpPhase = 0;
        data.jumpAmplifier = this.getJumpAmplifier(player);
        data.clearAccounting();
        data.noFallAssumeGround = true;
        this.tags.add("lostground_" + tag);
        return true;
    }

    private final Location handleViolation(long now, double result, Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        data.survivalFlyVL += result;
        data.sfVLTime = now;
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, result, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
            vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance(from, to)));
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
        }
        if (this.executeActions(vd)) {
            return data.getSetBack(to);
        }
        data.clearAccounting();
        data.sfJumpPhase = 0;
        return null;
    }

    protected final void handleHoverViolation(Player player, Location loc, MovingConfig cc, MovingData data) {
        data.survivalFlyVL += cc.sfHoverViolation;
        data.sfVLTime = System.currentTimeMillis();
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, cc.sfHoverViolation, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", loc.getX(), loc.getY(), loc.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, "(HOVER)");
            vd.setParameter(ParameterName.DISTANCE, "0.0(HOVER)");
            vd.setParameter(ParameterName.TAGS, "hover");
        }
        if (this.executeActions(vd)) {
            if (data.hasSetBack()) {
                Location newTo = data.getSetBack(loc);
                data.prepareSetBack(newTo);
                player.teleport(newTo, PlayerTeleportEvent.TeleportCause.PLUGIN);
            } else {
                player.kickPlayer("Hovering?");
            }
        }
    }

    private final boolean hackCobweb(Player player, MovingData data, PlayerLocation to, long now, double vDistanceAboveLimit) {
        if (now - data.sfCobwebTime > 3000L) {
            data.sfCobwebTime = now;
            data.sfCobwebVL = vDistanceAboveLimit * 100.0;
        } else {
            data.sfCobwebVL += vDistanceAboveLimit * 100.0;
        }
        if (data.sfCobwebVL < 550.0) {
            if (!data.hasSetBack()) {
                data.setSetBack(player.getLocation(this.useLoc));
                this.useLoc.setWorld(null);
            }
            data.sfJumpPhase = 0;
            data.sfLastHDist = Double.MAX_VALUE;
            data.sfLastYDist = Double.MAX_VALUE;
            return true;
        }
        return false;
    }

    public void setReallySneaking(Player player, boolean sneaking) {
        if (sneaking) {
            this.reallySneaking.add(player.getName());
        } else {
            this.reallySneaking.remove(player.getName());
        }
    }

    protected final double getJumpAmplifier(Player player) {
        double amplifier = this.mcAccess.getJumpAmplifier(player);
        if (amplifier == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return 1.0 + amplifier;
    }

    private void outputDebug(Player player, PlayerLocation to, MovingData data, MovingConfig cc, double hDistance, double hAllowedDistance, double hFreedom, double yDistance, double vAllowedDistance, boolean fromOnGround, boolean resetFrom, boolean toOnGround, boolean resetTo) {
        StringBuilder builder = new StringBuilder(500);
        String hBuf = data.sfHorizontalBuffer < 1.0 ? " hbuf=" + StringUtil.fdec3.format(data.sfHorizontalBuffer) : "";
        String lostSprint = data.lostSprintCount > 0 ? " lostSprint=" + data.lostSprintCount : "";
        String hVelUsed = hFreedom > 0.0 ? " hVelUsed=" + StringUtil.fdec3.format(hFreedom) : "";
        builder.append(player.getName() + " SurvivalFly\nground: " + (data.noFallAssumeGround ? "(assumeonground) " : "") + (fromOnGround ? "onground -> " : (resetFrom ? "resetcond -> " : "--- -> ")) + (toOnGround ? "onground" : (resetTo ? "resetcond" : "---")) + ", jumpphase: " + data.sfJumpPhase);
        String dHDist = BuildParameters.debugLevel > 0 && data.sfLastHDist != Double.MAX_VALUE && Math.abs(data.sfLastHDist - hDistance) > 5.0E-4 ? "(" + (hDistance > data.sfLastHDist ? "+" : "") + StringUtil.fdec3.format(hDistance - data.sfLastHDist) + ")" : "";
        builder.append("\n hDist: " + StringUtil.fdec3.format(hDistance) + dHDist + " / " + StringUtil.fdec3.format(hAllowedDistance) + hBuf + lostSprint + hVelUsed + " , vDist: " + StringUtil.fdec3.format(yDistance) + " (" + StringUtil.fdec3.format(to.getY() - data.getSetBackY()) + " / " + StringUtil.fdec3.format(vAllowedDistance) + "), sby=" + (data.hasSetBack() ? Double.valueOf(data.getSetBackY()) : "?"));
        if (data.verticalVelocityCounter > 0 || data.verticalFreedom >= 0.001) {
            builder.append("\n vertical freedom: " + StringUtil.fdec3.format(data.verticalFreedom) + " (vel=" + StringUtil.fdec3.format(data.verticalVelocity) + "/counter=" + data.verticalVelocityCounter + "/used=" + data.verticalVelocityUsed);
        }
        if (!data.hVelActive.isEmpty()) {
            builder.append("\n horizontal velocity (active):");
            this.addVeloctiy(builder, data.hVelActive);
        }
        if (!data.hVelQueued.isEmpty()) {
            builder.append("\n horizontal velocity (queued):");
            this.addVeloctiy(builder, data.hVelQueued);
        }
        if (!resetFrom && !resetTo && cc.survivalFlyAccountingV && data.vDistAcc.count() > data.vDistAcc.bucketCapacity()) {
            builder.append("\n vacc=" + data.vDistAcc.toInformalString());
        }
        if (player.isSleeping()) {
            this.tags.add("sleeping");
        }
        if (player.getFoodLevel() <= 5 && player.isSprinting()) {
            this.tags.add("lowfoodsprint");
        }
        if (!this.tags.isEmpty()) {
            builder.append("\n tags: " + StringUtil.join(this.tags, "+"));
        }
        builder.append("\n");
        System.out.print(builder.toString());
    }

    private void addVeloctiy(StringBuilder builder, List<Velocity> entries) {
        for (Velocity vel : entries) {
            builder.append(" ");
            builder.append(vel);
        }
    }
}

