/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.players.DataManager;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectCommand
extends BaseCommand {
    private final DecimalFormat f1 = new DecimalFormat("#.#");

    public InspectCommand(JavaPlugin plugin) {
        super(plugin, "inspect", "nocheatplus.command.inspect");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            if (sender instanceof Player) {
                args = new String[]{args[0], sender.getName()};
            } else {
                sender.sendMessage("[NoCheatPlus] Please specify a player to inspect.");
                return true;
            }
        }
        String c1 = sender instanceof Player ? ChatColor.GRAY.toString() : "";
        for (int i = 1; i < args.length; ++i) {
            Player player = DataManager.getPlayer(args[i].trim().toLowerCase());
            if (player == null) {
                sender.sendMessage("(Not online: " + args[i] + ")");
                continue;
            }
            StringBuilder builder = new StringBuilder(256);
            builder.append(player.getName() + c1);
            builder.append(" (" + (player.isOnline() ? "online" : "offline") + (player.isDead() ? ",dead" : "") + (player.isValid() ? "" : ",invalid") + (player.isInsideVehicle() ? ",vehicle=" + player.getVehicle().getType() + "@" + this.locString(player.getVehicle().getLocation()) : "") + "):");
            builder.append(" health=" + this.f1.format(player.getHealth()) + "/" + this.f1.format(player.getMaxHealth()));
            builder.append(" food=" + player.getFoodLevel());
            if (player.getExp() > 0.0f) {
                builder.append(" explvl=" + this.f1.format(player.getExpToLevel()) + "(exp=" + this.f1.format(player.getExp()) + ")");
            }
            if (player.isFlying()) {
                builder.append(" flying");
            }
            if (player.getAllowFlight()) {
                builder.append(" allowflight");
            }
            builder.append(" flyspeed=" + player.getFlySpeed());
            builder.append(" walkspeed=" + player.getWalkSpeed());
            Collection effects = player.getActivePotionEffects();
            if (!effects.isEmpty()) {
                builder.append(" effects=");
                for (PotionEffect effect : effects) {
                    builder.append(effect.getType() + "@" + effect.getAmplifier() + ",");
                }
            }
            Location loc = player.getLocation();
            builder.append(" pos=" + this.locString(loc));
            sender.sendMessage(builder.toString());
        }
        return true;
    }

    private final String locString(Location loc) {
        return loc.getWorld().getName() + "/" + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }
}

