/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.BlockPropertiesSetup;
import fr.neatmonster.nocheatplus.compat.bukkit.BlockCacheBukkit;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.potion.PotionEffectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCAccessBukkit
implements MCAccess,
BlockPropertiesSetup {
    public MCAccessBukkit() {
        Material.AIR.isSolid();
        Material.AIR.isOccluding();
        Material.AIR.isTransparent();
    }

    @Override
    public String getMCVersion() {
        return "1.4.6|1.4.7|1.5.x|1.6.x|1.7.x";
    }

    @Override
    public String getServerVersionTag() {
        return "Bukkit-API";
    }

    @Override
    public CommandMap getCommandMap() {
        try {
            return (CommandMap)ReflectionUtil.invokeMethodNoArgs(Bukkit.getServer(), "getCommandMap", new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public BlockCache getBlockCache(World world) {
        return new BlockCacheBukkit(world);
    }

    @Override
    public double getHeight(Entity entity) {
        double entityHeight = 1.0;
        if (entity instanceof LivingEntity) {
            return Math.max(((LivingEntity)entity).getEyeHeight(), 1.0);
        }
        return 1.0;
    }

    @Override
    public AlmostBoolean isBlockSolid(int id) {
        Material mat = Material.getMaterial((int)id);
        if (mat == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(mat.isSolid());
    }

    @Override
    public AlmostBoolean isBlockLiquid(int id) {
        Material mat = Material.getMaterial((int)id);
        if (mat == null) {
            return AlmostBoolean.MAYBE;
        }
        switch (mat) {
            case STATIONARY_LAVA: 
            case STATIONARY_WATER: 
            case WATER: 
            case LAVA: {
                return AlmostBoolean.YES;
            }
        }
        return AlmostBoolean.NO;
    }

    @Override
    public double getWidth(Entity entity) {
        return 0.6f;
    }

    @Override
    public AlmostBoolean isIllegalBounds(Player player) {
        if (player.isDead()) {
            return AlmostBoolean.NO;
        }
        if (!player.isSleeping()) {
            // empty if block
        }
        return AlmostBoolean.MAYBE;
    }

    @Override
    public double getJumpAmplifier(Player player) {
        return PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.JUMP);
    }

    @Override
    public double getFasterMovementAmplifier(Player player) {
        return PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.SPEED);
    }

    @Override
    public int getInvulnerableTicks(Player player) {
        return player.getNoDamageTicks();
    }

    @Override
    public void setInvulnerableTicks(Player player, int ticks) {
        player.setLastDamageCause(BridgeHealth.getEntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.CUSTOM, 500.0));
        player.setNoDamageTicks(ticks);
    }

    @Override
    public void dealFallDamage(Player player, double damage) {
        BridgeHealth.damage((LivingEntity)player, damage);
    }

    @Override
    public boolean isComplexPart(Entity entity) {
        return entity instanceof ComplexEntityPart || entity instanceof ComplexLivingEntity;
    }

    @Override
    public boolean shouldBeZombie(Player player) {
        return BridgeHealth.getHealth((LivingEntity)player) <= 0.0 && !player.isDead();
    }

    @Override
    public void setDead(Player player, int deathTicks) {
        BridgeHealth.setHealth((LivingEntity)player, 0.0);
        BridgeHealth.damage((LivingEntity)player, 1.0);
    }

    @Override
    public void setupBlockProperties(WorldConfigProvider<?> worldConfigProvider) {
        long flags;
        int id;
        HashSet<Integer> fullBlocks = new HashSet<Integer>();
        for (Material mat : new Material[]{Material.GLASS, Material.GLOWSTONE, Material.ICE, Material.LEAVES, Material.COMMAND, Material.BEACON, Material.PISTON_BASE}) {
            fullBlocks.add(mat.getId());
        }
        for (Material mat : Material.values()) {
            if (!mat.isBlock() || (id = mat.getId()) < 0 || id >= 4096 || fullBlocks.contains(id) || mat.isOccluding() && mat.isSolid() && !mat.isTransparent()) continue;
            flags = 8L;
            if ((BlockProperties.isSolid(id) || BlockProperties.isGround(id)) && !BlockProperties.isLiquid(id)) {
                flags |= 0x1000L;
            }
            BlockProperties.setBlockFlags(id, BlockProperties.getBlockFlags(id) | flags);
        }
        for (Material mat : new Material[]{Material.ENDER_PORTAL_FRAME}) {
            id = mat.getId();
            flags = 4104L;
            BlockProperties.setBlockFlags(id, BlockProperties.getBlockFlags(id) | 0x1008L);
        }
    }

    @Override
    public long getKeepAliveTime(Player player) {
        return Long.MIN_VALUE;
    }

    @Override
    public boolean hasGravity(Material mat) {
        try {
            return mat.hasGravity();
        }
        catch (Throwable t) {
            switch (mat) {
                case SAND: 
                case GRAVEL: {
                    return true;
                }
            }
            return false;
        }
    }

    @Override
    public void correctDirection(Player player) {
    }
}

