/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.BlockPropertiesSetup;
import fr.neatmonster.nocheatplus.compat.blocks.init.vanilla.VanillaBlocksFactory;
import fr.neatmonster.nocheatplus.config.RawConfigFile;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.PassableRayTracing;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.InputMismatchException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockProperties {
    protected static final int maxBlocks = 4096;
    protected static final BlockProps[] blocks = new BlockProps[4096];
    protected static Map<Integer, ToolProps> tools = new LinkedHashMap<Integer, ToolProps>(50, 0.5f);
    public static final long indestructible = Long.MAX_VALUE;
    public static final ToolProps noTool = new ToolProps(ToolType.NONE, MaterialBase.NONE);
    public static final ToolProps woodSword = new ToolProps(ToolType.SWORD, MaterialBase.WOOD);
    public static final ToolProps woodSpade = new ToolProps(ToolType.SPADE, MaterialBase.WOOD);
    public static final ToolProps woodPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.WOOD);
    public static final ToolProps woodAxe = new ToolProps(ToolType.AXE, MaterialBase.WOOD);
    public static final ToolProps stonePickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.STONE);
    public static final ToolProps ironPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.IRON);
    public static final ToolProps diamondPickaxe = new ToolProps(ToolType.PICKAXE, MaterialBase.DIAMOND);
    public static final long[] instantTimes = BlockProperties.secToMs(0.0);
    public static final long[] leafTimes = BlockProperties.secToMs(0.3);
    public static long[] glassTimes = BlockProperties.secToMs(0.45);
    public static final long[] gravelTimes = BlockProperties.secToMs(0.9, 0.45, 0.25, 0.15, 0.15, 0.1);
    public static long[] railsTimes = BlockProperties.secToMs(1.05, 0.55, 0.3, 0.2, 0.15, 0.1);
    public static final long[] woodTimes = BlockProperties.secToMs(3.0, 1.5, 0.75, 0.5, 0.4, 0.25);
    public static final long[] ironTimes = BlockProperties.secToMs(15.0, 15.0, 1.15, 0.75, 0.6, 15.0);
    public static final long[] diamondTimes = BlockProperties.secToMs(15.0, 15.0, 15.0, 0.75, 0.6, 15.0);
    private static final long[] indestructibleTimes = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
    public static final BlockProps instantType = new BlockProps(noTool, 0.0f, instantTimes);
    public static final BlockProps glassType = new BlockProps(noTool, 0.3f, glassTimes, 2.0f);
    public static final BlockProps gravelType = new BlockProps(woodSpade, 0.6f, gravelTimes);
    public static final BlockProps stoneType = new BlockProps(woodPickaxe, 1.5f);
    public static final BlockProps woodType = new BlockProps(woodAxe, 2.0f, woodTimes);
    public static final BlockProps brickType = new BlockProps(woodPickaxe, 2.0f);
    public static final BlockProps coalType = new BlockProps(woodPickaxe, 3.0f);
    public static final BlockProps ironType = new BlockProps(stonePickaxe, 3.0f, ironTimes);
    public static final BlockProps diamondType = new BlockProps(ironPickaxe, 3.0f, diamondTimes);
    public static final BlockProps goldBlockType = new BlockProps(woodPickaxe, 3.0f, BlockProperties.secToMs(15.0, 7.5, 3.75, 0.7, 0.55, 1.2));
    public static final BlockProps ironBlockType = new BlockProps(woodPickaxe, 5.0f, BlockProperties.secToMs(25.0, 12.5, 2.0, 1.25, 0.95, 2.0));
    public static final BlockProps diamondBlockType = new BlockProps(woodPickaxe, 5.0f, BlockProperties.secToMs(25.0, 12.5, 6.0, 1.25, 0.95, 2.0));
    public static final BlockProps hugeMushroomType = new BlockProps(woodAxe, 0.2f, BlockProperties.secToMs(0.3, 0.15, 0.1, 0.05, 0.05, 0.05));
    public static final BlockProps leafType = new BlockProps(noTool, 0.2f, leafTimes);
    public static final BlockProps sandType = new BlockProps(woodSpade, 0.5f, BlockProperties.secToMs(0.75, 0.4, 0.2, 0.15, 0.1, 0.1));
    public static final BlockProps leverType = new BlockProps(noTool, 0.5f, BlockProperties.secToMs(0.75));
    public static final BlockProps sandStoneType = new BlockProps(woodPickaxe, 0.8f);
    public static final BlockProps pumpkinType = new BlockProps(woodAxe, 1.0f, BlockProperties.secToMs(1.5, 0.75, 0.4, 0.25, 0.2, 0.15));
    public static final BlockProps chestType = new BlockProps(woodAxe, 2.5f, BlockProperties.secToMs(3.75, 1.9, 0.95, 0.65, 0.5, 0.35));
    public static final BlockProps woodDoorType = new BlockProps(woodAxe, 3.0f, BlockProperties.secToMs(4.5, 2.25, 1.15, 0.75, 0.6, 0.4));
    public static final BlockProps dispenserType = new BlockProps(woodPickaxe, 3.5f);
    public static final BlockProps ironDoorType = new BlockProps(woodPickaxe, 5.0f);
    private static final BlockProps indestructibleType = new BlockProps(noTool, -1.0f, indestructibleTimes);
    private static BlockProps defaultBlockProps = instantType;
    protected static final Material[] instantMat = new Material[]{Material.CROPS, Material.TRIPWIRE_HOOK, Material.TRIPWIRE, Material.TORCH, Material.TNT, Material.SUGAR_CANE_BLOCK, Material.SAPLING, Material.RED_ROSE, Material.YELLOW_FLOWER, Material.REDSTONE_WIRE, Material.REDSTONE_TORCH_ON, Material.REDSTONE_TORCH_OFF, Material.DIODE_BLOCK_ON, Material.DIODE_BLOCK_OFF, Material.PUMPKIN_STEM, Material.NETHER_WARTS, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.MELON_STEM, Material.WATER_LILY, Material.LONG_GRASS, Material.FIRE, Material.DEAD_BUSH, Material.CROPS, Material.COMMAND, Material.FLOWER_POT, Material.CARROT, Material.POTATO};
    private static BlockCache blockCache = null;
    private static PlayerLocation pLoc = null;
    protected static final long[] blockFlags = new long[4096];
    public static final long F_STAIRS = 1L;
    public static final long F_LIQUID = 2L;
    public static final long F_SOLID = 4L;
    public static final long F_IGN_PASSABLE = 8L;
    public static final long F_WATER = 16L;
    public static final long F_LAVA = 32L;
    public static final long F_HEIGHT150 = 64L;
    public static final long F_GROUND = 128L;
    public static final long F_HEIGHT100 = 256L;
    public static final long F_CLIMBABLE = 512L;
    public static final long F_VARIABLE = 1024L;
    public static final long F_XZ100 = 2048L;
    public static final long F_GROUND_HEIGHT = 4096L;
    public static final long F_HEIGHT_8SIM_DEC = 8192L;
    public static final long F_HEIGHT_8SIM_INC = 16384L;
    public static final long F_HEIGHT_8_INC = 32768L;
    public static final long F_RAILS = 65536L;
    public static final long F_ICE = 131072L;
    public static final long F_LEAVES = 262144L;
    public static final long F_THIN_FENCE = 524288L;
    private static final Map<Long, String> flagNameMap = new LinkedHashMap<Long, String>();
    private static final Map<String, Long> nameFlagMap = new LinkedHashMap<String, Long>();
    private static final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    protected static float breakPenaltyInWater;
    protected static float breakPenaltyOffGround;

    public static void init(MCAccess mcAccess, WorldConfigProvider<?> worldConfigProvider) {
        blockCache = mcAccess.getBlockCache(null);
        pLoc = new PlayerLocation(mcAccess, null);
        try {
            BlockProperties.initTools(mcAccess, worldConfigProvider);
            BlockProperties.initBlocks(mcAccess, worldConfigProvider);
            try {
                new VanillaBlocksFactory().setupBlockProperties(worldConfigProvider);
            }
            catch (Throwable t) {
                LogUtil.logSevere("[NoCheatPlus] Could not initialize vanilla blocks: " + t.getClass().getSimpleName() + " - " + t.getMessage());
                LogUtil.logSevere(t);
            }
            if (mcAccess instanceof BlockPropertiesSetup) {
                try {
                    ((BlockPropertiesSetup)((Object)mcAccess)).setupBlockProperties(worldConfigProvider);
                }
                catch (Throwable t) {
                    LogUtil.logSevere("[NoCheatPlus] McAccess.setupBlockProperties (" + mcAccess.getClass().getSimpleName() + ") could not execute properly: " + t.getClass().getSimpleName() + " - " + t.getMessage());
                    LogUtil.logSevere(t);
                }
            }
        }
        catch (Throwable t) {
            LogUtil.logSevere(t);
        }
    }

    private static void initTools(MCAccess mcAccess, WorldConfigProvider<?> worldConfigProvider) {
        tools.clear();
        tools.put(268, new ToolProps(ToolType.SWORD, MaterialBase.WOOD));
        tools.put(269, new ToolProps(ToolType.SPADE, MaterialBase.WOOD));
        tools.put(270, new ToolProps(ToolType.PICKAXE, MaterialBase.WOOD));
        tools.put(271, new ToolProps(ToolType.AXE, MaterialBase.WOOD));
        tools.put(272, new ToolProps(ToolType.SWORD, MaterialBase.STONE));
        tools.put(273, new ToolProps(ToolType.SPADE, MaterialBase.STONE));
        tools.put(274, new ToolProps(ToolType.PICKAXE, MaterialBase.STONE));
        tools.put(275, new ToolProps(ToolType.AXE, MaterialBase.STONE));
        tools.put(256, new ToolProps(ToolType.SPADE, MaterialBase.IRON));
        tools.put(257, new ToolProps(ToolType.PICKAXE, MaterialBase.IRON));
        tools.put(258, new ToolProps(ToolType.AXE, MaterialBase.IRON));
        tools.put(267, new ToolProps(ToolType.SWORD, MaterialBase.IRON));
        tools.put(276, new ToolProps(ToolType.SWORD, MaterialBase.DIAMOND));
        tools.put(277, new ToolProps(ToolType.SPADE, MaterialBase.DIAMOND));
        tools.put(278, new ToolProps(ToolType.PICKAXE, MaterialBase.DIAMOND));
        tools.put(279, new ToolProps(ToolType.AXE, MaterialBase.DIAMOND));
        tools.put(283, new ToolProps(ToolType.SWORD, MaterialBase.GOLD));
        tools.put(284, new ToolProps(ToolType.SPADE, MaterialBase.GOLD));
        tools.put(285, new ToolProps(ToolType.PICKAXE, MaterialBase.GOLD));
        tools.put(286, new ToolProps(ToolType.AXE, MaterialBase.GOLD));
        tools.put(359, new ToolProps(ToolType.SHEARS, MaterialBase.NONE));
    }

    private static void initBlocks(MCAccess mcAccess, WorldConfigProvider<?> worldConfigProvider) {
        Arrays.fill(blocks, null);
        for (int i = 0; i < 4096; ++i) {
            BlockProperties.blockFlags[i] = 0L;
            if (mcAccess.isBlockLiquid(i).decide()) {
                int n = i;
                blockFlags[n] = blockFlags[n] | 2L;
                if (!mcAccess.isBlockSolid(i).decide()) continue;
                int n2 = i;
                blockFlags[n2] = blockFlags[n2] | 4L;
                continue;
            }
            if (!mcAccess.isBlockSolid(i).decide()) continue;
            int n = i;
            blockFlags[n] = blockFlags[n] | 0x84L;
        }
        for (Material mat : new Material[]{Material.NETHER_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.SMOOTH_STAIRS, Material.BRICK_STAIRS, Material.SANDSTONE_STAIRS, Material.WOOD_STAIRS, Material.SPRUCE_WOOD_STAIRS, Material.BIRCH_WOOD_STAIRS, Material.JUNGLE_WOOD_STAIRS}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x1981L;
        }
        for (Material mat : new Material[]{Material.STEP, Material.WOOD_STEP}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x880L;
        }
        for (Material mat : new Material[]{Material.RAILS, Material.DETECTOR_RAIL, Material.POWERED_RAIL}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x10000L;
        }
        for (Material mat : new Material[]{Material.STATIONARY_WATER, Material.WATER}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x2012L;
        }
        for (Material mat : new Material[]{Material.LAVA, Material.STATIONARY_LAVA}) {
            int n = mat.getId();
            blockFlags[n] = blockFlags[n] | 0x2022L;
        }
        int n = Material.SNOW.getId();
        blockFlags[n] = blockFlags[n] | 0x4000L;
        for (Material mat : new Material[]{Material.VINE, Material.LADDER}) {
            int n3 = mat.getId();
            blockFlags[n3] = blockFlags[n3] | 0x200L;
        }
        for (Material mat : new Material[]{Material.WATER_LILY, Material.LADDER, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.COCOA, Material.SNOW, Material.BREWING_STAND, Material.PISTON_MOVING_PIECE, Material.PISTON_EXTENSION, Material.STEP, Material.WOOD_STEP}) {
            int n4 = mat.getId();
            blockFlags[n4] = blockFlags[n4] | 0x80L;
        }
        for (Material mat : new Material[]{Material.BREWING_STAND, Material.PISTON_EXTENSION}) {
            int n5 = mat.getId();
            blockFlags[n5] = blockFlags[n5] | 0x100L;
        }
        for (Material mat : new Material[]{Material.PISTON_EXTENSION}) {
            int n6 = mat.getId();
            blockFlags[n6] = blockFlags[n6] | 0x800L;
        }
        int n7 = Material.ICE.getId();
        blockFlags[n7] = blockFlags[n7] | 0x20000L;
        for (Material mat : new Material[]{Material.WALL_SIGN, Material.SIGN_POST}) {
            int n8 = mat.getId();
            blockFlags[n8] = blockFlags[n8] & 0xFFFFFFFFFFFFFF7BL;
        }
        for (Material mat : new Material[]{Material.WOOD_PLATE, Material.STONE_PLATE, Material.WALL_SIGN, Material.SIGN_POST, Material.DIODE_BLOCK_ON, Material.DIODE_BLOCK_OFF, Material.BREWING_STAND, Material.LADDER, Material.CAKE_BLOCK}) {
            int n9 = mat.getId();
            blockFlags[n9] = blockFlags[n9] | 8L;
        }
        for (Material mat : new Material[]{Material.FENCE, Material.FENCE_GATE, Material.NETHER_FENCE, Material.COBBLE_WALL}) {
            int n10 = mat.getId();
            blockFlags[n10] = blockFlags[n10] | 0x440L;
        }
        for (Material mat : new Material[]{Material.IRON_FENCE, Material.THIN_GLASS}) {
            int n11 = mat.getId();
            blockFlags[n11] = blockFlags[n11] | 0x80400L;
        }
        for (Material mat : new Material[]{Material.PISTON_EXTENSION, Material.BREWING_STAND, Material.CAKE_BLOCK}) {
            int n12 = mat.getId();
            blockFlags[n12] = blockFlags[n12] | 0x1000L;
        }
        for (Material mat : instantMat) {
            BlockProperties.blocks[mat.getId()] = instantType;
        }
        for (Material mat : new Material[]{Material.LEAVES, Material.BED_BLOCK}) {
            BlockProperties.blocks[mat.getId()] = leafType;
        }
        int n13 = Material.LEAVES.getId();
        blockFlags[n13] = blockFlags[n13] | 0x40000L;
        for (Material mat : new Material[]{Material.HUGE_MUSHROOM_1, Material.HUGE_MUSHROOM_2, Material.VINE, Material.COCOA}) {
            BlockProperties.blocks[mat.getId()] = hugeMushroomType;
        }
        BlockProperties.blocks[Material.SNOW.getId()] = new BlockProps(BlockProperties.getToolProps(Material.WOOD_SPADE), 0.1f, BlockProperties.secToMs(0.5, 0.1, 0.05, 0.05, 0.05, 0.05));
        BlockProperties.blocks[Material.SNOW_BLOCK.getId()] = new BlockProps(BlockProperties.getToolProps(Material.WOOD_SPADE), 0.1f, BlockProperties.secToMs(1.0, 0.15, 0.1, 0.05, 0.05, 0.05));
        for (Material mat : new Material[]{Material.REDSTONE_LAMP_ON, Material.REDSTONE_LAMP_OFF, Material.GLOWSTONE, Material.GLASS}) {
            BlockProperties.blocks[mat.getId()] = glassType;
        }
        BlockProperties.blocks[Material.THIN_GLASS.getId()] = glassType;
        BlockProperties.blocks[Material.NETHERRACK.getId()] = new BlockProps(woodPickaxe, 0.4f, BlockProperties.secToMs(2.0, 0.3, 0.15, 0.1, 0.1, 0.05));
        BlockProperties.blocks[Material.LADDER.getId()] = new BlockProps(noTool, 0.4f, BlockProperties.secToMs(0.6), 2.5f);
        BlockProperties.blocks[Material.CACTUS.getId()] = new BlockProps(noTool, 0.4f, BlockProperties.secToMs(0.6));
        BlockProperties.blocks[Material.WOOD_PLATE.getId()] = new BlockProps(woodAxe, 0.5f, BlockProperties.secToMs(0.75, 0.4, 0.2, 0.15, 0.1, 0.1));
        BlockProperties.blocks[Material.STONE_PLATE.getId()] = new BlockProps(woodPickaxe, 0.5f, BlockProperties.secToMs(2.5, 0.4, 0.2, 0.15, 0.1, 0.07));
        BlockProperties.blocks[Material.SAND.getId()] = sandType;
        BlockProperties.blocks[Material.SOUL_SAND.getId()] = sandType;
        for (Material mat : new Material[]{Material.LEVER, Material.PISTON_BASE, Material.PISTON_EXTENSION, Material.PISTON_STICKY_BASE, Material.STONE_BUTTON, Material.PISTON_MOVING_PIECE}) {
            BlockProperties.blocks[mat.getId()] = leverType;
        }
        BlockProperties.blocks[Material.ICE.getId()] = new BlockProps(woodPickaxe, 0.5f, BlockProperties.secToMs(0.7, 0.35, 0.18, 0.12, 0.09, 0.06));
        BlockProperties.blocks[Material.DIRT.getId()] = sandType;
        BlockProperties.blocks[Material.CAKE_BLOCK.getId()] = leverType;
        BlockProperties.blocks[Material.BREWING_STAND.getId()] = new BlockProps(woodPickaxe, 0.5f, BlockProperties.secToMs(2.5, 0.4, 0.2, 0.15, 0.1, 0.1));
        BlockProperties.blocks[Material.SPONGE.getId()] = new BlockProps(noTool, 0.6f, BlockProperties.secToMs(0.9));
        for (Material mat : new Material[]{Material.MYCEL, Material.GRAVEL, Material.GRASS, Material.SOIL, Material.CLAY}) {
            BlockProperties.blocks[mat.getId()] = gravelType;
        }
        for (Material mat : new Material[]{Material.RAILS, Material.POWERED_RAIL, Material.DETECTOR_RAIL}) {
            BlockProperties.blocks[mat.getId()] = new BlockProps(woodPickaxe, 0.7f, railsTimes);
        }
        BlockProperties.blocks[Material.MONSTER_EGGS.getId()] = new BlockProps(noTool, 0.75f, BlockProperties.secToMs(1.15));
        BlockProperties.blocks[Material.WOOL.getId()] = new BlockProps(noTool, 0.8f, BlockProperties.secToMs(1.2), 3.0f);
        BlockProperties.blocks[Material.SANDSTONE.getId()] = sandStoneType;
        BlockProperties.blocks[Material.SANDSTONE_STAIRS.getId()] = sandStoneType;
        for (Material mat : new Material[]{Material.STONE, Material.SMOOTH_BRICK, Material.SMOOTH_STAIRS}) {
            BlockProperties.blocks[mat.getId()] = stoneType;
        }
        BlockProperties.blocks[Material.NOTE_BLOCK.getId()] = new BlockProps(woodAxe, 0.8f, BlockProperties.secToMs(1.2, 0.6, 0.3, 0.2, 0.15, 0.1));
        BlockProperties.blocks[Material.WALL_SIGN.getId()] = pumpkinType;
        BlockProperties.blocks[Material.SIGN_POST.getId()] = pumpkinType;
        BlockProperties.blocks[Material.PUMPKIN.getId()] = pumpkinType;
        BlockProperties.blocks[Material.JACK_O_LANTERN.getId()] = pumpkinType;
        BlockProperties.blocks[Material.MELON_BLOCK.getId()] = new BlockProps(noTool, 1.0f, BlockProperties.secToMs(1.45), 3.0f);
        BlockProperties.blocks[Material.BOOKSHELF.getId()] = new BlockProps(woodAxe, 1.5f, BlockProperties.secToMs(2.25, 1.15, 0.6, 0.4, 0.3, 0.2));
        for (Material mat : new Material[]{Material.WOOD_STAIRS, Material.WOOD, Material.WOOD_STEP, Material.LOG, Material.FENCE, Material.FENCE_GATE, Material.JUKEBOX, Material.JUNGLE_WOOD_STAIRS, Material.SPRUCE_WOOD_STAIRS, Material.BIRCH_WOOD_STAIRS, Material.WOOD_DOUBLE_STEP}) {
            BlockProperties.blocks[mat.getId()] = woodType;
        }
        for (Material mat : new Material[]{Material.COBBLESTONE_STAIRS, Material.COBBLESTONE, Material.NETHER_BRICK, Material.NETHER_BRICK_STAIRS, Material.NETHER_FENCE, Material.CAULDRON, Material.BRICK, Material.BRICK_STAIRS, Material.MOSSY_COBBLESTONE, Material.BRICK, Material.BRICK_STAIRS, Material.STEP, Material.DOUBLE_STEP}) {
            BlockProperties.blocks[mat.getId()] = brickType;
        }
        BlockProperties.blocks[Material.WORKBENCH.getId()] = chestType;
        BlockProperties.blocks[Material.CHEST.getId()] = chestType;
        BlockProperties.blocks[Material.WOODEN_DOOR.getId()] = woodDoorType;
        BlockProperties.blocks[Material.TRAP_DOOR.getId()] = woodDoorType;
        for (Material mat : new Material[]{Material.ENDER_STONE, Material.DRAGON_EGG, Material.COAL_ORE}) {
            BlockProperties.blocks[mat.getId()] = coalType;
        }
        for (Material mat : new Material[]{Material.LAPIS_ORE, Material.LAPIS_BLOCK, Material.IRON_ORE}) {
            BlockProperties.blocks[mat.getId()] = ironType;
        }
        for (Material mat : new Material[]{Material.REDSTONE_ORE, Material.GLOWING_REDSTONE_ORE, Material.EMERALD_ORE, Material.GOLD_ORE, Material.DIAMOND_ORE}) {
            BlockProperties.blocks[mat.getId()] = diamondType;
        }
        BlockProperties.blocks[Material.GOLD_BLOCK.getId()] = goldBlockType;
        BlockProperties.blocks[Material.FURNACE.getId()] = dispenserType;
        BlockProperties.blocks[Material.BURNING_FURNACE.getId()] = dispenserType;
        BlockProperties.blocks[Material.DISPENSER.getId()] = dispenserType;
        BlockProperties.blocks[Material.WEB.getId()] = new BlockProps(woodSword, 4.0f, BlockProperties.secToMs(20.0, 0.4, 0.4, 0.4, 0.4, 0.4));
        for (Material mat : new Material[]{Material.MOB_SPAWNER, Material.IRON_DOOR_BLOCK, Material.IRON_FENCE, Material.ENCHANTMENT_TABLE, Material.EMERALD_BLOCK}) {
            BlockProperties.blocks[mat.getId()] = ironDoorType;
        }
        BlockProperties.blocks[Material.IRON_BLOCK.getId()] = ironBlockType;
        BlockProperties.blocks[Material.DIAMOND_BLOCK.getId()] = diamondBlockType;
        BlockProperties.blocks[Material.ENDER_CHEST.getId()] = new BlockProps(woodPickaxe, 22.5f);
        BlockProperties.blocks[Material.OBSIDIAN.getId()] = new BlockProps(diamondPickaxe, 50.0f, BlockProperties.secToMs(250.0, 250.0, 250.0, 250.0, 9.4, 250.0));
        BlockProperties.blocks[Material.BEACON.getId()] = new BlockProps(noTool, 25.0f, BlockProperties.secToMs(4.45));
        BlockProperties.blocks[Material.COBBLE_WALL.getId()] = brickType;
        int n14 = Material.COBBLE_WALL.getId();
        blockFlags[n14] = blockFlags[n14] | 0x40L;
        BlockProperties.blocks[Material.WOOD_BUTTON.getId()] = leverType;
        BlockProperties.blocks[Material.SKULL.getId()] = new BlockProps(noTool, 8.5f, BlockProperties.secToMs(1.45));
        int n15 = Material.SKULL.getId();
        blockFlags[n15] = blockFlags[n15] | 0x80L;
        BlockProperties.blocks[Material.ANVIL.getId()] = new BlockProps(woodPickaxe, 5.0f);
        int n16 = Material.FLOWER_POT.getId();
        blockFlags[n16] = blockFlags[n16] | 0x80L;
        for (Material mat : new Material[]{Material.AIR, Material.ENDER_PORTAL, Material.ENDER_PORTAL_FRAME, Material.PORTAL, Material.LAVA, Material.WATER, Material.BEDROCK, Material.STATIONARY_LAVA, Material.STATIONARY_WATER}) {
            BlockProperties.blocks[mat.getId()] = indestructibleType;
        }
        BlockProperties.blocks[95] = indestructibleType;
    }

    public static void dumpBlocks(boolean all) {
        LinkedList<String> missing = new LinkedList<String>();
        if (all) {
            LogUtil.logInfo("[NoCheatPlus] Dump block properties for fastbreak check:");
            LogUtil.logInfo("--- Present entries -------------------------------");
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (int i = 0; i < blocks.length; ++i) {
            String tagsJoined;
            String mat;
            try {
                Material temp = Material.getMaterial((int)i);
                if (!temp.isBlock()) continue;
                mat = temp.toString();
            }
            catch (Exception e) {
                mat = "?";
            }
            tags.clear();
            BlockProperties.addFlagNames(blockFlags[i], tags);
            String string = tagsJoined = tags.isEmpty() ? "" : " / " + StringUtil.join(tags, "+");
            if (blocks[i] == null) {
                if (mat.equals("?")) continue;
                missing.add("* MISSING " + i + "(" + mat + tagsJoined + ") ");
                continue;
            }
            if (!all) continue;
            LogUtil.logInfo(i + ": (" + mat + tagsJoined + ") " + blocks[i].toString());
        }
        if (!missing.isEmpty()) {
            Bukkit.getLogger().warning("[NoCheatPlus] The block breaking data is incomplete, default to allow instant breaking:");
            LogUtil.logWarning("--- Missing entries -------------------------------");
            for (String spec : missing) {
                LogUtil.logWarning(spec);
            }
        }
    }

    public static void addFlagNames(long flags, Collection<String> tags) {
        String tag = flagNameMap.get(flags);
        if (tag != null) {
            tags.add(tag);
            return;
        }
        for (Long flag : flagNameMap.keySet()) {
            if ((flags & flag) == 0L) continue;
            tags.add(flagNameMap.get(flag));
        }
    }

    public static Collection<String> getFlagNames(Long flags) {
        ArrayList<String> tags = new ArrayList<String>(flagNameMap.size());
        if (flags == null) {
            return tags;
        }
        BlockProperties.addFlagNames(flags, tags);
        return tags;
    }

    public static long parseFlag(String input) {
        String ucInput = input.trim().toUpperCase();
        Long flag = nameFlagMap.get(ucInput);
        if (flag != null) {
            return flag;
        }
        try {
            Long altFlag = Long.parseLong(input);
            return altFlag;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InputMismatchException();
        }
    }

    public static long[] secToMs(double s1, double s2, double s3, double s4, double s5, double s6) {
        return new long[]{(long)(s1 * 1000.0), (long)(s2 * 1000.0), (long)(s3 * 1000.0), (long)(s4 * 1000.0), (long)(s5 * 1000.0), (long)(s6 * 1000.0)};
    }

    public static long[] secToMs(double s1) {
        long v = (long)(s1 * 1000.0);
        return new long[]{v, v, v, v, v, v};
    }

    public static ToolProps getToolProps(ItemStack stack) {
        if (stack == null) {
            return noTool;
        }
        return BlockProperties.getToolProps(stack.getTypeId());
    }

    public static ToolProps getToolProps(Material mat) {
        if (mat == null) {
            return noTool;
        }
        return BlockProperties.getToolProps(mat.getId());
    }

    public static ToolProps getToolProps(Integer id) {
        ToolProps props = tools.get(id);
        if (props == null) {
            return noTool;
        }
        return props;
    }

    public static BlockProps getBlockProps(ItemStack stack) {
        if (stack == null) {
            return defaultBlockProps;
        }
        return BlockProperties.getBlockProps(stack.getTypeId());
    }

    public static BlockProps getBlockProps(Material mat) {
        if (mat == null) {
            return defaultBlockProps;
        }
        return BlockProperties.getBlockProps(mat.getId());
    }

    public static BlockProps getBlockProps(int blockId) {
        if (blockId < 0 || blockId >= blocks.length || blocks[blockId] == null) {
            return defaultBlockProps;
        }
        return blocks[blockId];
    }

    public static long getBreakingDuration(int blockId, Player player) {
        long res = BlockProperties.getBreakingDuration(blockId, player.getItemInHand(), player.getInventory().getHelmet(), player, player.getLocation(useLoc));
        useLoc.setWorld(null);
        return res;
    }

    public static long getBreakingDuration(int blockId, ItemStack itemInHand, ItemStack helmet, Player player, Location location) {
        boolean inWater;
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, 0.3);
        boolean onGround = pLoc.isOnGround();
        int bx = pLoc.getBlockX();
        int bz = pLoc.getBlockZ();
        double y = pLoc.getY() + player.getEyeHeight();
        int by = Location.locToBlock((double)y);
        int headId = blockCache.getTypeId(bx, by, bz);
        long headFlags = blockFlags[headId];
        if ((headFlags & 0x10L) == 0L) {
            inWater = false;
        } else {
            int data8 = (blockCache.getData(bx, by, bz) & 0xF) % 8;
            double level = (data8 & 8) != 0 ? 1.0 : 1.0 - 0.125 * (1.0 + (double)data8);
            inWater = y - (double)by < level;
        }
        blockCache.cleanup();
        pLoc.cleanup();
        double haste = PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.FAST_DIGGING);
        return BlockProperties.getBreakingDuration(blockId, itemInHand, onGround, inWater, helmet != null && helmet.containsEnchantment(Enchantment.WATER_WORKER), haste == Double.NEGATIVE_INFINITY ? 0 : 1 + (int)haste);
    }

    public static long getBreakingDuration(int blockId, ItemStack itemInHand, boolean onGround, boolean inWater, boolean aquaAffinity, int haste) {
        if (itemInHand == null) {
            return BlockProperties.getBreakingDuration(blockId, BlockProperties.getBlockProps(blockId), noTool, onGround, inWater, aquaAffinity, 0);
        }
        int efficiency = 0;
        if (itemInHand.containsEnchantment(Enchantment.DIG_SPEED)) {
            efficiency = itemInHand.getEnchantmentLevel(Enchantment.DIG_SPEED);
        }
        return BlockProperties.getBreakingDuration(blockId, BlockProperties.getBlockProps(blockId), BlockProperties.getToolProps(itemInHand.getTypeId()), onGround, inWater, aquaAffinity, efficiency, haste);
    }

    public static long getBreakingDuration(int blockId, BlockProps blockProps, ToolProps toolProps, boolean onGround, boolean inWater, boolean aquaAffinity, int efficiency, int haste) {
        long dur = BlockProperties.getBreakingDuration(blockId, blockProps, toolProps, onGround, inWater, aquaAffinity, efficiency);
        return haste > 0 ? (long)(Math.pow(0.8, haste) * (double)dur) : dur;
    }

    public static long getBreakingDuration(int blockId, BlockProps blockProps, ToolProps toolProps, boolean onGround, boolean inWater, boolean aquaAffinity, int efficiency) {
        long duration;
        boolean isValidTool;
        if (efficiency > 0) {
            if (BlockProperties.isLeaves(blockId) || blockProps == glassType) {
                if (efficiency == 1) {
                    return 100L;
                }
                return 0L;
            }
            if (blockId == Material.MELON_BLOCK.getId()) {
                return 450L / (long)Math.pow(2.0, efficiency - 1);
            }
            if (blockProps == chestType) {
                return (long)((double)blockProps.breakingTimes[0] / 5.0 / (double)efficiency);
            }
        }
        if (isValidTool = BlockProperties.isValidTool(blockId, blockProps, toolProps, efficiency)) {
            duration = blockProps.breakingTimes[toolProps.materialBase.index];
            if (efficiency > 0) {
                duration = (long)((float)duration / blockProps.efficiencyMod);
            }
        } else {
            duration = blockProps.breakingTimes[0];
            if (toolProps.toolType == ToolType.SWORD) {
                duration = (long)((float)duration / 1.5f);
            }
        }
        if (toolProps.toolType == ToolType.SHEARS) {
            if (blockId == Material.WEB.getId()) {
                duration = 400L;
                isValidTool = true;
            } else if (blockId == Material.WOOL.getId()) {
                duration = 240L;
                isValidTool = true;
            } else if (BlockProperties.isLeaves(blockId)) {
                duration = 20L;
                isValidTool = true;
            } else if (blockId == Material.VINE.getId()) {
                duration = 300L;
                isValidTool = true;
            }
        } else if (blockId == Material.VINE.getId() && toolProps.toolType == ToolType.AXE) {
            isValidTool = true;
            duration = toolProps.materialBase == MaterialBase.WOOD || toolProps.materialBase == MaterialBase.STONE ? 100L : 0L;
        }
        if (isValidTool || blockProps.tool.toolType == ToolType.NONE) {
            float mult = 1.0f;
            if (inWater && !aquaAffinity) {
                mult *= breakPenaltyInWater;
            }
            if (!onGround) {
                mult *= breakPenaltyOffGround;
            }
            duration = (long)(mult * (float)duration);
            if (efficiency > 0) {
                if (blockId == Material.WOODEN_DOOR.getId() && toolProps.toolType != ToolType.AXE) {
                    switch (efficiency) {
                        case 1: {
                            return (long)(mult * 1500.0f);
                        }
                        case 2: {
                            return (long)(mult * 750.0f);
                        }
                        case 3: {
                            return (long)(mult * 450.0f);
                        }
                        case 4: {
                            return (long)(mult * 250.0f);
                        }
                        case 5: {
                            return (long)(mult * 150.0f);
                        }
                    }
                }
                for (int i = 0; i < efficiency; ++i) {
                    duration = (long)((double)duration / 1.33);
                }
                if (toolProps.materialBase == MaterialBase.WOOD) {
                    if (toolProps.toolType == ToolType.PICKAXE && (blockProps == ironDoorType || blockProps == dispenserType)) {
                        if (blockProps == dispenserType) {
                            duration = (long)((double)duration / 1.5 - (double)((efficiency - 1) * 60));
                        } else if (blockProps == ironDoorType) {
                            duration = (long)((double)duration / 1.5 - (double)((efficiency - 1) * 100));
                        }
                    } else {
                        duration = blockId == Material.LOG.getId() ? (duration -= efficiency >= 4 ? 250L : 400L) : (blockProps.tool.toolType == toolProps.toolType ? (duration -= 250L) : (duration -= (long)(efficiency * 30)));
                    }
                } else if (toolProps.materialBase == MaterialBase.STONE && blockId == Material.LOG.getId()) {
                    duration -= 100L;
                }
            }
        }
        return Math.max(0L, duration);
    }

    public static boolean isValidTool(int blockId, BlockProps blockProps, ToolProps toolProps, int efficiency) {
        boolean isValidTool;
        boolean bl = isValidTool = blockProps.tool.toolType == toolProps.toolType;
        if (!isValidTool && efficiency > 0) {
            if (blockId == Material.SNOW.getId()) {
                return toolProps.toolType == ToolType.SPADE;
            }
            if (blockId == Material.WOOL.getId()) {
                return true;
            }
            if (blockId == Material.WOODEN_DOOR.getId()) {
                return true;
            }
            if (blockProps.hardness <= 2.0f && (blockProps.tool.toolType == ToolType.AXE || blockProps.tool.toolType == ToolType.SPADE || (double)blockProps.hardness < 0.8 && blockId != Material.NETHERRACK.getId() && blockId != Material.SNOW.getId() && blockId != Material.SNOW_BLOCK.getId() && blockId != Material.STONE_PLATE.getId())) {
                return true;
            }
        }
        return isValidTool;
    }

    public static void setToolProps(int itemId, ToolProps toolProps) {
        if (toolProps == null) {
            throw new NullPointerException("ToolProps must not be null");
        }
        toolProps.validate();
        tools.put(itemId, toolProps);
    }

    public static void setBlockProps(int blockId, BlockProps blockProps) {
        if (blockProps == null) {
            throw new NullPointerException("BlockProps must not be null");
        }
        blockProps.validate();
        if (blockId < 0 || blockId >= blocks.length) {
            throw new IllegalArgumentException("The blockId is outside of supported range: " + blockId);
        }
        BlockProperties.blocks[blockId] = blockProps;
    }

    public static boolean isValidTool(int blockId, ItemStack itemInHand) {
        BlockProps blockProps = BlockProperties.getBlockProps(blockId);
        ToolProps toolProps = BlockProperties.getToolProps(itemInHand);
        int efficiency = itemInHand == null ? 0 : itemInHand.getEnchantmentLevel(Enchantment.DIG_SPEED);
        return BlockProperties.isValidTool(blockId, blockProps, toolProps, efficiency);
    }

    public static BlockProps getDefaultBlockProps() {
        return defaultBlockProps;
    }

    public static void setDefaultBlockProps(BlockProps blockProps) {
        blockProps.validate();
        defaultBlockProps = blockProps;
    }

    public static boolean isInWater(int blockId) {
        return blockId == Material.STATIONARY_WATER.getId() || blockId == Material.STATIONARY_LAVA.getId();
    }

    public static boolean isOnGround(Player player, Location location, double yOnGround) {
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, yOnGround);
        boolean onGround = pLoc.isOnGround();
        blockCache.cleanup();
        pLoc.cleanup();
        return onGround;
    }

    public static boolean isOnGroundOrResetCond(Player player, Location location, double yOnGround) {
        blockCache.setAccess(location.getWorld());
        pLoc.setBlockCache(blockCache);
        pLoc.set(location, player, yOnGround);
        boolean res = pLoc.isOnGround() || pLoc.isResetCond();
        blockCache.cleanup();
        pLoc.cleanup();
        return res;
    }

    public static final long getBLockFlags(int id) {
        return blockFlags[id];
    }

    public static final long getBlockFlags(int id) {
        return blockFlags[id];
    }

    public static final void setBlockFlags(int id, long flags) {
        BlockProperties.blockFlags[id] = flags;
    }

    public static final boolean canClimbUp(BlockCache cache, int x, int y, int z) {
        int id = cache.getTypeId(x, y, z);
        if ((blockFlags[id] & 0x200L) == 0L) {
            return false;
        }
        if (id == Material.LADDER.getId()) {
            return true;
        }
        if ((blockFlags[cache.getTypeId(x + 1, y, z)] & 4L) != 0L) {
            return true;
        }
        if ((blockFlags[cache.getTypeId(x - 1, y, z)] & 4L) != 0L) {
            return true;
        }
        if ((blockFlags[cache.getTypeId(x, y, z + 1)] & 4L) != 0L) {
            return true;
        }
        return (blockFlags[cache.getTypeId(x, y, z - 1)] & 4L) != 0L;
    }

    public static final boolean isClimbable(int id) {
        return (blockFlags[id] & 0x200L) != 0L;
    }

    public static final boolean isStairs(int id) {
        return (blockFlags[id] & 1L) != 0L;
    }

    public static final boolean isLiquid(int id) {
        return (blockFlags[id] & 2L) != 0L;
    }

    public static final boolean isIce(int id) {
        return (blockFlags[id] & 0x20000L) != 0L;
    }

    public static final boolean isLeaves(int id) {
        return (blockFlags[id] & 0x40000L) != 0L;
    }

    public static final boolean isSolid(int id) {
        return (blockFlags[id] & 4L) != 0L;
    }

    public static final boolean isGround(int id) {
        return (blockFlags[id] & 0x80L) != 0L;
    }

    public static final boolean isPassable(int id) {
        long flags = blockFlags[id];
        if ((flags & 0xAL) != 0L) {
            return true;
        }
        return (flags & 4L) == 0L;
    }

    public static final boolean isRails(int id) {
        return (blockFlags[id] & 0x10000L) != 0L;
    }

    public static final boolean isPassable(BlockCache access, double x, double y, double z, int id) {
        int bz;
        int by;
        if (BlockProperties.isPassable(id)) {
            return true;
        }
        int bx = Location.locToBlock((double)x);
        double[] bounds = access.getBounds(bx, by = Location.locToBlock((double)y), bz = Location.locToBlock((double)z));
        if (bounds == null || !BlockProperties.collidesBlock(access, x, y, z, x, y, z, bx, by, bz, id, bounds, blockFlags[id])) {
            return true;
        }
        double fx = x - (double)bx;
        double fy = y - (double)by;
        double fz = z - (double)bz;
        return BlockProperties.isPassableWorkaround(access, bx, by, bz, fx, fy, fz, id, 0.0, 0.0, 0.0, 0.0);
    }

    public static final boolean isPassableH150(BlockCache access, double x, double y, double z) {
        int bz;
        int by = Location.locToBlock((double)y) - 1;
        double fy = y - (double)by;
        if (fy >= 1.5) {
            return true;
        }
        int bx = Location.locToBlock((double)x);
        int belowId = access.getTypeId(bx, by, bz = Location.locToBlock((double)z));
        long belowFlags = blockFlags[belowId];
        if ((belowFlags & 0x40L) == 0L || BlockProperties.isPassable(belowId)) {
            return true;
        }
        double[] belowBounds = access.getBounds(bx, by, bz);
        if (belowBounds == null) {
            return true;
        }
        if (!BlockProperties.collidesBlock(access, x, y, z, x, y, z, bx, by, bz, belowId, belowBounds, belowFlags)) {
            return true;
        }
        double fx = x - (double)bx;
        double fz = z - (double)bz;
        return BlockProperties.isPassableWorkaround(access, bx, by, bz, fx, fy, fz, belowId, 0.0, 0.0, 0.0, 0.0);
    }

    public static final boolean isPassableExact(BlockCache access, double x, double y, double z, int id) {
        return BlockProperties.isPassable(access, x, y, z, id) && BlockProperties.isPassableH150(access, x, y, z);
    }

    public static final boolean isPassableExact(BlockCache access, Location loc) {
        return BlockProperties.isPassableExact(access, loc.getX(), loc.getY(), loc.getZ(), access.getTypeId(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    public static final boolean isPassableWorkaround(BlockCache access, int bx, int by, int bz, double fx, double fy, double fz, int id, double dX, double dY, double dZ, double dT) {
        long flags = blockFlags[id];
        if ((flags & 1L) != 0L) {
            if ((access.getData(bx, by, bz) & 4) != 0 ? Math.max(fy, fy + dY * dT) < 0.5 : Math.min(fy, fy + dY * dT) >= 0.5) {
                return true;
            }
        } else if (id == Material.SOUL_SAND.getId()) {
            if (Math.min(fy, fy + dY * dT) >= 0.875) {
                return true;
            }
        } else if ((flags & 0x80000L) != 0L) {
            if (!BlockProperties.collidesFence(fx, fz, dX, dZ, dT, 0.05)) {
                return true;
            }
        } else if (id == Material.FENCE.getId() || id == Material.NETHER_FENCE.getId()) {
            if (!BlockProperties.collidesFence(fx, fz, dX, dZ, dT, 0.425)) {
                return true;
            }
        } else if (id == Material.FENCE_GATE.getId()) {
            if ((access.getData(bx, by, bz) & 4) != 0) {
                return true;
            }
        } else if (id == Material.CAKE_BLOCK.getId()) {
            if (Math.min(fy, fy + dY * dT) >= 0.4375) {
                return true;
            }
        } else if (id == Material.CAULDRON.getId()) {
            if (Math.min(fy, fy + dY * dT) >= 0.3125) {
                return BlockProperties.isInsideCenter(fx, fz, dX, dZ, dT, 0.125);
            }
        } else {
            if (id == Material.CACTUS.getId()) {
                if (Math.min(fy, fy + dY * dT) >= 0.9375) {
                    return true;
                }
                return !BlockProperties.collidesCenter(fx, fz, dX, dZ, dT, 0.0625);
            }
            if (id == Material.PISTON_EXTENSION.getId() && Math.min(fy, fy + dY * dT) >= 0.625) {
                return true;
            }
        }
        return false;
    }

    public static boolean collidesFence(double fx, double fz, double dX, double dZ, double dT, double d) {
        double dFx = 0.5 - fx;
        double dFz = 0.5 - fz;
        if (Math.abs(dFx) > 0.05 && Math.abs(dFz) > d) {
            double dFx2 = 0.5 - (fx + dX * dT);
            double dFz2 = 0.5 - (fz + dZ * dT);
            if (Math.abs(dFx2) > 0.05 && Math.abs(dFz2) > d && dFx * dFx2 > 0.0 && dFz * dFz2 > 0.0) {
                return false;
            }
        }
        return true;
    }

    public static final boolean collidesCenter(double fx, double fz, double dX, double dZ, double dT, double inset) {
        double low = inset;
        double high = 1.0 - inset;
        double xEnd = fx + dX * dT;
        if (xEnd < low && fx < low) {
            return false;
        }
        if (xEnd >= high && fx >= high) {
            return false;
        }
        double zEnd = fz + dZ * dT;
        if (zEnd < low && fz < low) {
            return false;
        }
        return !(zEnd >= high) || !(fz >= high);
    }

    public static final boolean isInsideCenter(double fx, double fz, double dX, double dZ, double dT, double inset) {
        double low = inset;
        double high = 1.0 - inset;
        double xEnd = fx + dX * dT;
        if (xEnd < low || fx < low) {
            return false;
        }
        if (xEnd >= high || fx >= high) {
            return false;
        }
        double zEnd = fz + dZ * dT;
        if (zEnd < low || fz < low) {
            return false;
        }
        return !(zEnd >= high) && !(fz >= high);
    }

    public static double getGroundMinHeight(BlockCache access, int x, int y, int z, int id, double[] bounds, long flags) {
        if ((flags & 0x4000L) != 0L) {
            int data = (access.getData(x, y, z) & 0xF) % 8;
            if (data < 3) {
                return 0.0;
            }
            return 0.5;
        }
        if ((flags & 0x8000L) != 0L) {
            int data = (access.getData(x, y, z) & 0xF) % 8;
            return 0.125 * (double)data;
        }
        if ((flags & 0x40L) != 0L) {
            return 1.5;
        }
        if ((flags & 1L) != 0L) {
            if ((access.getData(x, y, z) & 4) != 0) {
                return 1.0;
            }
            return 0.5;
        }
        if (id == Material.SOUL_SAND.getId()) {
            return 0.875;
        }
        if (id == Material.CAULDRON.getId()) {
            return 0.3125;
        }
        if (id == Material.CACTUS.getId()) {
            return 0.9375;
        }
        if (id == Material.PISTON_EXTENSION.getId()) {
            return 0.625;
        }
        if (id == Material.ENDER_PORTAL_FRAME.getId()) {
            if ((access.getData(x, y, z) & 4) != 0) {
                return 1.0;
            }
            return bounds[4];
        }
        if ((flags & 0x1000L) != 0L) {
            return 0.0;
        }
        return bounds[4];
    }

    public static final boolean isPassable(PlayerLocation loc) {
        return BlockProperties.isPassable(loc.getBlockCache(), loc.getX(), loc.getY(), loc.getZ(), loc.getTypeId());
    }

    public static final boolean isPassable(Location loc) {
        blockCache.setAccess(loc.getWorld());
        boolean res = BlockProperties.isPassable(blockCache, loc.getX(), loc.getY(), loc.getZ(), blockCache.getTypeId(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        blockCache.cleanup();
        return res;
    }

    public static final boolean isPassable(Location from, Location to) {
        blockCache.setAccess(from.getWorld());
        PassableRayTracing rt = new PassableRayTracing();
        rt.setBlockCache(blockCache);
        rt.set(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
        rt.loop();
        boolean collides = rt.collides();
        blockCache.cleanup();
        rt.cleanup();
        return !collides;
    }

    public static final boolean isPassable(BlockCache access, Location loc) {
        return BlockProperties.isPassable(access, loc.getX(), loc.getY(), loc.getZ(), access.getTypeId(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    public static void applyConfig(RawConfigFile config, String pathPrefix) {
        Integer id;
        for (String input : config.getStringList(pathPrefix + "ignorepassable")) {
            id = RawConfigFile.parseTypeId(input);
            if (id == null || id < 0 || id >= 4096) {
                LogUtil.logWarning("[NoCheatplus] Bad block id (" + pathPrefix + "ignorepassable" + "): " + input);
                continue;
            }
            int n = id;
            blockFlags[n] = blockFlags[n] | 8L;
        }
        for (String input : config.getStringList(pathPrefix + "allowinstantbreak")) {
            id = RawConfigFile.parseTypeId(input);
            if (id == null || id < 0 || id >= 4096) {
                LogUtil.logWarning("[NoCheatplus] Bad block id (" + pathPrefix + "allowinstantbreak" + "): " + input);
                continue;
            }
            BlockProperties.setBlockProps(id, instantType);
        }
        ConfigurationSection section = config.getConfigurationSection(pathPrefix + "overrideflags");
        if (section != null) {
            Map entries = section.getValues(false);
            boolean hasErrors = false;
            for (Map.Entry entry : entries.entrySet()) {
                String key = (String)entry.getKey();
                Integer id2 = RawConfigFile.parseTypeId(key);
                if (id2 == null || id2 < 0 || id2 >= 4096) {
                    LogUtil.logWarning("[NoCheatplus] Bad block id (" + pathPrefix + "overrideflags" + "): " + key);
                    continue;
                }
                Object obj = entry.getValue();
                if (!(obj instanceof String)) {
                    LogUtil.logWarning("[NoCheatplus] Bad flags at " + pathPrefix + "overrideflags" + " for key: " + key);
                    hasErrors = true;
                    continue;
                }
                List<String> split = StringUtil.split((String)obj, Character.valueOf(' '), Character.valueOf(','), Character.valueOf('/'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf(';'), Character.valueOf('\t'));
                long flags = 0L;
                boolean error = false;
                for (String input : split) {
                    if ((input = input.trim()).isEmpty()) continue;
                    if (input.equalsIgnoreCase("default")) {
                        flags |= blockFlags[id2];
                        continue;
                    }
                    try {
                        flags |= BlockProperties.parseFlag(input);
                    }
                    catch (InputMismatchException e) {
                        LogUtil.logWarning("[NoCheatplus] Bad flag at " + pathPrefix + "overrideflags" + " for key " + key + " (skip setting flags for this block): " + input);
                        error = true;
                        hasErrors = true;
                        break;
                    }
                }
                if (error) continue;
                BlockProperties.blockFlags[id2.intValue()] = flags;
            }
            if (hasErrors) {
                LogUtil.logInfo("[NoCheatPlus] Overriding block-flags was not entirely successful, all available flags: \n" + StringUtil.join(flagNameMap.values(), "|"));
            }
        }
    }

    public static final boolean hasAnyFlags(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long flags) {
        return BlockProperties.hasAnyFlags(access, Location.locToBlock((double)minX), Location.locToBlock((double)minY), Location.locToBlock((double)minZ), Location.locToBlock((double)maxX), Location.locToBlock((double)maxY), Location.locToBlock((double)maxZ), flags);
    }

    public static final boolean hasAnyFlags(BlockCache access, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, long flags) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if ((blockFlags[access.getTypeId(x, y, z)] & flags) == 0L) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collides(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long flags) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((flags & 0x40L) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    double[] bounds;
                    int id = access.getTypeId(x, y, z);
                    long cFlags = blockFlags[id];
                    if ((cFlags & flags) == 0L || (bounds = access.getBounds(x, y, z)) == null || !BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, id, bounds, cFlags)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collidesId(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int id) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((blockFlags[id] & 0x40L) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    if (id != access.getTypeId(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collidesBlock(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int id) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - ((blockFlags[id] & 0x40L) != 0L ? 0.5625 : 0.0)));
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    double[] bounds;
                    if (id != access.getTypeId(x, y, z) || (bounds = access.getBounds(x, y, z)) == null || !BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, id, bounds, blockFlags[id])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean collidesBlock(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int x, int y, int z, int id) {
        double[] bounds = access.getBounds(x, y, z);
        if (bounds == null) {
            return false;
        }
        long flags = blockFlags[id];
        return BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, id, bounds, flags);
    }

    public static final boolean collidesBlock(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int x, int y, int z, int id, double[] bounds, long flags) {
        double bmaxX;
        double bmaxY;
        double bmaxZ;
        double bminX;
        double bminY;
        double bminZ;
        if ((flags & 1L) != 0L) {
            bminZ = 0.0;
            bminY = 0.0;
            bminX = 0.0;
            bmaxZ = 1.0;
            bmaxY = 1.0;
            bmaxX = 1.0;
        } else {
            if ((flags & 0x800L) != 0L) {
                bminZ = 0.0;
                bminX = 0.0;
                bmaxZ = 1.0;
                bmaxX = 1.0;
            } else {
                bminX = bounds[0];
                bminZ = bounds[2];
                bmaxX = bounds[3];
                bmaxZ = bounds[5];
            }
            if ((flags & 0x4000L) != 0L) {
                bminY = 0.0;
                int data = (access.getData(x, y, z) & 0xF) % 8;
                bmaxY = data < 3 ? 0.0 : 0.5;
            } else if ((flags & 0x8000L) != 0L) {
                bminY = 0.0;
                int data = (access.getData(x, y, z) & 0xF) % 8;
                bmaxY = 0.125 * (double)data;
            } else if ((flags & 0x40L) != 0L) {
                bminY = 0.0;
                bmaxY = 1.5;
            } else if ((flags & 0x100L) != 0L) {
                bminY = 0.0;
                bmaxY = 1.0;
            } else if ((flags & 0x2000L) != 0L) {
                int data8;
                bminY = 0.0;
                int data = access.getData(x, y, z);
                bmaxY = (data & 8) == 0 ? ((data8 = (data & 0xF) % 8) > 4 ? 0.5 : 1.0) : 1.0;
            } else if (id == Material.ENDER_PORTAL_FRAME.getId()) {
                bminY = 0.0;
                bmaxY = (access.getData(x, y, z) & 4) != 0 ? 1.0 : bounds[4];
            } else {
                bminY = bounds[1];
                bmaxY = bounds[4];
            }
        }
        if (minX >= bmaxX + (double)x || maxX < bminX + (double)x) {
            return false;
        }
        if (minY >= bmaxY + (double)y || maxY < bminY + (double)y) {
            return false;
        }
        return !(minZ >= bmaxZ + (double)z) && !(maxZ < bminZ + (double)z);
    }

    public static double[] getCorrectedBounds(BlockCache access, int x, int y, int z) {
        return BlockProperties.getCorrectedBounds(x, y, z, access.getTypeId(x, y, z), access.getBounds(x, y, z));
    }

    public static double[] getCorrectedBounds(int x, int y, int z, int id, double[] bounds) {
        if (bounds == null) {
            return null;
        }
        return bounds;
    }

    public static final boolean isOnGround(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return BlockProperties.isOnGround(access, minX, minY, minZ, maxX, maxY, maxZ, 0L);
    }

    public static final boolean isOnGround(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long ignoreFlags) {
        int maxBlockY = access.getMaxBlockY();
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - 0.5626));
        if (iMinY > maxBlockY) {
            return false;
        }
        int iMaxY = Math.min(Location.locToBlock((double)maxY), maxBlockY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        for (int x = iMinX; x <= iMaxX; ++x) {
            block1: for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMaxY; y >= iMinY; --y) {
                    boolean variable;
                    int id = access.getTypeId(x, y, z);
                    long flags = blockFlags[id];
                    if ((flags & 0x80L) == 0L || (flags & ignoreFlags) != 0L) continue;
                    double[] bounds = access.getBounds(x, y, z);
                    if (bounds == null) {
                        return true;
                    }
                    if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, x, y, z, id, bounds, flags) || BlockProperties.isPassableWorkaround(access, x, y, z, minX - (double)x, minY - (double)y, minZ - (double)z, id, maxX - minX, maxY - minY, maxZ - minZ, 1.0) && ((flags & 0x1000L) == 0L || BlockProperties.getGroundMinHeight(access, x, y, z, id, bounds, flags) > maxY - (double)y)) continue;
                    if (BlockProperties.getGroundMinHeight(access, x, y, z, id, bounds, flags) > maxY - (double)y) {
                        if (!BlockProperties.isFullBounds(bounds)) continue;
                        continue block1;
                    }
                    if (maxY - (double)y < 1.0) {
                        return true;
                    }
                    if (y >= maxBlockY) {
                        return true;
                    }
                    boolean bl = variable = (flags & 0x400L) != 0L;
                    if (y != iMaxY && !variable) {
                        return true;
                    }
                    int aboveId = access.getTypeId(x, y + 1, z);
                    long aboveFlags = blockFlags[aboveId];
                    if ((aboveFlags & 8L) != 0L) {
                        return true;
                    }
                    if ((aboveFlags & 0x80L) == 0L || (aboveFlags & 2L) != 0L || (aboveFlags & ignoreFlags) != 0L) {
                        return true;
                    }
                    if (!(variable |= (aboveFlags & 0x400L) != 0L) && id == aboveId) {
                        if (!BlockProperties.isFullBounds(bounds)) continue;
                        continue block1;
                    }
                    double[] aboveBounds = access.getBounds(x, y + 1, z);
                    if (aboveBounds == null) {
                        return true;
                    }
                    if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, Math.max(maxY, 1.49 + (double)y), maxZ, x, y + 1, z, aboveId, aboveBounds, aboveFlags)) {
                        return true;
                    }
                    if (BlockProperties.isPassableWorkaround(access, x, y + 1, z, minX - (double)x, minY - (double)(y + 1), minZ - (double)z, id, maxX - minX, maxY - minY, maxZ - minZ, 1.0)) {
                        return true;
                    }
                    if (BlockProperties.isFullBounds(aboveBounds)) continue block1;
                    if (!variable) continue;
                    if (BlockProperties.isSameShape(bounds, aboveBounds)) continue block1;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean isFullBounds(double[] bounds) {
        for (int i = 0; i < 3; ++i) {
            if (bounds[i] == 0.0 && bounds[i + 3] == 1.0) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSameShape(double[] bounds1, double[] bounds2) {
        for (int i = 0; i < 6; ++i) {
            if (bounds1[i] == bounds2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isDownStream(BlockCache access, int x, int y, int z, int data, double dX, double dZ) {
        if ((data & 8) == 0) {
            if (dX > 0.0) {
                if (data < 7 && BlockProperties.isLiquid(access.getTypeId(x + 1, y, z)) && access.getData(x + 1, y, z) > data) {
                    return true;
                }
                if (data > 0 && BlockProperties.isLiquid(access.getTypeId(x - 1, y, z)) && access.getData(x - 1, y, z) < data) {
                    return true;
                }
            } else if (dX < 0.0) {
                if (data < 7 && BlockProperties.isLiquid(access.getTypeId(x - 1, y, z)) && access.getData(x - 1, y, z) > data) {
                    return true;
                }
                if (data > 0 && BlockProperties.isLiquid(access.getTypeId(x + 1, y, z)) && access.getData(x + 1, y, z) < data) {
                    return true;
                }
            }
            if (dZ > 0.0) {
                if (data < 7 && BlockProperties.isLiquid(access.getTypeId(x, y, z + 1)) && access.getData(x, y, z + 1) > data) {
                    return true;
                }
                if (data > 0 && BlockProperties.isLiquid(access.getTypeId(x, y, z - 1)) && access.getData(x, y, z - 1) < data) {
                    return true;
                }
            } else if (dZ < 0.0) {
                if (data < 7 && BlockProperties.isLiquid(access.getTypeId(x, y, z - 1)) && access.getData(x, y, z - 1) > data) {
                    return true;
                }
                if (data > 0 && BlockProperties.isLiquid(access.getTypeId(x, y, z + 1)) && access.getData(x, y, z + 1) < data) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final long collectFlagsSimple(BlockCache access, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)minY);
        int iMaxY = Location.locToBlock((double)maxY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        long flags = 0L;
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    flags |= blockFlags[access.getTypeId(x, y, z)];
                }
            }
        }
        return flags;
    }

    public static float getBreakPenaltyInWater() {
        return breakPenaltyInWater;
    }

    public static void setBreakPenaltyInWater(float breakPenaltyInWater) {
        BlockProperties.breakPenaltyInWater = breakPenaltyInWater;
    }

    public static float getBreakPenaltyOffGround() {
        return breakPenaltyOffGround;
    }

    public static void setBreakPenaltyOffGround(float breakPenaltyOffGround) {
        BlockProperties.breakPenaltyOffGround = breakPenaltyOffGround;
    }

    public static void cleanup() {
        pLoc.cleanup();
        pLoc = null;
        blockCache.cleanup();
        blockCache = null;
    }

    public static final boolean isPassableRay(BlockCache access, int blockX, int blockY, int blockZ, double oX, double oY, double oZ, double dX, double dY, double dZ, double dT) {
        double maxZ;
        double minZ;
        double maxY;
        double minY;
        double maxX;
        double minX;
        int id = access.getTypeId(blockX, blockY, blockZ);
        if (BlockProperties.isPassable(id)) {
            return true;
        }
        double[] bounds = access.getBounds(blockX, blockY, blockZ);
        if (bounds == null) {
            return true;
        }
        if (dX < 0.0) {
            minX = dX * dT + oX + (double)blockX;
            maxX = oX + (double)blockX;
        } else {
            maxX = dX * dT + oX + (double)blockX;
            minX = oX + (double)blockX;
        }
        if (dY < 0.0) {
            minY = dY * dT + oY + (double)blockY;
            maxY = oY + (double)blockY;
        } else {
            maxY = dY * dT + oY + (double)blockY;
            minY = oY + (double)blockY;
        }
        if (dZ < 0.0) {
            minZ = dZ * dT + oZ + (double)blockZ;
            maxZ = oZ + (double)blockZ;
        } else {
            maxZ = dZ * dT + oZ + (double)blockZ;
            minZ = oZ + (double)blockZ;
        }
        if (!BlockProperties.collidesBlock(access, minX, minY, minZ, maxX, maxY, maxZ, blockX, blockY, blockZ, id, bounds, blockFlags[id])) {
            return true;
        }
        return BlockProperties.isPassableWorkaround(access, blockX, blockY, blockZ, oX, oY, oZ, id, dX, dY, dZ, dT);
    }

    static {
        for (Field field : BlockProperties.class.getDeclaredFields()) {
            String name = field.getName();
            if (!name.startsWith("F_")) continue;
            try {
                Long value = field.getLong(BlockProperties.class);
                flagNameMap.put(value, name.substring(2));
                nameFlagMap.put(name, value);
                nameFlagMap.put(name.substring(2), value);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        breakPenaltyInWater = 4.0f;
        breakPenaltyOffGround = 4.0f;
    }

    public static class BlockProps {
        public final ToolProps tool;
        public final long[] breakingTimes;
        public final float hardness;
        public final float efficiencyMod;

        public BlockProps(ToolProps tool, float hardness) {
            this(tool, hardness, 1.0f);
        }

        public BlockProps(ToolProps tool, float hardness, float efficiencyMod) {
            this.tool = tool;
            this.hardness = hardness;
            this.breakingTimes = new long[6];
            for (int i = 0; i < 6; ++i) {
                float multiplier = tool.materialBase == null ? 1.0f : (i < tool.materialBase.index ? 1.0f : MaterialBase.getById((int)i).breakMultiplier * 3.33f);
                this.breakingTimes[i] = (long)(5000.0f * hardness / multiplier);
            }
            this.efficiencyMod = efficiencyMod;
        }

        public BlockProps(ToolProps tool, float hardness, long[] breakingTimes) {
            this(tool, hardness, breakingTimes, 1.0f);
        }

        public BlockProps(ToolProps tool, float hardness, long[] breakingTimes, float efficiencyMod) {
            this.tool = tool;
            this.breakingTimes = breakingTimes;
            this.hardness = hardness;
            this.efficiencyMod = efficiencyMod;
        }

        public String toString() {
            return "BlockProps(" + this.hardness + " / " + this.tool.toString() + " / " + Arrays.toString(this.breakingTimes) + ")";
        }

        public void validate() {
            if (this.breakingTimes == null) {
                throw new IllegalArgumentException("Breaking times must not be null.");
            }
            if (this.breakingTimes.length != 6) {
                throw new IllegalArgumentException("Breaking times length must match the number of available tool types (6).");
            }
            if (this.tool == null) {
                throw new IllegalArgumentException("Tool must not be null.");
            }
            this.tool.validate();
        }
    }

    public static class ToolProps {
        public final ToolType toolType;
        public final MaterialBase materialBase;

        public ToolProps(ToolType toolType, MaterialBase materialBase) {
            this.toolType = toolType;
            this.materialBase = materialBase;
        }

        public String toString() {
            return "ToolProps(" + (Object)((Object)this.toolType) + "/" + (Object)((Object)this.materialBase) + ")";
        }

        public void validate() {
            if (this.toolType == null) {
                throw new IllegalArgumentException("ToolType must not be null.");
            }
            if (this.materialBase == null) {
                throw new IllegalArgumentException("MaterialBase must not be null");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MaterialBase {
        NONE(0, 1.0f),
        WOOD(1, 2.0f),
        STONE(2, 4.0f),
        IRON(3, 6.0f),
        DIAMOND(4, 8.0f),
        GOLD(5, 12.0f);

        public final int index;
        public final float breakMultiplier;

        private MaterialBase(int index, float breakMultiplier) {
            this.index = index;
            this.breakMultiplier = breakMultiplier;
        }

        public static final MaterialBase getById(int id) {
            for (MaterialBase base : MaterialBase.values()) {
                if (base.index != id) continue;
                return base;
            }
            throw new IllegalArgumentException("Bad id: " + id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolType {
        NONE,
        SWORD,
        SHEARS,
        SPADE,
        AXE,
        PICKAXE;

    }
}

