/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import org.bukkit.Location;

public abstract class RayTracing {
    protected double dX;
    protected double dY;
    protected double dZ;
    protected int blockX;
    protected int blockY;
    protected int blockZ;
    protected double oX;
    protected double oY;
    protected double oZ;
    protected double t = Double.MIN_VALUE;
    protected double tol = 0.0;
    protected int step = 0;
    private int maxSteps = Integer.MAX_VALUE;

    public RayTracing(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.set(x0, y0, z0, x1, y1, z1);
    }

    public RayTracing() {
        this.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public void set(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.dX = x1 - x0;
        this.dY = y1 - y0;
        this.dZ = z1 - z0;
        this.blockX = Location.locToBlock((double)x0);
        this.blockY = Location.locToBlock((double)y0);
        this.blockZ = Location.locToBlock((double)z0);
        this.oX = x0 - (double)this.blockX;
        this.oY = y0 - (double)this.blockY;
        this.oZ = z0 - (double)this.blockZ;
        this.t = 0.0;
        this.step = 0;
    }

    private static final double tDiff(double dTotal, double offset) {
        if (dTotal > 0.0) {
            return (1.0 - offset) / dTotal;
        }
        if (dTotal < 0.0) {
            return offset / -dTotal;
        }
        return Double.MAX_VALUE;
    }

    public void loop() {
        while (1.0 - this.t > this.tol) {
            double tZ;
            double tY;
            double tX = RayTracing.tDiff(this.dX, this.oX);
            double tMin = Math.min(tX, Math.min(tY = RayTracing.tDiff(this.dY, this.oY), tZ = RayTracing.tDiff(this.dZ, this.oZ)));
            if (tMin == Double.MAX_VALUE || this.t + tMin > 1.0) {
                tMin = 1.0 - this.t;
            }
            ++this.step;
            if (!this.step(this.blockX, this.blockY, this.blockZ, this.oX, this.oY, this.oZ, tMin) || this.t + tMin >= 1.0 - this.tol) break;
            boolean changed = false;
            this.oX += tMin * this.dX;
            if (tX == tMin) {
                if (this.dX < 0.0) {
                    this.oX = 1.0;
                    --this.blockX;
                    changed = true;
                } else if (this.dX > 0.0) {
                    this.oX = 0.0;
                    ++this.blockX;
                    changed = true;
                }
            } else if (this.oX >= 1.0 && this.dX > 0.0) {
                this.oX -= 1.0;
                ++this.blockX;
                changed = true;
            } else if (this.oX < 0.0 && this.dX < 0.0) {
                this.oX += 1.0;
                --this.blockX;
                changed = true;
            }
            this.oY += tMin * this.dY;
            if (tY == tMin) {
                if (this.dY < 0.0) {
                    this.oY = 1.0;
                    --this.blockY;
                    changed = true;
                } else if (this.dY > 0.0) {
                    this.oY = 0.0;
                    ++this.blockY;
                    changed = true;
                }
            } else if (this.oY >= 1.0 && this.dY > 0.0) {
                this.oY -= 1.0;
                ++this.blockY;
                changed = true;
            } else if (this.oY < 0.0 && this.dY < 0.0) {
                this.oY += 1.0;
                --this.blockY;
                changed = true;
            }
            this.oZ += tMin * this.dZ;
            if (tZ == tMin) {
                if (this.dZ < 0.0) {
                    this.oZ = 1.0;
                    --this.blockZ;
                    changed = true;
                } else if (this.dZ > 0.0) {
                    this.oZ = 0.0;
                    ++this.blockZ;
                    changed = true;
                }
            } else if (this.oZ >= 1.0 && this.dZ > 0.0) {
                this.oZ -= 1.0;
                ++this.blockZ;
                changed = true;
            } else if (this.oZ < 0.0 && this.dZ < 0.0) {
                this.oZ += 1.0;
                --this.blockZ;
                changed = true;
            }
            this.t += tMin;
            if (changed && this.step < this.maxSteps) continue;
            break;
        }
    }

    public int getStepsDone() {
        return this.step;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public void setMaxSteps(int maxSteps) {
        this.maxSteps = maxSteps;
    }

    protected abstract boolean step(int var1, int var2, int var3, double var4, double var6, double var8, double var10);
}

