/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.components.TickListener;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.OnDemandTickListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TickTask
implements Runnable {
    public static final int lagMaxTicks = 80;
    private static final Set<PermissionUpdateEntry> permissionUpdates = new LinkedHashSet<PermissionUpdateEntry>(50);
    private static final List<ViolationData> delayedActions = new LinkedList<ViolationData>();
    private static final Set<TickListener> tickListeners = new LinkedHashSet<TickListener>();
    private static final long[] tickDurations = new long[80];
    private static final long[] tickDurationsSq = new long[80];
    private static final long lagMaxCoveredMs = 324050L;
    private static long[] spikeDurations = new long[]{150L, 450L, 1000L, 5000L};
    private static ActionFrequency[] spikes = new ActionFrequency[spikeDurations.length];
    protected static int taskId = -1;
    protected static int tick = 0;
    protected static long timeStart = 0L;
    protected static long timeLast = 0L;
    protected static boolean locked = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeActions() {
        ArrayList<ViolationData> copyActions;
        List<ViolationData> list = delayedActions;
        synchronized (list) {
            if (delayedActions.isEmpty()) {
                return;
            }
            copyActions = new ArrayList<ViolationData>(delayedActions);
            delayedActions.clear();
        }
        for (int i = 0; i < copyActions.size(); ++i) {
            ((ViolationData)copyActions.get(i)).executeActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePermissions() {
        ArrayList<PermissionUpdateEntry> copyPermissions;
        Set<PermissionUpdateEntry> set = permissionUpdates;
        synchronized (set) {
            if (permissionUpdates.isEmpty()) {
                return;
            }
            copyPermissions = new ArrayList<PermissionUpdateEntry>(permissionUpdates);
            permissionUpdates.clear();
        }
        for (int i = 0; i < copyPermissions.size(); ++i) {
            String[] perms;
            PermissionUpdateEntry entry = (PermissionUpdateEntry)copyPermissions.get(i);
            Player player = DataManager.getPlayer(entry.playerName);
            if (player == null || !player.isOnline() || (perms = entry.checkType.getConfigFactory().getConfig(player).getCachePermissions()) == null) continue;
            ICheckData data = entry.checkType.getDataFactory().getData(player);
            for (int j = 0; j < perms.length; ++j) {
                String permission = perms[j];
                data.setCachedPermission(permission, player.hasPermission(permission));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestPermissionUpdate(String playerName, CheckType checkType) {
        Set<PermissionUpdateEntry> set = permissionUpdates;
        synchronized (set) {
            if (locked) {
                return;
            }
            permissionUpdates.add(new PermissionUpdateEntry(playerName, checkType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestActionsExecution(ViolationData actions) {
        List<ViolationData> list = delayedActions;
        synchronized (list) {
            if (locked) {
                return;
            }
            delayedActions.add(actions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTickListener(TickListener listener) {
        Set<TickListener> set = tickListeners;
        synchronized (set) {
            if (locked) {
                return;
            }
            if (!tickListeners.contains(listener)) {
                tickListeners.add(listener);
            }
            if (listener instanceof OnDemandTickListener) {
                ((OnDemandTickListener)listener).setRegistered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeTickListener(TickListener listener) {
        Set<TickListener> set = tickListeners;
        synchronized (set) {
            if (listener instanceof OnDemandTickListener) {
                ((OnDemandTickListener)listener).setRegistered(false);
            }
            return tickListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllTickListeners() {
        Set<TickListener> set = tickListeners;
        synchronized (set) {
            for (TickListener listener : tickListeners) {
                if (!(listener instanceof OnDemandTickListener)) continue;
                try {
                    OnDemandTickListener odtl = (OnDemandTickListener)listener;
                    if (!odtl.isRegistered()) continue;
                    odtl.setRegistered(false);
                }
                catch (Throwable t) {
                    LogUtil.logWarning("[NoCheatPlus] Failed to set OnDemandTickListener to unregistered state: " + t.getClass().getSimpleName());
                    LogUtil.logWarning(t);
                }
            }
            tickListeners.clear();
        }
    }

    public static final int getTick() {
        return tick;
    }

    public static final long getTimeStart() {
        return timeStart;
    }

    public static final long getTimeLast() {
        return timeLast;
    }

    public static final float getLag(long ms) {
        return TickTask.getLag(ms, false);
    }

    public static final float getLag(long ms, boolean exact) {
        long passed;
        if (ms < 0L) {
            return TickTask.getLag(0L, exact);
        }
        if (ms > 324050L) {
            return TickTask.getLag(324050L, exact);
        }
        int tick = TickTask.tick;
        if (tick == 0) {
            return 1.0f;
        }
        int add = ms > 0L && ms % 50L == 0L ? 0 : 1;
        int totalTicks = Math.min(tick, add + (int)(ms / 50L));
        int maxTick = Math.min(80, totalTicks);
        long sum = tickDurations[maxTick - 1];
        long covered = maxTick * 50;
        if (totalTicks > 80) {
            int maxTickSq = Math.min(80, totalTicks / 80);
            if (80 * maxTickSq == totalTicks) {
                --maxTickSq;
            }
            sum += tickDurationsSq[maxTickSq - 1];
            covered += (long)(4000 * maxTickSq);
        }
        if (exact && (passed = System.currentTimeMillis() - timeLast) > 50L) {
            covered += 50L;
            sum += passed;
        }
        return Math.max(1.0f, (float)sum / (float)covered);
    }

    public static final int getModerateLagSpikes() {
        spikes[0].update(System.currentTimeMillis());
        return (int)spikes[0].score(1.0f);
    }

    public static final int getHeavyLagSpikes() {
        spikes[1].update(System.currentTimeMillis());
        return (int)spikes[1].score(1.0f);
    }

    public static final int getNumberOfLagSpikes() {
        spikes[0].update(System.currentTimeMillis());
        return (int)spikes[0].score(1.0f);
    }

    public static final long[] getLagSpikeDurations() {
        return Arrays.copyOf(spikeDurations, spikeDurations.length);
    }

    public static final int[] getLagSpikes() {
        int[] out = new int[spikeDurations.length];
        long now = System.currentTimeMillis();
        for (int i = 0; i < spikeDurations.length; ++i) {
            spikes[i].update(now);
            out[i] = (int)spikes[i].score(1.0f);
        }
        return out;
    }

    public boolean isLocked() {
        return locked;
    }

    public static int start(Plugin plugin) {
        TickTask.cancel();
        taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, (Runnable)new TickTask(), 1L, 1L);
        timeStart = taskId != -1 ? System.currentTimeMillis() : 0L;
        return taskId;
    }

    public static void cancel() {
        if (taskId == -1) {
            return;
        }
        Bukkit.getScheduler().cancelTask(taskId);
        taskId = -1;
    }

    public static void setLocked(boolean locked) {
        TickTask.locked = locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purge() {
        Collection<Object> collection = permissionUpdates;
        synchronized (collection) {
            permissionUpdates.clear();
        }
        collection = delayedActions;
        synchronized (collection) {
            delayedActions.clear();
        }
        collection = tickListeners;
        synchronized (collection) {
            tickListeners.clear();
        }
    }

    public static void reset() {
        int i;
        tick = 0;
        timeLast = 0L;
        for (i = 0; i < 80; ++i) {
            TickTask.tickDurations[i] = 0L;
            TickTask.tickDurationsSq[i] = 0L;
        }
        for (i = 0; i < spikeDurations.length; ++i) {
            spikes[i].clear(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListeners() {
        ArrayList<TickListener> copyListeners;
        Set<TickListener> set = tickListeners;
        synchronized (set) {
            if (tickListeners.isEmpty()) {
                return;
            }
            copyListeners = new ArrayList<TickListener>(tickListeners);
        }
        for (int i = 0; i < copyListeners.size(); ++i) {
            TickListener listener = (TickListener)copyListeners.get(i);
            try {
                listener.onTick(tick, timeLast);
                continue;
            }
            catch (Throwable t) {
                LogUtil.logSevere("[NoCheatPlus] (TickTask) TickListener generated an exception:");
                LogUtil.logSevere(t);
            }
        }
    }

    public void run() {
        int i;
        long lastDur;
        TickTask.executeActions();
        TickTask.updatePermissions();
        this.notifyListeners();
        long time = System.currentTimeMillis();
        if (timeLast > time) {
            LogUtil.logWarning("[NoCheatPlus] System time ran backwards (" + timeLast + "->" + time + "), clear all data and history...");
            DataManager.clearData(CheckType.ALL);
            lastDur = 50L;
            for (i = 0; i < spikeDurations.length; ++i) {
                spikes[i].clear(0L);
            }
        } else {
            lastDur = tick > 0 ? time - timeLast : 50L;
        }
        if (tick > 0 && tick % 80 == 0) {
            long sum = tickDurations[79];
            for (int i2 = 1; i2 < 80; ++i2) {
                TickTask.tickDurationsSq[i2] = tickDurationsSq[i2 - 1] + sum;
            }
            TickTask.tickDurationsSq[0] = sum;
        }
        for (i = 1; i < 80; ++i) {
            TickTask.tickDurations[i] = tickDurations[i - 1] + lastDur;
        }
        TickTask.tickDurations[0] = lastDur;
        if (lastDur > spikeDurations[0] && tick > 0) {
            spikes[0].add(time, 1.0f);
            for (i = 1; i < spikeDurations.length && lastDur > spikeDurations[i]; ++i) {
                spikes[i].add(time, 1.0f);
            }
        }
        ++tick;
        timeLast = time;
    }

    static {
        for (int i = 0; i < spikeDurations.length; ++i) {
            TickTask.spikes[i] = new ActionFrequency(3, 1200000L);
        }
    }

    protected static final class PermissionUpdateEntry {
        public CheckType checkType;
        public String playerName;
        private final int hashCode;

        public PermissionUpdateEntry(String playerName, CheckType checkType) {
            this.playerName = playerName;
            this.checkType = checkType;
            this.hashCode = playerName.hashCode() ^ checkType.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PermissionUpdateEntry)) {
                return false;
            }
            PermissionUpdateEntry other = (PermissionUpdateEntry)obj;
            return this.playerName.equals(other.playerName) && this.checkType.equals((Object)other.checkType);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

