/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.build;

import fr.neatmonster.nocheatplus.utilities.build.ResourceUtil;
import java.util.HashMap;
import java.util.Map;

public class BuildParameters {
    private static final Map<String, String> fileContents = new HashMap<String, String>();
    public static final String buildTimeString;
    public static final String buildSeries;
    public static final int buildNumber;
    public static final int testLevel;
    public static final int debugLevel;

    public static String getMappingValue(String path, String preset) {
        String input = fileContents.get(path);
        if (input == null) {
            return preset;
        }
        return input;
    }

    public static String getString(String path, String preset) {
        String input = fileContents.get(path);
        if (input == null) {
            return preset;
        }
        if (input.startsWith("${") && input.endsWith("}")) {
            return preset;
        }
        return input;
    }

    public static Boolean getBoolean(String path, Boolean preset) {
        String input = fileContents.get(path);
        if (input == null) {
            return preset;
        }
        return ResourceUtil.getBoolean(input, preset);
    }

    public static Integer getInteger(String path, Integer preset) {
        String input = fileContents.get(path);
        if (input == null) {
            return preset;
        }
        return ResourceUtil.getInteger(input, preset);
    }

    static {
        String content = null;
        try {
            content = ResourceUtil.fetchResource(BuildParameters.class, "BuildParameters.properties");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (content != null) {
            ResourceUtil.parseToMap(content, fileContents);
        }
        buildTimeString = BuildParameters.getString("BUILD_TIMESTAMP", "?");
        buildSeries = BuildParameters.getString("BUILD_SERIES", "?");
        buildNumber = BuildParameters.getInteger("BUILD_NUMBER", Integer.MIN_VALUE);
        testLevel = BuildParameters.getInteger("TEST_LEVEL", 0);
        debugLevel = BuildParameters.getInteger("DEBUG_LEVEL", 0);
    }
}

