/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.bktree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BKModTree<V, N extends Node<V, N>, L extends LookupEntry<V, N>> {
    protected final NodeFactory<V, N> nodeFactory;
    protected final LookupEntryFactory<V, N, L> resultFactory;
    protected N root = null;
    protected boolean visit = false;

    public BKModTree(NodeFactory<V, N> nodeFactory, LookupEntryFactory<V, N, L> resultFactory) {
        this.nodeFactory = nodeFactory;
        this.resultFactory = resultFactory;
    }

    public void clear() {
        this.root = null;
    }

    public L lookup(V value, int range, int seekMax, boolean create) {
        LinkedList<Node> inRange = new LinkedList<Node>();
        if (this.root == null) {
            if (create) {
                this.root = this.nodeFactory.newNode(value, null);
                return this.resultFactory.newLookupEntry(inRange, this.root, 0, true);
            }
            return this.resultFactory.newLookupEntry(inRange, null, 0, false);
        }
        ArrayList<N> open = new ArrayList<N>();
        open.add(this.root);
        Node insertion = null;
        int insertionDist = 0;
        do {
            Node current = (Node)open.remove(open.size() - 1);
            int distance = this.distance(current.value, value);
            if (this.visit) {
                this.visit(current, value, distance);
            }
            if (distance == 0) {
                return this.resultFactory.newLookupEntry(inRange, current, distance, false);
            }
            if (create && insertion == null && !current.hasChild(distance)) {
                insertion = current;
                insertionDist = distance;
            }
            if (Math.abs(distance) <= range) {
                inRange.add(current);
                if (seekMax > 0 && inRange.size() >= seekMax && (!create || insertion != null)) break;
            }
            current.getChildren(distance, range, open);
        } while (!open.isEmpty());
        if (create && insertion != null) {
            Node newNode = this.nodeFactory.newNode(value, insertion);
            insertion.putChild(insertionDist, newNode);
            return this.resultFactory.newLookupEntry(inRange, newNode, 0, true);
        }
        return this.resultFactory.newLookupEntry(inRange, null, 0, false);
    }

    protected void visit(N node, V value, int distance) {
    }

    public abstract int distance(V var1, V var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LookupEntryFactory<V, N extends Node<V, N>, L extends LookupEntry<V, N>> {
        public L newLookupEntry(Collection<N> var1, N var2, int var3, boolean var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LookupEntry<V, N extends Node<V, N>> {
        public final Collection<N> nodes;
        public final N match;
        public final int distance;
        public final boolean isNew;

        public LookupEntry(Collection<N> nodes, N match, int distance, boolean isNew) {
            this.nodes = nodes;
            this.match = match;
            this.distance = distance;
            this.isNew = isNew;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NodeFactory<V, N extends Node<V, N>> {
        public N newNode(V var1, N var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleNode<V>
    extends HashMapNode<V, SimpleNode<V>> {
        public SimpleNode(V content) {
            super(content);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashMapNode<V, N extends HashMapNode<V, N>>
    extends MapNode<V, N> {
        protected int initialCapacity = 4;
        protected float loadFactor = 0.75f;

        public HashMapNode(V value) {
            super(value);
        }

        @Override
        protected Map<Integer, N> newMap() {
            return new HashMap(this.initialCapacity, this.loadFactor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MapNode<V, N extends HashMapNode<V, N>>
    extends Node<V, N> {
        protected Map<Integer, N> children = null;
        protected int maxIterate = 12;

        public MapNode(V value) {
            super(value);
        }

        @Override
        public N putChild(int distance, N child) {
            if (this.children == null) {
                this.children = this.newMap();
            }
            this.children.put(distance, child);
            return child;
        }

        @Override
        public N getChild(int distance) {
            if (this.children == null) {
                return null;
            }
            return (N)((HashMapNode)this.children.get(distance));
        }

        @Override
        public boolean hasChild(int distance) {
            if (this.children == null) {
                return false;
            }
            return this.children.containsKey(distance);
        }

        @Override
        public Collection<N> getChildren(int distance, int range, Collection<N> nodes) {
            if (this.children == null) {
                return nodes;
            }
            if (this.children.size() > this.maxIterate) {
                for (int i = distance - range; i < distance + range + 1; ++i) {
                    HashMapNode child = (HashMapNode)this.children.get(i);
                    if (child == null) continue;
                    nodes.add(child);
                }
            } else {
                for (Integer key : this.children.keySet()) {
                    if (Math.abs(distance - key) > range) continue;
                    nodes.add(this.children.get(key));
                }
            }
            return nodes;
        }

        protected abstract Map<Integer, N> newMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Node<V, N extends Node<V, N>> {
        public V value;

        public Node(V value) {
            this.value = value;
        }

        public abstract N putChild(int var1, N var2);

        public abstract N getChild(int var1);

        public abstract boolean hasChild(int var1);

        public abstract Collection<N> getChildren(int var1, int var2, Collection<N> var3);
    }
}

