/*
 * Decompiled with CFR 0.152.
 */
package com.teaminfinity.infinitylagg.apis;

import com.teaminfinity.infinitylagg.apis.MobAPI;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;

public abstract class LaggAPI {
    public static int removeDrops() {
        int removed = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity e : world.getEntitiesByClass(Item.class)) {
                e.remove();
                ++removed;
            }
        }
        return removed;
    }

    public static int removeEntities() {
        int total = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!MobAPI.isGeneralEntityRemovable(entity)) continue;
                entity.remove();
                ++total;
            }
        }
        return total;
    }

    public static int killAnimals() {
        int killed = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof LivingEntity) || !MobAPI.isAnAnimal(entity) || MobAPI.isAPlayer(entity)) continue;
                entity.remove();
                ++killed;
            }
        }
        return killed;
    }

    public static int killAllMobs() {
        return LaggAPI.killMonsters() + LaggAPI.killAnimals();
    }

    public static int killMonsters() {
        int killed = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof LivingEntity) || !MobAPI.isAMob(entity) || MobAPI.isAPlayer(entity)) continue;
                entity.remove();
                ++killed;
            }
        }
        return killed;
    }

    public static int unloadChunks() {
        int unloaded = 0;
        for (World world : Bukkit.getWorlds()) {
            Chunk[] chunkArray = world.getLoadedChunks();
            int n = chunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk chunk = chunkArray[n2];
                chunk.unload(true, true);
                ++n2;
            }
        }
        return unloaded;
    }
}

