/*
 * Decompiled with CFR 0.152.
 */
package com.teaminfinity.infinitylagg.listeners;

import com.teaminfinity.infinitylagg.apis.LaggAPI;
import com.teaminfinity.infinitylagg.apis.MobAPI;
import com.teaminfinity.infinitylagg.enums.DataStore;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class WorldListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemDrop(ItemSpawnEvent e) {
        if (!DataStore.WORLD_ITEM_MERGER_ENABLED.getBooleanValue()) {
            return;
        }
        ItemStack i = e.getEntity().getItemStack();
        int type = i.getTypeId();
        int c = i.getAmount();
        MaterialData data = i.getData();
        int mergeradius = DataStore.WORLD_ITEM_MERGER_RADIUS.getIntegerValue();
        for (Entity entity : e.getEntity().getNearbyEntities((double)mergeradius, (double)mergeradius, (double)mergeradius)) {
            ItemStack ni;
            if (!(entity instanceof Item) || type != (ni = ((Item)entity).getItemStack()).getTypeId() || !data.equals((Object)ni.getData()) || ni.getAmount() + c > 64 || i.getMaxStackSize() < ni.getAmount() + c) continue;
            if (entity.isDead()) {
                return;
            }
            entity.remove();
            i.setAmount(ni.getAmount() + c);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (DataStore.WORLD_MAX_MOBS_ENABLED.getBooleanValue()) {
            int total = 0;
            for (Entity entity : e.getEntity().getWorld().getEntities()) {
                if (!(entity instanceof LivingEntity)) continue;
                ++total;
            }
            if (total >= DataStore.WORLD_MAX_MOBS.getIntegerValue()) {
                if (MobAPI.isAMob((Entity)e.getEntity())) {
                    LaggAPI.killAllMobs();
                } else {
                    LaggAPI.killAnimals();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChunkLoad(ChunkLoadEvent e) {
        if (DataStore.WORLD_MAX_LOADED_CHUNKS_ENABLED.getBooleanValue() && e.getWorld().getLoadedChunks().length >= DataStore.WORLD_MAX_LOADED_CHUNKS.getIntegerValue()) {
            LaggAPI.unloadChunks();
        }
    }
}

