/*
 * Decompiled with CFR 0.152.
 */
package com.teaminfinity.infinitylagg.utilities;

import com.teaminfinity.infinitylagg.Core;
import com.teaminfinity.infinitylagg.enums.DataStore;
import com.teaminfinity.infinitylagg.utilities.ChatUtility;
import com.teaminfinity.infinitylagg.utilities.Files;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ConfigHandler {
    public static Files configFile = null;

    public ConfigHandler() {
        if (configFile == null) {
            configFile = new Files(Core.instance.getDataFolder(), "config");
            if (!configFile.fileExists()) {
                this.regenerateConfig();
            }
            this.loadAllValues();
        }
    }

    private void regenerateConfig() {
        if (configFile.fileExists()) {
            configFile.DeleteFile();
        }
        configFile.createFile();
        configFile.loadFile();
        DataStore[] dataStoreArray = DataStore.values();
        int n = dataStoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataStore data = dataStoreArray[n2];
            configFile.set(data.key, data.getValue());
            ++n2;
        }
        configFile.saveFile();
    }

    private void loadAllValues() {
        configFile.loadFile();
        try {
            DataStore[] dataStoreArray = DataStore.values();
            int n = dataStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataStore data = dataStoreArray[n2];
                try {
                    String stringType = configFile.getString(data.key);
                    if (stringType == null) {
                        System.out.println("[AntiLagg] Incompatible config version! Regenerating!");
                        this.regenerateConfig();
                        this.loadAllValues();
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                switch (data.type) {
                    case STRING: {
                        data.setValue(ChatUtility.addColour(configFile.getString(data.key)));
                        break;
                    }
                    case INTEGER: {
                        data.setValue(configFile.getInt(data.key));
                        break;
                    }
                    case DOUBLE: {
                        data.setValue(configFile.getDouble(data.key));
                        break;
                    }
                    case LIST_STRING: {
                        data.setValue(configFile.getStringList(data.key));
                        break;
                    }
                    case BOOLEAN: {
                        data.setValue(configFile.getBoolean(data.key));
                        break;
                    }
                    case LONG: {
                        data.setValue(configFile.getLong(data.key));
                        break;
                    }
                    case FLOAT: {
                        data.setValue(Float.valueOf(configFile.getFloat(data.key)));
                        break;
                    }
                    default: {
                        System.out.println("[AntiLagg] Unable to find value type for: " + data.toString());
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            System.out.println("[AntiLagg] Unable to load values! Restarting!");
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Core.instance, new Runnable(){

                @Override
                public void run() {
                    ConfigHandler.this.regenerateConfig();
                    ConfigHandler.this.loadAllValues();
                }
            }, 20L);
        }
    }
}

