/*
 * Decompiled with CFR 0.152.
 */
package com.teaminfinity.infinitylagg.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class Files {
    private static ArrayList<Files> loadedFiles = new ArrayList();
    private File folder;
    private File file;
    private YamlConfiguration config;

    public Files(File folder, String fileName) {
        this.folder = folder;
        this.file = new File(folder, String.valueOf(fileName) + ".yml");
        this.config = new YamlConfiguration();
    }

    public Files(File folder, File file) {
        this.folder = folder;
        this.file = file;
        this.config = new YamlConfiguration();
    }

    public boolean DeleteFile() {
        this.file.delete();
        return true;
    }

    public Set<String> getKeys() {
        return this.config.getKeys(false);
    }

    public boolean createFile() {
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean fileExists() {
        return this.file.exists();
    }

    public boolean loadFile() {
        if (loadedFiles.contains(this)) {
            return true;
        }
        try {
            this.config.load(this.file);
            return true;
        }
        catch (FileNotFoundException e) {
            this.createFile();
            return true;
        }
        catch (IOException e) {
            this.createFile();
            return false;
        }
        catch (InvalidConfigurationException e) {
            this.createFile();
            return false;
        }
    }

    public boolean saveFile() {
        try {
            this.config.save(this.file);
            return true;
        }
        catch (IOException e) {
            System.out.println("Failed to save file: " + this.file.getName());
            return false;
        }
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public long getLong(String path) {
        return this.config.getLong(path);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public List<Integer> getIntList(String path) {
        return this.config.getIntegerList(path);
    }

    public float getFloat(String path) {
        return (float)this.getDouble(path);
    }

    public List<?> getList(String path) {
        return this.config.getList(path);
    }

    public double getDouble(String path) {
        return this.config.getDouble(path);
    }
}

