package pl.islandworld;

import java.util.List;

import org.bukkit.Material;

/**
 * 
 * @author Gnacik
 * 
 */
public class Config
{
	private static IslandWorld plugin;

	public static String WORLD_ISLE = "IslandWorld";
	public static String WORLD_SPAWN = "SpawnWorld";

	@SuppressWarnings("deprecation")
	public static int WORLD_BLOCK = Material.AIR.getId();

	public static boolean SET_HOME = false;
	public static boolean CLEANINV = false;

	public static boolean STRICT_PARTY = false;

	public static String LANGUAGE = "en";

	public static String CHAT_PREFIX = "none";

	public static int MAX_COUNT = 100;
	public static int ISLE_SIZE = 100;
	public static int ISLE_HEIGHT = 20;

	public static int TIME_LIMIT = 10;
	public static int CALC_LIMIT = 10;
	public static int RELOAD_TIME = 30;
	public static int AUTO_PURGE = 0;
	public static int BACKUP_MAX_DAYS = 0;

	public static boolean DEBUG = false;
	public static boolean ISDEBUG = false;

	public static boolean BACKUP_ON_START = false;

	public static boolean ITEM_PROTECTION = false;
	public static boolean CALC_ON_ENTER = false;
	public static boolean BIOME_PERMISSION = false;

	public static boolean ECONOMY = false;
	public static boolean FLAG_PVP;
	public static boolean NEGATIVE_BUILD;

	public static List<String> ALLOWED_ITEM_LIST;
	public static List<String> BLOCKED_ITEM_LIST;
	public static List<String> IGNORED_BLOCK_LIST;

	public static String mysql_host = "";
	public static String mysql_port = "";
	public static String mysql_user = "";
	public static String mysql_pass = "";
	public static String mysql_base = "";

	public Config(IslandWorld plug)
	{
		plugin = plug;
	}

	@SuppressWarnings("unchecked")
	public void setupDefaults()
	{
		// Setup defaults
		DEBUG = plugin.getConfig().getBoolean("debug", false);
		ISDEBUG = plugin.getConfig().getBoolean("island-debug", false);
		MAX_COUNT = plugin.getConfig().getInt("max-count", 100);
		WORLD_SPAWN = plugin.getConfig().getString("world-spawn", "IslandWorld");
		WORLD_ISLE = plugin.getConfig().getString("world-isle", "IslandWorld");
		ISLE_SIZE = plugin.getConfig().getInt("island-size", 100);
		ISLE_HEIGHT = plugin.getConfig().getInt("island-height", 20);
		WORLD_BLOCK = plugin.getConfig().getInt("world-block-id", 0);
		SET_HOME = plugin.getConfig().getBoolean("set-home", false);
		CLEANINV = plugin.getConfig().getBoolean("clean-inventory", false);
		TIME_LIMIT = plugin.getConfig().getInt("time-limit", 10);
		CALC_LIMIT = plugin.getConfig().getInt("calc-limit", 10);
		AUTO_PURGE = plugin.getConfig().getInt("auto-purge", 0);
		BACKUP_MAX_DAYS = plugin.getConfig().getInt("backup-max-days", 0);

		LANGUAGE = plugin.getConfig().getString("language", "en");
		CHAT_PREFIX = plugin.getConfig().getString("chat-prefix", "none");

		BACKUP_ON_START = plugin.getConfig().getBoolean("backup-on-start", false);
		ITEM_PROTECTION = plugin.getConfig().getBoolean("item-protection", false);
		STRICT_PARTY = plugin.getConfig().getBoolean("strict-party", false);
		CALC_ON_ENTER = plugin.getConfig().getBoolean("calc-on-enter", false);
		BIOME_PERMISSION = plugin.getConfig().getBoolean("per-biome-perms", false);
		ECONOMY = plugin.getConfig().getBoolean("economy-enabled", false);
		FLAG_PVP = plugin.getConfig().getBoolean("flags.pvp", false);
		NEGATIVE_BUILD = plugin.getConfig().getBoolean("negative-build", true);

		ALLOWED_ITEM_LIST = (List<String>) plugin.getConfig().getList("allowed-list");
		BLOCKED_ITEM_LIST = (List<String>) plugin.getConfig().getList("blocked-list");
		IGNORED_BLOCK_LIST = (List<String>) plugin.getConfig().getList("ignored-list");

		RELOAD_TIME = plugin.getConfig().getInt("reload-time", 30);
		if (RELOAD_TIME <= 1)
			RELOAD_TIME = 30;

		mysql_host = plugin.getConfig().getString("database.host", "localhost");
		mysql_port = plugin.getConfig().getString("database.port", "3306");
		mysql_user = plugin.getConfig().getString("database.user", "islandworld");
		mysql_pass = plugin.getConfig().getString("database.pass", "password");
		mysql_base = plugin.getConfig().getString("database.base", "islandworld");
	}

}