package pl.islandworld;

import net.milkbowl.vault.economy.Economy;

import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

/**
 * 
 * @author Gnacik
 * 
 */
public class Eco
{
	public static Economy econ = null;

	private static boolean setupEconomy(IslandWorld plugin)
	{
		if (plugin.getServer().getPluginManager().getPlugin("Vault") == null)
		{
			plugin.ShowWarn("You need to have VAULT plugin installed.");
		}
		RegisteredServiceProvider<Economy> rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
		if (rsp == null)
		{
			return false;
		}
		econ = rsp.getProvider();

		return econ != null;
	}

	public static boolean ecoCheck(IslandWorld plugin, Player player, String command)
	{
		if (!Config.ECONOMY)
			return true;

		if (econ == null && !setupEconomy(plugin))
		{
			plugin.debug("Problem with Vault plugin");
			return false;
		}

		int cost = plugin.getConfig().getInt("command-cost." + command, 0);

		if (cost == 0)
			cost = plugin.getConfig().getInt("command-cost.global", 0);

		if (cost <= 0)
			return true;

		if (cost > 0 && econ.getBalance(player.getName()) > cost && econ.withdrawPlayer(player.getName(), cost).transactionSuccess())
			return true;

		return false;
	}
}