package pl.islandworld;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Level;

import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import pl.islandworld.commands.Challenges;
import pl.islandworld.commands.Island;
import pl.islandworld.commands.IslandDev;
import pl.islandworld.database.MySQL;
import pl.islandworld.entity.Challenge;
import pl.islandworld.entity.MyLocation;
import pl.islandworld.entity.SimpleIslandV4;
import pl.islandworld.entity.SimpleIslandV5;
import pl.islandworld.entity.SimpleIslandV6;
import pl.islandworld.listeners.ChatListener;
import pl.islandworld.listeners.IslandProtectionListeners;
import pl.islandworld.listeners.IslandWorldListener;
import pl.islandworld.listeners.ItemProtectionListeners;
import pl.islandworld.listeners.MoveProtectionListener;
import pl.islandworld.listeners.NewListeners;
import pl.islandworld.listeners.PlayerMoveListener;

import com.sk89q.worldedit.world.storage.InvalidFormatException;
import com.sk89q.worldedit.schematic.SchematicFormat;

/**
 * 
 * @author Gnacik
 * 
 */
public class IslandWorld extends JavaPlugin
{
	public static boolean REGEN_IN_PROGRESS = false;

	public static boolean LOADED = false;

	public static boolean purgeInProgress = false;

	public static String DESIGN_NORMAL = "normal";
	public static String DESIGN_SPECIAL = "special";

	private Biome DEFAULT_BIOME = null;

	private List<Challenge> challengeList;
	private HashMap<String, List<Integer>> pChaList;

	private List<SimpleIslandV6> freeList;
	private HashMap<String, SimpleIslandV6> isleList;

	private HashMap<String, SimpleIslandV6> helpList;

	private HashMap<String, String> visitList;
	private HashMap<String, String> partyList;
	private HashMap<Player, Integer> tpList;

	private HashMap<String, Integer> pointList;
	private boolean POINTS_BUSY = false;
	public long rankLastUpdate = 0;

	private HashMap<String, SimpleIslandV6> coordList;

	private List<Player> deleteList;

	private ItemStack globalReward = null;

	private World world = null;
	private World spawnWorld = null;

	public void ShowWarn(String msg)
	{
		getLogger().warning("============================");
		getLogger().warning("ERROR");
		getLogger().warning("============================");
		getLogger().warning(msg);
		getLogger().warning("============================");
	}

	@Override
	public void onEnable()
	{
		/*
		 * try
		 * {
		 * final File[] libs = new File[]
		 * {
		 * new File(getDataFolder(), "javolution.jar")
		 * };
		 * for (final File lib : libs)
		 * {
		 * if (!lib.exists())
		 * {
		 * ShowWarn("Critical error, cannot find file: " + lib.getName());
		 * Bukkit.getServer().getPluginManager().disablePlugin(this);
		 * return;
		 * }
		 * addClassPath(getJarUrl(lib));
		 * }
		 * }
		 * catch (final Exception e)
		 * {
		 * e.printStackTrace();
		 * }
		 */

		freeList = new ArrayList<SimpleIslandV6>();
		deleteList = new ArrayList<Player>();
		challengeList = new ArrayList<Challenge>();

		isleList = new HashMap<String, SimpleIslandV6>();
		pChaList = new HashMap<String, List<Integer>>();

		helpList = new HashMap<String, SimpleIslandV6>();
		visitList = new HashMap<String, String>();
		partyList = new HashMap<String, String>();
		tpList = new HashMap<Player, Integer>();
		coordList = new HashMap<String, SimpleIslandV6>();

		pointList = new HashMap<String, Integer>();

		getCommand("island").setExecutor(new Island(this));
		getCommand("islandev").setExecutor(new IslandDev(this));
		getCommand("challenges").setExecutor(new Challenges(this));

		// Create default config
		File configFile = new File(getDataFolder(), "config.yml");
		if (!configFile.exists())
		{
			configFile.getParentFile().mkdirs();
			copy(getResource("config.yml"), configFile);
		}
		// Create default config
		File msgFile = new File(getDataFolder(), "messages_en.yml");
		if (!msgFile.exists())
		{
			msgFile.getParentFile().mkdirs();
			copy(getResource("messages_en.yml"), msgFile);
		}

		File pluginDir = new File(getDataFolder(), "");
		if (pluginDir.exists() && !pluginDir.canWrite())
		{
			ShowWarn("Plugin directory is not writable!");
		}
		File isFile = new File(getDataFolder(), "islelistV6.dat");
		if (isFile.exists() && !isFile.canWrite())
		{
			ShowWarn("Island file (islelistV6) is not writable!");
		}
		
		Config cfg = new Config(this);
		cfg.setupDefaults();

		if (Config.MAX_COUNT == 0)
		{
			ShowWarn("Max count set to 0, aborting");
			return;
		}

		if (getIslandWorld() == null)
		{
			ShowWarn("Cannot determine correct world, check your config");
			return;
		}

		if (getSpawnWorld() == null)
		{
			ShowWarn("Cannot determine correct spawn world, check your config");
			return;
		}

		try
		{
			saveOurResource("schematics/normal.schematic");
		}
		catch (Exception e)
		{
			ShowWarn("Error saving resource: " + e.getMessage());
			return;
		}

		if (getSchematicFromFile(DESIGN_NORMAL, false) == null)
		{
			ShowWarn("There is problem with schematic");
			return;
		}

		// Load locales
		loadMessages();
		saveMessages();
		saveOurConfig(configFile);

		if (!loadDatFiles())
			return;

		if (Config.BACKUP_ON_START)
		{
			final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
			final String dateAsString = simpleDateFormat.format(System.currentTimeMillis());

			final File from = new File(getDataFolder(), "islelistV6.dat");
			final File to = new File(getDataFolder(), "backup/islelistV6_" + dateAsString + ".dat");

			final int removed = cleanupBackupFiles(to.getParentFile());

			if (removed > 0)
				debug("Removed " + removed + " old backup files.");

			debug("Making backup.");

			if (from != null && from.exists() && to != null)
			{
				to.getParentFile().mkdirs();
				try
				{
					copyFileUsingStream(from, to);
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
			}
		}
		loadXMLFiles();

		// getMessages().options().copyHeader(true);
		// getMessages().options().copyDefaults(true);

		if (generateCacheLists())
		{
			// If cache generate will find duplicates
			// we need to remove freelist and generate it again.
			debug("Removing freeList");

			File f = new File(getDataFolder(), "freelistV6.dat");
			if (f.exists())
				f.delete();

			freeList.clear();
		}

		final int currCount = freeList.size() + isleList.size();
		final int maxCount = Config.MAX_COUNT * Config.MAX_COUNT;

		if (currCount < maxCount)
		{
			getLogger().info("Our list count (" + currCount + ") is smaller than max config (" + maxCount + "), scheduling re-generate");

			REGEN_IN_PROGRESS = true;

			Bukkit.getScheduler().scheduleSyncDelayedTask(this, new Regenerate(), 5 * 20);

			// Bukkit.getScheduler().runTaskLaterAsynchronously(this, new Regenerate(), 5*20);
		}
		if (currCount > maxCount)
		{
			getLogger().info("########## IslandWorld info ##########");
			getLogger().info("Warning.");
			getLogger().info("Island count (" + currCount + ") higher than max count (" + maxCount + ")!");
			getLogger().info("######################################");
		}

		if (!Config.CHAT_PREFIX.equalsIgnoreCase("none"))
			getServer().getPluginManager().registerEvents(new ChatListener(this), this);
		if (Config.ITEM_PROTECTION)
			getServer().getPluginManager().registerEvents(new ItemProtectionListeners(this), this);
		if (getConfig().getBoolean("flags.move-info", false))
			getServer().getPluginManager().registerEvents(new PlayerMoveListener(this), this);
		if (getConfig().getBoolean("island-protection", false))
			getServer().getPluginManager().registerEvents(new MoveProtectionListener(this), this);

		if (!getConfig().getBoolean("old-version", false))
			getServer().getPluginManager().registerEvents(new NewListeners(this), this);

		getServer().getPluginManager().registerEvents(new IslandWorldListener(this), this);
		getServer().getPluginManager().registerEvents(new IslandProtectionListeners(this), this);

		// Schedule autosave
		final int autoSave = getConfig().getInt("auto-save", 60);
		if (autoSave > 0)
			Bukkit.getScheduler().scheduleSyncRepeatingTask(this, new AutoSave(), autoSave * 1200, autoSave * 1200);

		final Biome[] bm = Biome.values();
		for (Biome b : bm)
		{
			if (b.toString().equalsIgnoreCase(getConfig().getString("default-biome")))
				DEFAULT_BIOME = b;
		}
		debug("Default Biome: " + DEFAULT_BIOME);
		
		// Initialize mysql
		final Connection mysqlC = getMysqlCon();
		if (mysqlC != null)
		{
			debug("Mysql connection initialized");
			try
			{
				String QUERY_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS `island_stats` (`owner` varchar(50) NOT NULL,`points` int(10) NOT NULL DEFAULT '0',UNIQUE KEY `owner` (`owner`),KEY `points` (`points`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

				DatabaseMetaData dm = mysqlC.getMetaData();
				ResultSet tables = dm.getTables(null, null, "island_stats", null);
				if (!tables.next())
				{
					Statement s = mysqlC.createStatement();
					s.executeUpdate(QUERY_CREATE_TABLE);
					debug("Table stats created");
				}
			}
			catch (Exception e)
			{
			}
		}
		else
			debug("Cannot initialize mysql connection");

		readPoints();

		// Version check if enabled in config
		if (getConfig().getBoolean("version-check", true))
		{
			getLogger().info("Checking for updates");

			Updater updater = new Updater(this, 43553, getFile(), Updater.UpdateType.NO_DOWNLOAD, false);
			Updater.UpdateResult result = updater.getResult();

			if (result == Updater.UpdateResult.UPDATE_AVAILABLE)
			{
				getLogger().info("########## IslandWorld update ##########");
				getLogger().info("A new version of IslandWorld was found!");
				getLogger().info("Version found: " + updater.getLatestName());
				getLogger().info("Version running: " + getDescription().getFullName());
				getLogger().info("#####################################");
			}
			else
				getLogger().info("No updates found");
		}

		getLogger().info("Loaded " + freeList.size() + " free islands.");
		getLogger().info("Loaded " + isleList.size() + " taken islands.");
		getLogger().info("Loaded " + challengeList.size() + " challenges.");
		getLogger().info("Loaded " + pChaList.size() + " players completed challenges.");
		getLogger().info("Loaded " + helpList.size() + " helping players.");
		getLogger().info("Loaded " + pointList.size() + " points.");

		if (Config.AUTO_PURGE > 0)
			this.purgeIslands(null, Config.AUTO_PURGE, 0);

		LOADED = true;

		getLogger().info("Plugin enabled.");
	}

	public int cleanupBackupFiles(File file)
	{
		int rez = 0;
		if (Config.BACKUP_MAX_DAYS > 0)
		{
			if (file.isDirectory())
			{
				for (File f : file.listFiles())
				{
					long diff = System.currentTimeMillis() - f.lastModified();
					if (diff > (Config.BACKUP_MAX_DAYS * 24 * 60 * 60 * 1000))
					{
						f.delete();
						rez++;
					}
				}
			}
		}
		return rez;
	}

	private static void copyFileUsingStream(File source, File dest) throws IOException
	{
		InputStream is = null;
		OutputStream os = null;
		try
		{
			is = new FileInputStream(source);
			os = new FileOutputStream(dest);
			byte[] buffer = new byte[1024];
			int length;
			while ((length = is.read(buffer)) > 0)
			{
				os.write(buffer, 0, length);
			}
		}
		finally
		{
			is.close();
			os.close();
		}
	}

	private Connection getMysqlCon()
	{
		MySQL mysql = new MySQL(Config.mysql_host, Config.mysql_port, Config.mysql_base, Config.mysql_user, Config.mysql_pass);
		Connection mysqlC = mysql.open();

		return mysqlC;
	}

	@SuppressWarnings("deprecation")
	private void loadXMLFiles()
	{
		Document doc = null;

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setValidating(false);
		factory.setIgnoringComments(true);

		File file = new File(getDataFolder(), "challenges.xml");
		if (!file.exists())
		{
			file.getParentFile().mkdirs();
			copy(getResource("challenges.xml"), file);
		}

		try
		{
			doc = factory.newDocumentBuilder().parse(file);
		}
		catch (Exception e)
		{
			getLogger().warning("Could not load challenges.xml " + e.toString());
		}

		for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling())
		{
			if ("list".equalsIgnoreCase(n.getNodeName()))
			{
				for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling())
				{
					if ("globalreward".equalsIgnoreCase(d.getNodeName()))
					{
						final int itemId = Integer.parseInt(d.getAttributes().getNamedItem("itemId").getNodeValue());
						final int count = Integer.parseInt(d.getAttributes().getNamedItem("count").getNodeValue());
						if (d.getAttributes().getNamedItem("damage") != null)
							globalReward = new ItemStack(itemId, count, (short) Integer.parseInt(d.getAttributes().getNamedItem("damage")
									.getNodeValue()));
						else
							globalReward = new ItemStack(itemId, count);
					}
					else if ("challenge".equalsIgnoreCase(d.getNodeName()))
					{
						int cid = Integer.parseInt(d.getAttributes().getNamedItem("id").getNodeValue());
						String descr = null;
						ItemStack req = null;
						ItemStack rew = null;
						boolean take = false;
						boolean rep = false;

						if (d.getAttributes().getNamedItem("repeatable") != null)
							rep = Boolean.parseBoolean(d.getAttributes().getNamedItem("repeatable").getNodeValue());

						for (Node p = d.getFirstChild(); p != null; p = p.getNextSibling())
						{
							final String nodeName = p.getNodeName();

							if (nodeName.equals("descr"))
							{
								descr = p.getAttributes().getNamedItem("val").getNodeValue();
							}
							else if (nodeName.equals("required"))
							{
								final int itemId = Integer.parseInt(p.getAttributes().getNamedItem("itemId").getNodeValue());
								final int count = Integer.parseInt(p.getAttributes().getNamedItem("count").getNodeValue());
								if (p.getAttributes().getNamedItem("take") != null)
									take = Boolean.parseBoolean(p.getAttributes().getNamedItem("take").getNodeValue());

								if (p.getAttributes().getNamedItem("damage") != null)
									req = new ItemStack(itemId, count, (short) Integer.parseInt(p.getAttributes().getNamedItem("damage").getNodeValue()));
								else
									req = new ItemStack(itemId, count);
							}
							else if (nodeName.equals("reward"))
							{
								final int itemId = Integer.parseInt(p.getAttributes().getNamedItem("itemId").getNodeValue());
								final int count = Integer.parseInt(p.getAttributes().getNamedItem("count").getNodeValue());
								if (p.getAttributes().getNamedItem("damage") != null)
									rew = new ItemStack(itemId, count, (short) Integer.parseInt(p.getAttributes().getNamedItem("damage").getNodeValue()));
								else
									rew = new ItemStack(itemId, count);
							}
						}

						if (cid > 0 && !descr.isEmpty() && req != null)
						{
							if (getChallenge(cid) != null)
								getLogger().warning("Duplicate challenge ID : " + cid);
							else
								challengeList.add(new Challenge(cid, descr, req, take, rew, rep));
						}
					}
				}
			}
		}
	}

	@SuppressWarnings("unchecked")
	private boolean loadDatFiles()
	{
		boolean needSave = false;
		boolean isImport = false;

		try
		{
			File v5listFile = new File(getDataFolder(), "islelistV5.dat");
			if (v5listFile.exists())
			{
				HashMap<String, SimpleIslandV5> v5isleList = new HashMap<String, SimpleIslandV5>();
				try
				{
					v5isleList = (HashMap<String, SimpleIslandV5>) SLAPI.load(getDataFolder() + "/islelistV5.dat");
				}
				catch (Exception e)
				{
					getLogger().warning("Error: " + e.getMessage());
				}
				if (v5isleList != null)
				{
					int c = 0;
					for (Entry<String, SimpleIslandV5> old : v5isleList.entrySet())
					{
						final String ownerName = old.getKey();
						final SimpleIslandV5 iso = old.getValue();
						SimpleIslandV6 island = new SimpleIslandV6(iso);

						isleList.put(ownerName, island);
						c++;
					}
					getLogger().info("Imported " + c + " free islands from old v5 file");
				}
				v5listFile.delete();

				isImport = true;
			}
			// Try load taken
			File v4listFile = new File(getDataFolder(), "islelistV4.dat");
			if (v4listFile.exists())
			{
				HashMap<String, SimpleIslandV4> v4isleList = new HashMap<String, SimpleIslandV4>();
				try
				{
					v4isleList = (HashMap<String, SimpleIslandV4>) SLAPI.load(getDataFolder() + "/islelistV4.dat");
				}
				catch (Exception e)
				{
					getLogger().warning("Error: " + e.getMessage());
				}
				if (v4isleList != null)
				{
					int c = 0;
					for (Entry<String, SimpleIslandV4> old : v4isleList.entrySet())
					{
						final String ownerName = old.getKey();
						final SimpleIslandV4 iso = old.getValue();
						SimpleIslandV6 island = new SimpleIslandV6(iso);
						island.setOwner(ownerName);

						isleList.put(ownerName, island);
						c++;
					}
					getLogger().info("Imported " + c + " free islands from old v4 file");
				}
				v4listFile.delete();

				isImport = true;
			}

			if (isleList.isEmpty() && new File(getDataFolder(), "islelistV6.dat").exists())
			{
				try
				{
					isleList = (HashMap<String, SimpleIslandV6>) SLAPI.load(getDataFolder() + "/islelistV6.dat");
				}
				catch (Exception e)
				{
					getLogger().warning("Error: " + e.getMessage());
				}
			}
			File v3file = new File(getDataFolder(), "freelistV3.dat");
			File v4file = new File(getDataFolder(), "freelistV4.dat");
			File v5file = new File(getDataFolder(), "freelistV5.dat");
			if (isImport)
			{
				if (v3file.exists())
					v3file.delete();
				if (v4file.exists())
					v4file.delete();
				if (v5file.exists())
					v5file.delete();
			}
			else
			{
				// Load v3 if v2 is empty
				if (freeList.isEmpty() && new File(getDataFolder(), "freelistV6.dat").exists())
				{
					try
					{
						freeList = (ArrayList<SimpleIslandV6>) SLAPI.load(getDataFolder() + "/freelistV6.dat");
					}
					catch (Exception e)
					{
						getLogger().warning("Error: " + e.getMessage());
					}
				}
			}

			if (new File(getDataFolder(), "compChallenges.dat").exists())
			{
				try
				{
					pChaList = (HashMap<String, List<Integer>>) SLAPI.load(getDataFolder() + "/compChallenges.dat");
				}
				catch (Exception e)
				{
					getLogger().warning("Error: " + e.getMessage());
				}
			}

			if (needSave)
			{
				saveDatFiles();
			}
		}
		catch (Exception e)
		{
			getLogger().warning("Error : " + e.getMessage());
		}

		return true;
	}

	@Override
	public void onDisable()
	{
		if (LOADED)
			saveDatFiles();

		getLogger().info("Plugin disabled.");
	}

	public World getIslandWorld()
	{
		if (world == null)
			world = getServer().getWorld(Config.WORLD_ISLE);

		return world;
	}

	public World getSpawnWorld()
	{
		if (spawnWorld == null)
			spawnWorld = getServer().getWorld(Config.WORLD_SPAWN);

		return spawnWorld;
	}

	public ItemStack getGlobalReward()
	{
		return globalReward;
	}

	public SimpleIslandV6 getIsland(int x, int z)
	{
		for (SimpleIslandV6 is : freeList)
		{
			if (is.getX() == x && is.getZ() == z)
				return is;
		}

		return null;
	}

	private void copy(InputStream in, File file)
	{
		if (in == null)
			getLogger().warning("Cannot copy, resource null");

		try
		{
			OutputStream out = new FileOutputStream(file);
			byte[] buf = new byte[1024];
			int len;
			while ((len = in.read(buf)) > 0)
			{
				out.write(buf, 0, len);
			}
			out.close();
			in.close();
		}
		catch (Exception e)
		{
			getLogger().warning("Error copying resource: " + e);
			e.printStackTrace();
		}
	}

	public Challenge getChallenge(int id)
	{
		for (Challenge cha : getChallenges())
		{
			if (cha != null && cha.getId() == id)
				return cha;
		}
		return null;
	}

	public List<Challenge> getChallenges()
	{
		return challengeList;
	}

	public List<SimpleIslandV6> getFreeList()
	{
		return freeList;
	}

	public HashMap<String, SimpleIslandV6> getIsleList()
	{
		return isleList;
	}

	public HashMap<String, SimpleIslandV6> getCoordList()
	{
		return coordList;
	}

	public boolean haveIsland(Player player)
	{
		return haveIsland(player.getName().toLowerCase());
	}
	
	public boolean haveIsland(String playerName)
	{
		if (playerName == null)
			return false;
		if (getIsleList().containsKey(playerName))
			return true;

		return false;
	}
	
	public SimpleIslandV6 getPlayerIsland(Player player)
	{
		return getPlayerIsland(player.getName());
	}

	public SimpleIslandV6 getPlayerIsland(String playername)
	{
		return getIsleList().get(playername.toLowerCase());
	}

	public HashMap<String, List<Integer>> getCompletedChallenges()
	{
		return pChaList;
	}

	public void deleteChallenges(Player player)
	{
		if (pChaList.containsKey(player.getName().toLowerCase()))
			pChaList.remove(player.getName().toLowerCase());
	}

	public boolean playerCompletedChallenge(String plName, int id)
	{
		if (pChaList.containsKey(plName.toLowerCase()))
			return pChaList.get(plName.toLowerCase()).contains(id);

		return false;
	}

	private boolean containsAtLeast(Player player, ItemStack item, int amount)
	{
		if (item == null)
		{
			return false;
		}
		if (amount <= 0)
		{
			return true;
		}
		for (ItemStack i : player.getInventory().getContents())
		{
			if (item.isSimilar(i) && (amount -= i.getAmount()) <= 0)
			{
				return true;
			}
		}
		return false;
	}

	@SuppressWarnings("deprecation")
	public boolean completeChallenge(Player player, int id)
	{
		if (id > 0)
		{
			final int prev = id - 1;
			final boolean order = getConfig().getBoolean("challenges-order", false);
			final String chaAndId = ChatColor.YELLOW + getLoc("info-cha-header").replaceAll("%id%", String.valueOf(id));

			if (playerCompletedChallenge(player.getName(), id))
				return showError(player, chaAndId + ChatColor.GREEN + getLoc("info-cha-already"));

			if (order && prev > 0 && !playerCompletedChallenge(player.getName(), prev))
				return showError(player, getLoc("error-cha-order").replaceAll("%id%", String.valueOf(id)));

			Challenge cha = getChallenge(id);
			if (cha != null)
			{
				final ItemStack req = cha.getRequiredItem();
				final ItemStack rew = cha.getRewardItem();
				final ItemStack gRew = getGlobalReward();

				final boolean take = cha.takeRequiredItem();

				if (req != null)
				{
					if (containsAtLeast(player, req, req.getAmount()))
					{
						if (take)
						{
							player.getInventory().removeItem(req);
						}

						player.sendMessage(chaAndId + ChatColor.AQUA + getLoc("info-cha-completed"));

						if (!cha.isRepeatable())
						{
							if (pChaList.containsKey(player.getName().toLowerCase()))
							{
								pChaList.get(player.getName().toLowerCase()).add(id);
							}
							else
							{
								List<Integer> list = new ArrayList<Integer>();
								list.add(id);

								pChaList.put(player.getName().toLowerCase(), list);
							}
						}

						if (gRew != null)
						{
							player.getInventory().addItem(gRew);
							player.sendMessage(ChatColor.AQUA + getLoc("info-cha-reward-added"));
						}
						if (rew != null)
						{
							player.getInventory().addItem(rew);
							player.sendMessage(ChatColor.AQUA + getLoc("info-cha-reward-added"));
						}

						player.updateInventory();
					}
					else
						return showError(player, chaAndId + ChatColor.RED + getLoc("info-cha-item-missing"));
				}
				else
					return showError(player, chaAndId + ChatColor.RED + getLoc("info-cha-no-req-item"));
			}
			else
				return showError(player, chaAndId + ChatColor.RED + getLoc("error-cha"));
		}
		else
			return showError(player, getLoc("error-cha-id"));

		return true;
	}

	public void saveDatFiles()
	{
		debug("Saving dat files...");

		try
		{
			SLAPI.save(isleList, getDataFolder() + "/islelistV6.dat");

			SLAPI.save(freeList, getDataFolder() + "/freelistV6.dat");
			SLAPI.save(pChaList, getDataFolder() + "/compChallenges.dat");
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	public boolean showError(CommandSender sender, String text)
	{
		if (sender != null)
		{
			if (sender instanceof Player)
				sender.sendMessage(ChatColor.RED + text);
			else
				sender.sendMessage(text);
		}

		return false;
	}

	public boolean showMessage(CommandSender sender, String text)
	{
		sender.sendMessage(text);

		return false;
	}

	public SchematicFormat getSchematicFromFile(String fName, boolean quiet)
	{
		debug("Loading schematic file: " + fName);

		SchematicFormat schem = null;

		File schemaFile = new File(getDataFolder() + "/schematics/" + fName + ".schematic");

		if (schemaFile.exists())
		{
			schem = SchematicFormat.getFormat(schemaFile);
		}
		else
		{
			if (!quiet)
				getLogger().warning("Cannot load schematic: " + getDataFolder() + "/schematics/" + fName + ".schematic");
		}

		return schem;
	}

	public void scheduleRebuild(SimpleIslandV6 isle, Player player, String schema)
	{
		Bukkit.getScheduler().scheduleSyncDelayedTask(this, new Rebuild(this, isle, player, schema));
	}

	public class AutoSave implements Runnable
	{
		@Override
		public void run()
		{
			if (LOADED && !REGEN_IN_PROGRESS)
			{
				saveDatFiles();

				getLogger().info("Files auto-saved.");
			}
		}
	}

	public class Rebuild implements Runnable
	{
		private SimpleIslandV6 _isle;
		private Player _player;
		private String _schem;
		private IslandWorld _plug;

		public Rebuild(IslandWorld plug, SimpleIslandV6 isle, Player player, String schem)
		{
			_isle = isle;
			_player = player;
			_schem = schem;
			_plug = plug;
		}

		@Override
		public void run()
		{
			// Clear all buildings
			deleteIsle(_isle);

			setDefaultBiome(_isle);

			if (_schem != null)
			{

				try
				{
					SchematicManager.pasteSchematic(_plug, _player, _isle, _schem);
				}
				catch (InvalidFormatException e)
				{
					e.printStackTrace();
				}
			}
		}
	}

	private String hashMe(int x, int z)
	{
		return String.valueOf(x) + "-" + String.valueOf(z);
	}

	public class Regenerate implements Runnable
	{
		@Override
		public void run()
		{
			getLogger().info("Regenerate start");

			// Make temporary list
			final List<String> tmpTakenList = new ArrayList<String>();
			final List<String> tmpFreeList = new ArrayList<String>();

			for (Entry<String, SimpleIslandV6> en : getIsleList().entrySet())
			{
				final SimpleIslandV6 island = en.getValue();
				tmpTakenList.add(hashMe(island.getX(), island.getZ()));
			}

			/*
			 * for (SimpleIslandV6 is : freeList)
			 * {
			 * tmpFreeList.add(hashMe(is.getX(), is.getZ()));
			 * }
			 */

			if (getConfig().getBoolean("snail-mode", false))
			{
				for (int c_operate = 0; c_operate < Config.MAX_COUNT; c_operate++)
				{
					// debug("Generating row : " + c_operate);

					for (int x_operate = 0; x_operate <= c_operate; x_operate++)
					{
						final String hash = hashMe(x_operate, c_operate);

						if (!tmpFreeList.contains(hash) && !tmpTakenList.contains(hash))
						{
							SimpleIslandV6 temp = new SimpleIslandV6(x_operate, c_operate);
							freeList.add(temp);
							tmpFreeList.add(hash);
						}
					}
					for (int z_operate = 0; z_operate <= c_operate; z_operate++)
					{
						final String hash = hashMe(c_operate, z_operate);

						if (!tmpFreeList.contains(hash) && !tmpTakenList.contains(hash))
						{
							SimpleIslandV6 temp = new SimpleIslandV6(c_operate, z_operate);
							freeList.add(temp);
							tmpFreeList.add(hash);
						}
					}
				}
			}
			else
			{
				for (int x_operate = 0; x_operate < Config.MAX_COUNT; x_operate++)
				{
					for (int z_operate = 0; z_operate < Config.MAX_COUNT; z_operate++)
					{
						final String hash = hashMe(x_operate, z_operate);

						if (!tmpFreeList.contains(hash) && !tmpTakenList.contains(hash))
						{
							SimpleIslandV6 temp = new SimpleIslandV6(x_operate, z_operate);
							freeList.add(temp);
							tmpFreeList.add(hash);
						}
					}
				}
			}
			// Clear temp list
			tmpTakenList.clear();
			tmpFreeList.clear();

			getLogger().info("FreeList regenerated, new count: " + freeList.size());
			REGEN_IN_PROGRESS = false;
			saveDatFiles();
		}
	}

	private void clearEntites(SimpleIslandV6 island)
	{
		int x = (island.getX() * Config.ISLE_SIZE); // +1;
		int z = (island.getZ() * Config.ISLE_SIZE); // +1;
		int y = 0;

		int xx = x + Config.ISLE_SIZE; // -2;
		int yy = 256;
		int zz = z + Config.ISLE_SIZE; // -2;

		int count = 0;
		for (Entity i : world.getEntities())
		{
			if (i != null) // && i.getType() == EntityType.DROPPED_ITEM)
			{
				final Location il = i.getLocation();
				if (il.getX() >= x && il.getX() <= xx && il.getY() >= y && il.getY() <= yy && il.getZ() >= z && il.getZ() <= zz)
				{
					i.remove();
					count++;
				}
			}
		}
		debug("Removed " + count + " items from ground");
	}

	public boolean findIslandSpawn(SimpleIslandV6 island)
	{
		int xx = island.getX() * Config.ISLE_SIZE;
		int zz = island.getZ() * Config.ISLE_SIZE;

		for (int y_operate = 255; y_operate > 0; y_operate--)
		{
			for (int x_operate = xx; x_operate < (xx + Config.ISLE_SIZE); x_operate++)
			{
				for (int z_operate = zz; z_operate < (zz + Config.ISLE_SIZE); z_operate++)
				{
					Block b1 = world.getBlockAt(x_operate, y_operate, z_operate);
					Block b2 = world.getBlockAt(x_operate, y_operate + 1, z_operate);

					Material b1t = b1.getType();

					if (b1t != Material.AIR && b1t != Material.LAVA && b1t != Material.CACTUS && b2.getType() == Material.AIR)
					{
						island.setLocation(b2.getLocation());
						debug("Spawn changed to : " + b2.getLocation().toString());
						return true;
					}
				}
			}
		}

		Location nloc = new Location(world, island.getX() * Config.ISLE_SIZE, Config.ISLE_HEIGHT, island.getZ() * Config.ISLE_SIZE);
		island.setLocation(nloc);

		getLogger().warning("Cannot find spawnpoint for island " + island.getX() + "/" + island.getZ());
		getLogger().warning("Spawnpoint set to : " + nloc.toString());
		return false;
	}

	private void deleteIsle(SimpleIslandV6 playerIsland)
	{
		debug("Starting island delete");

		int x = playerIsland.getX() * Config.ISLE_SIZE;
		int z = playerIsland.getZ() * Config.ISLE_SIZE;

		for (int y_operate = 256; y_operate > 0; y_operate--)
		{
			for (int x_operate = x; x_operate < (x + Config.ISLE_SIZE); x_operate++)
			{
				for (int z_operate = z; z_operate < (z + Config.ISLE_SIZE); z_operate++)
				{
					Block block = world.getBlockAt(x_operate, y_operate, z_operate);

					if (isOnIgnoreList(block))
						continue;
					if (block != null && !block.isEmpty())
					{
						block.getDrops().clear();

						// Clear blocks with inventory
						BlockState state = block.getState();
						if (state instanceof InventoryHolder)
						{
							InventoryHolder ih = (InventoryHolder) state;
							ih.getInventory().clear();
						}
						deleteBlock(block);
					}
				}
			}
		}

		// Clear entites before delete
		clearEntites(playerIsland);

		debug("Island [" + playerIsland.getX() + "][" + playerIsland.getZ() + "] deleted");
	}

	private void setDefaultBiome(SimpleIslandV6 isle)
	{
		if (DEFAULT_BIOME != null)
		{
			int x = isle.getX() * Config.ISLE_SIZE;
			int z = isle.getZ() * Config.ISLE_SIZE;
	
			for (int x_operate = x; x_operate < (x + Config.ISLE_SIZE); x_operate++)
			{
				for (int z_operate = z; z_operate < (z + Config.ISLE_SIZE); z_operate++)
				{
					getIslandWorld().setBiome(x_operate, z_operate, DEFAULT_BIOME);
				}
			}
		}
	}

	@SuppressWarnings("deprecation")
	private void deleteBlock(Block block)
	{
		if (block.getY() <= Config.ISLE_HEIGHT)
		{
			if (block.getTypeId() != Config.WORLD_BLOCK)
				block.setTypeId(Config.WORLD_BLOCK);
		}
		else
		{
			if (block.getType() != Material.AIR)
				block.setType(Material.AIR);
		}
	}

	public void showChallengeList(CommandSender requestor, String plName, int from)
	{
		List<Challenge> lista = new ArrayList<Challenge>();

		if (getConfig().getBoolean("skip-completed", false))
		{
			for (Challenge cha : getChallenges())
			{
				if (!playerCompletedChallenge(plName, cha.getId()))
					lista.add(cha);
			}
		}
		else
			lista.addAll(getChallenges());

		final int max = lista.size() / 5;
		final int start = from * 5;
		final int stop = start + 5;

		final ItemStack gRew = getGlobalReward();

		if (from > max)
			from = max;

		String header = getLoc("info-cha-list-header");
		header = header.replaceAll("%from%", String.valueOf(from));
		header = header.replaceAll("%max%", String.valueOf(max));

		requestor.sendMessage(ChatColor.AQUA + header);
		if (gRew != null)
		{
			String reward = getLoc("info-cha-reward-global");
			reward = reward.replaceAll("%count%", ChatColor.DARK_GREEN + String.valueOf(gRew.getAmount()) + ChatColor.GREEN);
			reward = reward.replaceAll("%item%", ChatColor.DARK_GREEN + WordUtils.capitalizeFully(gRew.getType().toString().replaceAll("_", " ")) + ChatColor.GREEN);
			requestor.sendMessage(ChatColor.GREEN + reward);
		}

		int count = 0;
		for (Challenge chall : lista)
		{
			if (chall != null && count >= start)
			{
				final ChatColor cha = playerCompletedChallenge(plName, chall.getId()) ? ChatColor.GREEN : ChatColor.RED;
				final String rep = (chall.isRepeatable() ? " " + ChatColor.GREEN + "[R] " : "");
				
				requestor.sendMessage(cha + "" + chall.getId() + ". " + rep + ChatColor.YELLOW + chall.getDescr());
				final ItemStack rew = chall.getRewardItem();
				if (rew != null)
				{
					String reward = getLoc("info-cha-reward");
					reward = reward.replaceAll("%count%", ChatColor.DARK_GREEN + String.valueOf(rew.getAmount()) + ChatColor.GREEN);
					reward = reward.replaceAll("%item%", ChatColor.DARK_GREEN + WordUtils.capitalizeFully(rew.getType().toString().replaceAll("_", " ")) + ChatColor.GREEN);
					requestor.sendMessage(ChatColor.GREEN + reward);
				}
			}
			count++;
			if (count >= stop)
				break;
		}

	}

	public boolean generateCacheLists()
	{
		boolean removeFreeList = false;

		Map<String, SimpleIslandV6> isList = new HashMap<String, SimpleIslandV6>();
		isList.putAll(getIsleList());

		for (Entry<String, SimpleIslandV6> e : isList.entrySet())
		{
			final String owner = e.getKey();
			final SimpleIslandV6 island = e.getValue();

			if (island != null)
			{
				// Get coord hash
				final String coordHash = String.valueOf(island.getX() + "-" + island.getZ());
				// Put island
				if (coordList.containsKey(coordHash))
				{
					debug("Duplicate island : " + coordHash);

					getIsleList().remove(owner);

					removeFreeList = true;
				}
				else
					coordList.put(coordHash, island);

				final List<String> members = new ArrayList<String>();
				members.addAll(island.getMembers());

				if (members != null && !members.isEmpty())
				{
					for (String member : members)
					{
						if (helpList.containsKey(member.toLowerCase()) && Config.STRICT_PARTY)
						{
							debug("Duplicate help player : " + member);
							island.removeMember(member);
						}
						else
							helpList.put(member.toLowerCase(), island);
					}
				}
			}
		}
		return removeFreeList;
	}

	public SimpleIslandV6 getHelpingIsland(Player player)
	{
		return getHelpingIsland(player.getName());
	}

	public SimpleIslandV6 getHelpingIsland(String plName)
	{
		final String lName = plName.toLowerCase();

		if (helpList.containsKey(lName))
			return helpList.get(lName);

		return null;
	}

	public int expellPlayers(Player player, SimpleIslandV6 island)
	{
		int count = 0;
		// Online
		Player[] players = Bukkit.getOnlinePlayers();
		// Check
		for (Player pl : players)
		{
			final List<String> members = island.getMembers();

			if (pl == null)
				continue;
			if (pl == player)
				continue;
			if (pl.isOp())
				continue;
			if (pl.getWorld() != getIslandWorld())
				continue;
			if (members != null && members.contains(pl.getName().toLowerCase()))
				continue;

			if (isInsideIsland(pl, island))
			{
				if (player != null)
					pl.sendMessage(ChatColor.AQUA + getLoc("info-expelled").replaceAll("%name%", player.getName()));

				pl.teleport(getSpawnWorld().getSpawnLocation());
				count++;
			}
		}
		return count;
	}

	public boolean isDigit(String text)
	{
		if (text == null || text.isEmpty())
			return false;

		boolean result = true;
		char[] chars = text.toCharArray();
		for (int i = 0; i < chars.length; i++)
		{
			if (!Character.isDigit(chars[i]))
			{
				result = false;
				break;
			}
		}
		return result;
	}

	public void debug(String text)
	{
		if (Config.DEBUG)
			getLogger().info(text);
	}

	private FileConfiguration customConfig = null;
	private File customConfigFile = null;

	public FileConfiguration getMessages()
	{
		if (customConfig == null)
			loadMessages();

		return customConfig;
	}

	public void loadMessages()
	{
		if (customConfigFile == null)
			customConfigFile = new File(getDataFolder(), "messages_" + Config.LANGUAGE + ".yml");

		customConfig = YamlConfiguration.loadConfiguration(customConfigFile);

		InputStream defConfigStream = getResource("messages_en.yml");
		if (defConfigStream != null)
		{
			YamlConfiguration defConfig = YamlConfiguration.loadConfiguration(defConfigStream);
			customConfig.setDefaults(defConfig);
		}
	}

	public void saveMessages()
	{
		if (customConfig == null || customConfigFile == null)
			return;

		try
		{
			getMessages().options().copyHeader(true);
			getMessages().options().copyDefaults(true);
			getMessages().save(customConfigFile);
		}
		catch (IOException ex)
		{
			getLogger().log(Level.SEVERE, "Could not save config to " + customConfigFile, ex);
		}
	}

	public void saveOurConfig(File file)
	{
		getConfig().options().copyHeader(true);
		getConfig().options().copyDefaults(true);
		try
		{
			getConfig().save(file);
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	public String getLoc(String string)
	{
		return getMessages().getString(string, "NOLOC_"+string);
	}

	public void setIsHelping(String name, SimpleIslandV6 island)
	{
		final String plName = name.toLowerCase();

		if (helpList.containsKey(plName))
			helpList.remove(plName);

		helpList.put(plName, island);
	}

	public void removeHelping(String name)
	{
		final String plName = name.toLowerCase();

		if (helpList.containsKey(plName))
			helpList.remove(plName);
	}

	public boolean isHelping(Player player)
	{
		return isHelping(player.getName());
	}

	public boolean isHelping(String name)
	{
		return helpList.containsKey(name.toLowerCase());
	}

	public void clearHelping(SimpleIslandV6 island)
	{
		final List<String> members = island.getMembers();
		if (members != null && !members.isEmpty())
		{
			for (String member : members)
			{
				if (member != null)
					removeHelping(member);
			}
		}
	}

	public void makePartyRequest(Player owner, Player visitor)
	{
		partyList.put(owner.getName().toLowerCase(), visitor.getName().toLowerCase());

		Bukkit.getScheduler().scheduleSyncDelayedTask(this, new RemovePartyRequest(owner, visitor), 20 * getConfig().getInt("request-time"));
	}

	public HashMap<String, String> getPartyList()
	{
		return partyList;
	}

	public class RemovePartyRequest implements Runnable
	{
		private Player owner;
		private Player visitor;

		public RemovePartyRequest(Player o, Player v)
		{
			owner = o;
			visitor = v;
		}

		@Override
		public void run()
		{
			final HashMap<String, String> tmpMap = new HashMap<String, String>();
			tmpMap.putAll(getPartyList());

			for (Entry<String, String> x : tmpMap.entrySet())
			{
				final String ow = x.getKey();
				final String vi = x.getValue();

				if (ow != null && vi != null && (ow.equalsIgnoreCase(owner.getName()) || vi.equalsIgnoreCase(visitor.getName())))
				{
					owner.sendMessage(ChatColor.RED + getLoc("error-party-visitor-no-reply").replaceAll("%name%", visitor.getName()));
					visitor.sendMessage(ChatColor.RED + getLoc("error-party-owner-no-reply").replaceAll("%name%", owner.getName()));

					getPartyList().remove(ow);
				}
			}
		}
	}
	
	public void makeVisitRequest(Player owner, Player visitor)
	{
		visitList.put(owner.getName().toLowerCase(), visitor.getName().toLowerCase());

		Bukkit.getScheduler().scheduleSyncDelayedTask(this, new RemoveVisitRequest(owner, visitor), 20 * getConfig().getInt("request-time"));
	}

	public HashMap<String, String> getVisitList()
	{
		return visitList;
	}

	public class RemoveVisitRequest implements Runnable
	{
		private Player owner;
		private Player visitor;

		public RemoveVisitRequest(Player o, Player v)
		{
			owner = o;
			visitor = v;
		}

		@Override
		public void run()
		{
			// owner.sendMessage(ChatColor.RED + getLoc("error-visit-owner-no-reply").replaceAll("%name%", visitor.getName()));
			// visitor.sendMessage(ChatColor.RED + getLoc("error-visit-visitor-no-reply").replaceAll("%name%", owner.getName()));
			// getVisitList().remove(owner);

			final HashMap<String, String> tmpMap = new HashMap<String, String>();
			tmpMap.putAll(getVisitList());

			for (Entry<String, String> x : tmpMap.entrySet())
			{
				final String ow = x.getKey();
				final String vi = x.getValue();

				if (ow != null && vi != null && (ow.equalsIgnoreCase(owner.getName()) || vi.equalsIgnoreCase(visitor.getName())))
				{
					owner.sendMessage(ChatColor.RED + getLoc("error-visit-owner-no-reply").replaceAll("%name%", visitor.getName()));
					visitor.sendMessage(ChatColor.RED + getLoc("error-visit-visitor-no-reply").replaceAll("%name%", owner.getName()));

					getVisitList().remove(ow);
				}
			}
		}
	}

	public boolean isOnDeleteList(Player player)
	{
		return deleteList.contains(player);
	}

	public void addToDeleteList(Player player)
	{
		deleteList.add(player);
		player.sendMessage(ChatColor.GREEN + getLoc("info-delete-added"));

		Bukkit.getScheduler().scheduleSyncDelayedTask(this, new RemoveDeleteReq(player), 20 * getConfig().getInt("request-time"));
	}

	public void removeFromDeleteList(Player player)
	{
		if (deleteList.contains(player))
			deleteList.remove(player);
	}

	public class RemoveDeleteReq implements Runnable
	{
		private Player owner;

		public RemoveDeleteReq(Player o)
		{
			owner = o;
		}

		@Override
		public void run()
		{
			if (owner != null && deleteList.contains(owner))
			{
				deleteList.remove(owner);
				owner.sendMessage(ChatColor.RED + getLoc("error-delete-respond"));
			}
		}
	}

	public boolean isFalling(Player player)
	{
		final Location loc = player.getLocation();

		if (player.getWorld().getBlockAt(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()).getType() == Material.AIR
				&& player.getWorld().getBlockAt(loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ()).getType() == Material.AIR
				&& player.getWorld().getBlockAt(loc.getBlockX(), loc.getBlockY() - 2, loc.getBlockZ()).getType() == Material.AIR)
			return true;

		return false;
	}

	public void purgeIslands(CommandSender player, int days, int much)
	{
		Bukkit.getScheduler().scheduleSyncDelayedTask(this, new Purge(this, player, days, much));
	}

	public class Purge implements Runnable
	{
		private Plugin pp;
		private CommandSender op;
		private int days;
		private int much;

		public Purge(Plugin pl, CommandSender p, int d, int m)
		{
			pp = pl;
			op = p;
			days = d;
			much = m;
		}

		@Override
		public void run()
		{
			final HashMap<String, SimpleIslandV6> isList = new HashMap<String, SimpleIslandV6>();
			final HashMap<String, SimpleIslandV6> removeList = new HashMap<String, SimpleIslandV6>();

			isList.putAll(getIsleList());

			makeDebugLog("Purge start");

			int counter = 0;
			for (Entry<String, SimpleIslandV6> e : isList.entrySet())
			{
				final String playerName = e.getKey();
				final SimpleIslandV6 island = e.getValue();

				final long lastLogin = island.getOwnerLoginTime();

				if (lastLogin > 0 && lastLogin < (System.currentTimeMillis() - (days * 86400000L)))
				{
					removeList.put(playerName, island);

					counter++;

					if (much > 0 && counter == much)
						break;
				}
			}
			if (op != null)
			{
				if (counter > 0)
					op.sendMessage(ChatColor.AQUA + "" + counter + " islands scheduled to delete.");
				else
					op.sendMessage(ChatColor.AQUA + "No islands found to purge.");
			}

			// Schedule
			Bukkit.getScheduler().scheduleSyncDelayedTask(pp, new Remove(pp, op, removeList), 20 * getConfig().getInt("purge-delay", 5));
		}
	}

	private void makeDebugLog(String string)
	{
		// Get last login time
		final long lastLogin = System.currentTimeMillis();
		final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		final String dateAsString = simpleDateFormat.format(lastLogin);

		try
		{
			File logFile = new File(getDataFolder(), "work.log");
			FileWriter fw = new FileWriter(logFile.toString(), true);
			if (fw != null)
			{
				fw.write("[" + dateAsString + "] " + string + "\r\n");
				fw.close();
			}
		}
		catch (IOException ioe)
		{
			System.err.println("IOException: " + ioe.getMessage());
		}
	}

	public boolean isCorrectBlock(Block b)
	{
		return (b.getType() != Material.AIR && b.getType() != Material.LAVA && b.getType() != Material.STATIONARY_LAVA
				&& b.getType() != Material.WATER && b.getType() != Material.STATIONARY_WATER);
	}

	public class Remove implements Runnable
	{
		private Plugin pp;
		private CommandSender op;
		private HashMap<String, SimpleIslandV6> li = new HashMap<String, SimpleIslandV6>();

		public Remove(Plugin pl, CommandSender p, HashMap<String, SimpleIslandV6> list)
		{
			pp = pl;
			op = p;
			li = list;
		}

		@Override
		public void run()
		{
			if (li != null && !li.isEmpty())
			{
				String playerName = null;
				SimpleIslandV6 island = null;

				for (Entry<String, SimpleIslandV6> e : li.entrySet())
				{
					playerName = e.getKey();
					island = e.getValue();

					break;
				}

				if (playerName != null && island != null)
				{
					// Remove first
					li.remove(playerName);
					// Delete island
					onDelete(island, playerName);
					// Get last login time
					final long lastLogin = island.getOwnerLoginTime();
					final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
					final String dateAsString = simpleDateFormat.format(lastLogin);
					// Save Debug
					writeLog(island, "Deleted by purge");
					// Save purge log
					makeDebugLog("Island " + island.toString() + " deleted by purge, owner: " + playerName + ", last login: " + dateAsString);

					// All done
					if (op != null)
						op.sendMessage(ChatColor.GRAY + "[" + dateAsString + "] " + ChatColor.WHITE + playerName + ChatColor.GRAY
								+ "'s island deleted");

					// Schedule again
					Bukkit.getScheduler().scheduleSyncDelayedTask(pp, new Remove(pp, op, li), 20 * getConfig().getInt("purge-delay", 5));
				}
				else
				{
					purgeInProgress = false;

					makeDebugLog("Purge ends, owner or island null");

					if (op != null)
						op.sendMessage(ChatColor.GRAY + "Error, owner name or island null, skipping");
				}
			}
			else
			{
				purgeInProgress = false;

				makeDebugLog("Purge ends");

				if (op != null)
					op.sendMessage(ChatColor.GRAY + "Purge list is empty, purge ends");
			}
		}
	}

	public HashMap<Player, Integer> getTeleportList()
	{
		return tpList;
	}

	public boolean isOnTeleportList(Player player)
	{
		return tpList.containsKey(player);
	}

	public void addToTeleportList(Player player, int taskId)
	{
		if (!tpList.containsKey(player))
			tpList.put(player, taskId);
	}

	public void removeFromTeleportList(Player player)
	{
		if (tpList.containsKey(player))
		{
			int taskId = tpList.remove(player);
			if (taskId > 0)
				Bukkit.getScheduler().cancelTask(taskId);
		}
	}

	public boolean isInsideIsland(Player player, SimpleIslandV6 island)
	{
		// Check World
		if (player.getWorld() != getIslandWorld())
			return false;

		if (island != null)
		{
			final int rs = getConfig().getInt("region-spacing", 1);

			final Location loc = player.getLocation();
			final int px = loc.getBlockX();
			final int pz = loc.getBlockZ();

			// Make math
			int x1 = (island.getX() * Config.ISLE_SIZE) + rs;
			int z1 = (island.getZ() * Config.ISLE_SIZE) + rs;

			int x2 = ((island.getX() * Config.ISLE_SIZE) + Config.ISLE_SIZE) - rs;
			int z2 = ((island.getZ() * Config.ISLE_SIZE) + Config.ISLE_SIZE) - rs;

			return (px > x1 && px < x2 && pz > z1 && pz < z2);
		}

		return false;
	}

	public boolean isInsideOwnIsland(Player player)
	{
		if (player.getLocation().getBlockX() < 0 || player.getLocation().getBlockZ() < 0)
			return false;

		return canBuildOnLocation(player, player.getLocation(), false);
	}

	public boolean canBuildOnLocation(Player player, Location loc)
	{
		return canBuildOnLocation(player, loc, true);
	}

	public boolean canBuildOnLocation(Player player, Location loc, boolean checkMemebrs)
	{
		if (player.isOp())
		{
			debug("canBuildOnLocation: true, player is OP");
			return true;
		}
		if (loc.getBlockX() < 0 && loc.getBlockX() > -50)
		{
			debug("canBuildOnLocation: false, player is in -50 row.");
			return false;
		}
		if (loc.getBlockZ() < 0 && loc.getBlockZ() > -50)
		{
			debug("canBuildOnLocation: false, player is in -50 row.");
			return false;
		}
		if (loc.getBlockX() < 0 || loc.getBlockZ() < 0)
		{
			debug("canBuildOnLocation: " + Config.NEGATIVE_BUILD + ", player is in -50 row.");
			return Config.NEGATIVE_BUILD;
		}

		final String plName = player.getName().toLowerCase();
		final String coordHash = String.valueOf(loc.getBlockX() / Config.ISLE_SIZE) + "-" + String.valueOf(loc.getBlockZ() / Config.ISLE_SIZE);

		if (coordList.containsKey(coordHash))
		{
			final SimpleIslandV6 is = coordList.get(coordHash);
			if (is != null && isInsideIsland(player, is))
			{
				if (is.getOwner() != null && is.getOwner().equalsIgnoreCase(plName))
				{
					debug("canBuildOnLocation: true, player is owner");
					return true;
				}
				if (is.getMembers() != null && checkMemebrs && is.getMembers().contains(plName))
				{
					debug("canBuildOnLocation: true, player is member");
					return true;
				}
			}
		}

		debug("canBuildOnLocation: false");
		return false;
	}

	public void showInfo(CommandSender sender, String who, SimpleIslandV6 isle)
	{
		final SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		final List<String> members = isle.getMembers();

		sender.sendMessage(ChatColor.GREEN + "Island Info for: " + ChatColor.AQUA + who);
		sender.sendMessage(ChatColor.GREEN + "Position: " + ChatColor.YELLOW + "[" + isle.getX() + "][" + isle.getZ() + "]");
		sender.sendMessage(ChatColor.GREEN + "Owner: " + ChatColor.YELLOW + isle.getOwner());
		sender.sendMessage(ChatColor.GREEN + "Protected: " + ChatColor.YELLOW + isle.isProtected());
		if (members != null && !members.isEmpty())
			sender.sendMessage(ChatColor.GREEN + "Members: " + ChatColor.YELLOW + StringUtils.join(members.toArray(), ", "));
		if (isle.getSchematic() != null && !isle.getSchematic().isEmpty())
			sender.sendMessage(ChatColor.GREEN + "Schematic: " + ChatColor.YELLOW + isle.getSchematic());
		if (isle.getCreateTime() > 0)
			sender.sendMessage(ChatColor.GREEN + "Created: " + ChatColor.YELLOW + date.format(isle.getCreateTime()));
		if (isle.getOwnerLoginTime() > 0)
			sender.sendMessage(ChatColor.GREEN + "Owner last login: " + ChatColor.YELLOW + date.format(isle.getOwnerLoginTime()));
		sender.sendMessage(ChatColor.GREEN + "Points: " + ChatColor.YELLOW + isle.getPoints());
	}

	public void showStats(CommandSender player)
	{
		player.sendMessage(ChatColor.AQUA + "" + freeList.size() + " free islands.");
		player.sendMessage(ChatColor.AQUA + "" + isleList.size() + " taken islands.");
		player.sendMessage(ChatColor.AQUA + "" + challengeList.size() + " challenges.");
		player.sendMessage(ChatColor.AQUA + "" + pChaList.size() + " players completed challenges.");
		player.sendMessage(ChatColor.AQUA + "" + helpList.size() + " helping players.");
	}

	public void teleportPlayer(World world, Player player, MyLocation loc)
	{
		player.teleport(new Location(world, loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch()));
	}

	public void onCreate(SimpleIslandV6 newIsland, Player player, String schematicName)
	{
		// Get coord hash
		final String coordHash = String.valueOf(newIsland.getX() + "-" + newIsland.getZ());
		// Put island
		coordList.put(coordHash, newIsland);
		// Get correct name
		final String plName = player.getName().toLowerCase();
		// Set schematic
		newIsland.setSchematic(schematicName);
		// Set time
		newIsland.setCreateTime(System.currentTimeMillis());
		// Set owner
		newIsland.setOwner(plName);
		// Remove from free
		getFreeList().remove(newIsland);
		// Add to taken list
		getIsleList().put(plName, newIsland);
		// Schedule
		scheduleRebuild(newIsland, player, schematicName);
	}

	public void onDelete(SimpleIslandV6 isle, String who)
	{
		// Get coord hash
		final String coordHash = String.valueOf(isle.getX() + "-" + isle.getZ());
		// Put island
		coordList.remove(coordHash);
		// Clear from Helping
		clearHelping(isle);
		// Remove from taken
		getIsleList().remove(who.toLowerCase());
		// Add to free list
		getFreeList().add(0, new SimpleIslandV6(isle.getX(), isle.getZ()));
		// Schedule
		scheduleRebuild(isle, null, null);
	}

	@SuppressWarnings("deprecation")
	public int calcIslandPoints(SimpleIslandV6 island)
	{
		int points = 0;

		int x = island.getX() * Config.ISLE_SIZE;
		int z = island.getZ() * Config.ISLE_SIZE;

		for (int y_operate = 256; y_operate > 0; y_operate--)
		{
			for (int x_operate = x; x_operate < (x + Config.ISLE_SIZE); x_operate++)
			{
				for (int z_operate = z; z_operate < (z + Config.ISLE_SIZE); z_operate++)
				{
					Block block = world.getBlockAt(x_operate, y_operate, z_operate);

					if (block != null && isCorrectBlock(block))
					{
						int point = getConfig().getInt("material-points." + block.getTypeId(), 1);

						points = points + point;
					}
				}
			}
		}

		return points;
	}

	public void readPoints()
	{
		if (POINTS_BUSY)
			return;

		POINTS_BUSY = true;

		final Connection mysqlC = getMysqlCon();

		if (mysqlC != null)
		{
			try
			{
				pointList.clear();

				setRankLastUpdate();

				final Statement statement = mysqlC.createStatement();
				final ResultSet res = statement.executeQuery("SELECT * FROM `island_stats` ORDER BY `points` DESC LIMIT 10");

				while (res.next())
					pointList.put(res.getString("owner"), res.getInt("points"));
			}
			catch (SQLException e)
			{
			}
		}
		else
			debug("Error connecting mysql");

		POINTS_BUSY = false;
	}

	public void storePoints(String owner, int points)
	{
		final Connection mysqlC = getMysqlCon();

		if (mysqlC != null)
		{

			try
			{
				if (!mysqlC.isClosed())
				{
					final PreparedStatement st = mysqlC
							.prepareStatement("INSERT INTO `island_stats` (owner, points) VALUES (?,?) ON DUPLICATE KEY UPDATE points=?");
					st.setString(1, owner);
					st.setInt(2, points);
					st.setInt(3, points);
					st.execute();
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		else
			debug("Error connecting mysql");
	}

	public HashMap<String, Integer> getPoints()
	{
		return pointList;
	}

	public void saveOurResource(String resourcePath)
	{
		if (resourcePath == null || resourcePath.equals(""))
		{
			throw new IllegalArgumentException("ResourcePath cannot be null or empty");
		}

		resourcePath = resourcePath.replace('\\', '/');
		InputStream in = getResource(resourcePath);
		if (in == null)
		{
			throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + getFile());
		}

		File outFile = new File(getDataFolder(), resourcePath);
		int lastIndex = resourcePath.lastIndexOf('/');
		File outDir = new File(getDataFolder(), resourcePath.substring(0, lastIndex >= 0 ? lastIndex : 0));

		if (!outDir.exists())
		{
			outDir.mkdirs();
		}

		try
		{
			if (!outFile.exists())
			{
				OutputStream out = new FileOutputStream(outFile);
				byte[] buf = new byte[1024];
				int len;
				while ((len = in.read(buf)) > 0)
				{
					out.write(buf, 0, len);
				}
				out.close();
				in.close();
			}
		}
		catch (IOException ex)
		{
			getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + outFile, ex);
		}
	}

	public void writeLog(SimpleIslandV6 newIsland, String message)
	{
		if (Config.ISDEBUG)
		{
			final SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

			try
			{
				// Create file
				FileWriter fstream = new FileWriter(getDataFolder() + "/islandworld.log", true);
				BufferedWriter out = new BufferedWriter(fstream);
				out.write("[" + dformat.format(new Date()) + "]" + newIsland.toString() + " " + message);
				out.newLine();
				out.close();
			}
			catch (IOException e)
			{

			}
		}
	}

	@SuppressWarnings("deprecation")
	public boolean isOnIgnoreList(Block block)
	{
		if (block == null)
			return false;

		for (String ids : Config.IGNORED_BLOCK_LIST)
		{
			String[] split = ids.split(":");
			if (split.length > 0 && isDigit(split[0]) && Integer.parseInt(split[0]) == block.getType().getId())
				return true;
		}
		return false;
	}

	private void setRankLastUpdate()
	{
		rankLastUpdate = System.currentTimeMillis();
	}

	public long getRankLastUpdate()
	{
		return rankLastUpdate;
	}
	
	public boolean isSafeToTeleport(MyLocation l)
	{
		Block b0 = getIslandWorld().getBlockAt(l.getBlockX(), l.getBlockY()+1, l.getBlockZ());
		Block b1 = getIslandWorld().getBlockAt(l.getBlockX(), l.getBlockY(), l.getBlockZ());
		
		Block b2 = getIslandWorld().getBlockAt(l.getBlockX(), l.getBlockY()-1, l.getBlockZ());
		// Block b3 = getIslandWorld().getBlockAt(l.getBlockX(), l.getBlockY()-2, l.getBlockZ());
		
		if (b0.getType() == Material.AIR && b1.getType() == Material.AIR && b2.getType() != Material.AIR && b2.getType() != Material.LAVA && b2.getType() !=  Material.CACTUS && b2.getType() != Material.WATER)
			return true;
		
		return false;
	}	
}
