package pl.islandworld;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

import pl.islandworld.entity.SimpleIslandV6;

import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import com.sk89q.worldedit.schematic.SchematicFormat;

/**
 * 
 * @author Gnacik
 * 
 */
public class SchematicManager
{
	@SuppressWarnings("deprecation")
	public static void pasteSchematic(World world, File file, Location origin)
	{
		Vector v = new Vector(origin.getBlockX(), origin.getBlockY(), origin.getBlockZ());
		SchematicFormat schematic = SchematicFormat.getFormat(file);
		EditSession es = new EditSession(new BukkitWorld(world), 999999999);
		CuboidClipboard cc;

		try
		{
			cc = schematic.load(file);
			cc.paste(es, v, false);
		}
		catch (IOException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (DataException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (MaxChangedBlocksException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@SuppressWarnings("deprecation")
	public static void pasteSchematic(IslandWorld plugin, Player player, SimpleIslandV6 island, String sName) throws InvalidFormatException
	{
		final World world = plugin.getIslandWorld();
		if (player == null || world == null)
			return;

		// Generate it
		int x = (island.getX() * Config.ISLE_SIZE) + (Config.ISLE_SIZE / 2);
		int y = Config.ISLE_HEIGHT - 1;
		int z = (island.getZ() * Config.ISLE_SIZE) + (Config.ISLE_SIZE / 2);

		plugin.debug("Starting schematic '"+sName+"' paste");

		File schemaFile = new File(plugin.getDataFolder() + "/schematics/" + sName + ".schematic");

		plugin.debug("File: " + schemaFile.toString());

		Location loc = new Location(world, x, y, z);

		plugin.debug("Paste at: " + loc.toString());

		pasteSchematic(world, schemaFile, loc);

		int xx = island.getX() * Config.ISLE_SIZE;
		int zz = island.getZ() * Config.ISLE_SIZE;

		int xend = xx + Config.ISLE_SIZE;
		int zend = zz + Config.ISLE_SIZE;

		boolean spawnBlock = false;

		for (int y_operate = 256; y_operate > 0; y_operate--)
		{
			for (int x_operate = xx; x_operate < (xx + Config.ISLE_SIZE); x_operate++)
			{
				for (int z_operate = zz; z_operate < (zz + Config.ISLE_SIZE); z_operate++)
				{
					Block block = world.getBlockAt(x_operate, y_operate, z_operate);

					if (block != null && block.getTypeId() == 120)
					{
						// Set empty block
						block.setType(Material.AIR);
						// Teleport player
						player.teleport(block.getLocation());
						// Set spawn
						plugin.getPlayerIsland(player).setLocation(block.getLocation());
						// Set bool
						spawnBlock = true;
						// Set his home
						if (Config.SET_HOME)
							player.performCommand("sethome");
					}
					
					if (plugin.getConfig().getBoolean("use-config-items", false))
					{
						if (block != null && block.getType() == Material.CHEST)
						{
							plugin.debug("Chest found!");
							
							final List<String> item_list = plugin.getConfig().getStringList(sName + "-items");
							
							final InventoryHolder dis = (InventoryHolder) block.getState();
							if (dis != null)
							{
								if (item_list != null && !item_list.isEmpty())
								{
									plugin.debug("Inserting items");
									
									dis.getInventory().clear();
									
									for (String line : item_list)
									{
										final String[] dat = line.split(" ");
		
										if (dat.length == 2 || dat.length == 3)
										{
											final Material ww = Material.getMaterial(dat[0]);
											if (ww != null)
											{
												ItemStack it = new ItemStack(ww);
												if (it != null)
												{
													it.setAmount(Integer.valueOf(dat[1]));
													
													if (dat.length == 3)
														it.setDurability(Short.valueOf(dat[2]));
													
													dis.getInventory().addItem(it);
												}
											}
										}
									}
								}
								else
									plugin.debug("Item list empty!");
							}
							else
								plugin.debug("Holder null");
						}
					}
				}
			}
		}

		int pw = plugin.getConfig().getInt("pathway.width");
		if (pw > 0)
		{
			plugin.debug("Pathway enabled with width : " + pw);

			final int py = plugin.getConfig().getInt("pathway.height", 150);
			final String pc = plugin.getConfig().getString("pathway.block");
			int bi = 44;
			byte bd = 0;
			if (pc.contains(":"))
			{
				String[] dat = pc.split(":");
				bi = Integer.valueOf(dat[0]);
				bd = Byte.valueOf(dat[1]);
			}
			else
				bi = Integer.valueOf(pc);

			final File pFile = new File(plugin.getDataFolder() + "/schematics/pathway.schematic");

			if (pFile.exists())
			{
				plugin.debug("Using schematic for pathway");

				pasteSchematic(plugin.getIslandWorld(), pFile, new Location(plugin.getIslandWorld(), xx, py, zz));
			}
			else
			{
				plugin.debug("Making config based pathway");

				for (int xp = xx; xp < xend; xp++)
				{
					for (int wi = zz; wi < zz + pw; wi++)
					{
						Block block = world.getBlockAt(xp, py, wi);
						block.setTypeIdAndData(bi, bd, false);
					}
					for (int wi = (zend - pw); wi < zend; wi++)
					{
						Block block = world.getBlockAt(xp, py, wi);
						block.setTypeIdAndData(bi, bd, false);
					}
				}
				for (int zp = zz; zp < zend; zp++)
				{
					for (int wi = xx; wi < xx + pw; wi++)
					{
						Block block = world.getBlockAt(wi, py, zp);
						block.setTypeIdAndData(bi, bd, false);
					}
					for (int wi = (xend - pw); wi < xend; wi++)
					{
						Block block = world.getBlockAt(wi, py, zp);
						block.setTypeIdAndData(bi, bd, false);
					}
				}
			}
		}
		else
			plugin.debug("Pathway disabled");

		if (!spawnBlock)
		{
			plugin.getLogger().warning("WARNING! Schematic doesnt have spawn point. (BlockId: " + Material.ENDER_PORTAL_FRAME.getId() + ")");

			overloop: for (int y_operate = 0; y_operate < 255; y_operate++)
			{
				for (int x_operate = xx; x_operate < (xx + Config.ISLE_SIZE); x_operate++)
				{
					for (int z_operate = zz; z_operate < (zz + Config.ISLE_SIZE); z_operate++)
					{
						Block b1 = world.getBlockAt(x_operate, y_operate, z_operate);
						Block b2 = world.getBlockAt(x_operate, y_operate + 1, z_operate);
						Block b3 = world.getBlockAt(x_operate, y_operate + 2, z_operate);

						Material b1t = b1.getType();

						if (b1t != Material.AIR && b1t != Material.STATIONARY_LAVA && b1t != Material.LAVA && b1t != Material.CACTUS
								&& b2.getType() == Material.AIR && b3.getType() == Material.AIR)
						{
							island.setLocation(b2.getLocation());
							break overloop;
						}
					}
				}
			}
		}

		plugin.debug("Finished schematic paste");

		return;
	}
}