package pl.islandworld.commands;

import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

import pl.islandworld.Config;
import pl.islandworld.IslandWorld;

public class Challenges implements CommandExecutor
{
	private final IslandWorld plugin;

	public Challenges(IslandWorld plugin)
	{
		this.plugin = plugin;
	}

	@Override
	public boolean onCommand(CommandSender sender, Command command, String label, String[] split)
	{
		if (!(sender instanceof Player))
			return false;
		if (plugin == null)
			return false;
		final Player player = (Player) sender;
		if (IslandWorld.REGEN_IN_PROGRESS)
			return plugin.showError(player, plugin.getLoc("error-regen"));
		if (!IslandWorld.LOADED)
			return plugin.showError(player, plugin.getLoc("error-start"));

		final World world = plugin.getServer().getWorld(Config.WORLD_ISLE);
		if (world == null)
			return plugin.showError(player, plugin.getLoc("error-world"));

		if (split.length == 0)
		{
			showUsage(player);
		}
		else if (split.length == 1)
		{
			if (split[0].equalsIgnoreCase("list"))
			{
				return commandList(world, player, "0");
			}
			else if (split[0].equalsIgnoreCase("complete"))
			{
				return commandComplete(world, player, null);
			}
		}
		else if (split.length == 2)
		{
			if (split[0].equalsIgnoreCase("list"))
			{
				return commandList(world, player, split[1]);
			}
			else if (split[0].equalsIgnoreCase("complete"))
			{
				return commandComplete(world, player, split[1]);
			}
		}
		else
		{
			showUsage(player);
		}

		return true;
	}

	private boolean commandComplete(World world, Player player, String idnum)
	{
		if (player == null)
			return false;
		if (!(player.hasPermission("islandworld.challenges.complete")))
			return plugin.showError(player, plugin.getLoc("error-no-perms"));

		if (idnum == null || idnum.isEmpty())
		{
			player.sendMessage(ChatColor.AQUA + plugin.getLoc("com-usage"));
			player.sendMessage(ChatColor.RED + "/challenges complete <Id>" + ChatColor.AQUA + " - " + plugin.getLoc("com-cha-complete"));
			return false;
		}
		if (player.getWorld() != world)
			return plugin.showError(player, plugin.getLoc("error-current-world"));
		if (!plugin.isDigit(idnum))
			return plugin.showError(player, plugin.getLoc("error-cha-id"));

		plugin.completeChallenge(player, Integer.valueOf(idnum));

		return true;
	}

	private boolean commandList(World world, Player player, String ff)
	{
		if (player == null)
			return false;
		if (!(player.hasPermission("islandworld.challenges.list")))
			return plugin.showError(player, plugin.getLoc("error-no-perms"));

		int from = 0;
		if (plugin.isDigit(ff))
			from = Integer.valueOf(ff);

		plugin.showChallengeList(player, player.getName().toLowerCase(), from);

		return true;
	}

	private void showUsage(Player player)
	{
		// Player use only /island without params
		player.sendMessage(ChatColor.YELLOW + "Island World v" + plugin.getDescription().getVersion());
		player.sendMessage(ChatColor.AQUA + plugin.getLoc("com-usage"));
		player.sendMessage(ChatColor.RED + "/challenges list" + ChatColor.AQUA + " - " + plugin.getLoc("com-cha-list"));
		player.sendMessage(ChatColor.RED + "/challenges complete <id>" + ChatColor.AQUA + " - " + plugin.getLoc("com-cha-complete"));
	}
}