package pl.islandworld.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

import pl.islandworld.Config;
import pl.islandworld.IslandWorld;
import pl.islandworld.entity.Challenge;
import pl.islandworld.entity.MyLocation;
import pl.islandworld.entity.SimpleIslandV6;

import com.sk89q.worldedit.schematic.SchematicFormat;

/**
 * 
 * @author Gnacik
 * 
 */
public class IslandDev implements CommandExecutor
{
	private final IslandWorld plugin;

	public IslandDev(IslandWorld plugin)
	{
		this.plugin = plugin;
	}

	@Override
	public boolean onCommand(CommandSender sender, Command command, String label, String[] split)
	{
		if (plugin == null)
			return false;
		if (sender == null)
			return false;

		if (IslandWorld.REGEN_IN_PROGRESS)
			return plugin.showError(sender, plugin.getLoc("error-regen"));

		if (!IslandWorld.LOADED)
			return plugin.showError(sender, plugin.getLoc("error-start"));

		final World world = plugin.getServer().getWorld(Config.WORLD_ISLE);
		if (world == null)
			return plugin.showError(sender, plugin.getLoc("error-world"));

		if (label.equalsIgnoreCase("islandev"))
		{
			// if (!(sender.hasPermission("islandworld.islandev")))
			// return plugin.showError(sender, plugin.getLoc("error-no-perms"));

			if (split.length == 0)
			{
				showUsage(sender);
			}
			else if (split.length == 1)
			{
				if (split[0].equalsIgnoreCase("reload"))
				{
					return commandReload(world, sender);
				}
				else if (split[0].equalsIgnoreCase("save"))
				{
					return commandSave(world, sender);
				}
				else if (split[0].equalsIgnoreCase("visitclear"))
				{
					return commandVisitClear(world, sender);
				}
				else if (split[0].equalsIgnoreCase("chaclear"))
				{
					return commandChallengesClear(world, sender);
				}
				else if (split[0].equalsIgnoreCase("info"))
				{
					return commandInfo(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("delete"))
				{
					return commandDelete(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("tp"))
				{
					return commandTeleport(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("sethome"))
				{
					return commandSetHome(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("fixhome"))
				{
					return commandFixHome(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("purge"))
				{
					return commandPurge(world, sender, null, null);
				}
				else if (split[0].equalsIgnoreCase("challenges"))
				{
					return commandChallenges(world, sender, "", "");
				}
				else if (split[0].equalsIgnoreCase("cleardrop"))
				{
					return commandClearDrop(world, sender);
				}
				else if (split[0].equalsIgnoreCase("create"))
				{
					return commandCreate(world, sender, null, null);
				}
				else if (split[0].equalsIgnoreCase("stats"))
				{
					return commandStats(world, sender);
				}
				else if (split[0].equalsIgnoreCase("setspawn"))
				{
					return commandSetSpawn(world, sender);
				}
				else if (split[0].equalsIgnoreCase("biomeshow"))
				{
					return commandBiomeShow(world, sender);
				}
				else if (split[0].equalsIgnoreCase("biomelist"))
				{
					return commandBiomeList(world, sender);
				}
				else if (split[0].equalsIgnoreCase("calc"))
				{
					return commandCalc(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("rank"))
				{
					return commandRank(world, sender);
				}
				else if (split[0].equalsIgnoreCase("lock"))
				{
					return commandLock(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("unlock"))
				{
					return commandUnLock(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("pvpflag"))
				{
					return commandPvpFlag(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("biomeset"))
				{
					return commandBiomeSet(world, sender, null, null);
				}				
				else if (split[0].equalsIgnoreCase("sendhome"))
				{
					return commandSendHome(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("sendallhome"))
				{
					return commandSendAllHome(world, sender, null);
				}
				else if (split[0].equalsIgnoreCase("add"))
				{
					return commandAdd(world, sender, null, null);
				}
				else if (split[0].equalsIgnoreCase("remove"))
				{
					return commandRemove(world, sender, null);
				}
				else
					showUsage(sender);
			}
			else if (split.length == 2)
			{
				if (split[0].equalsIgnoreCase("info"))
				{
					return commandInfo(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("delete"))
				{
					return commandDelete(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("tp"))
				{
					return commandTeleport(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("sethome"))
				{
					return commandSetHome(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("fixhome"))
				{
					return commandFixHome(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("purge"))
				{
					return commandPurge(world, sender, split[1], null);
				}
				else if (split[0].equalsIgnoreCase("challenges"))
				{
					return commandChallenges(world, sender, split[1], "");
				}
				else if (split[0].equalsIgnoreCase("create"))
				{
					return commandCreate(world, sender, split[1], null);
				}
				else if (split[0].equalsIgnoreCase("calc"))
				{
					return commandCalc(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("lock"))
				{
					return commandLock(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("unlock"))
				{
					return commandUnLock(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("pvpflag"))
				{
					return commandPvpFlag(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("biomeset"))
				{
					return commandBiomeSet(world, sender, null, null);
				}
				else if (split[0].equalsIgnoreCase("sendhome"))
				{
					return commandSendHome(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("sendallhome"))
				{
					return commandSendAllHome(world, sender, split[1]);
				}
				else if (split[0].equalsIgnoreCase("add"))
				{
					return commandAdd(world, sender, split[1], null);
				}
				else if (split[0].equalsIgnoreCase("remove"))
				{
					return commandRemove(world, sender, split[1]);
				}
				else
					showUsage(sender);

			}
			else if (split.length == 3)
			{
				if (split[0].equalsIgnoreCase("challenges"))
				{
					return commandChallenges(world, sender, split[1], split[2]);
				}
				else if (split[0].equalsIgnoreCase("create"))
				{
					return commandCreate(world, sender, split[1], split[2]);
				}
				else if (split[0].equalsIgnoreCase("purge"))
				{
					return commandPurge(world, sender, split[1], split[2]);
				}
				else if (split[0].equalsIgnoreCase("biomeset"))
				{
					return commandBiomeSet(world, sender, split[1], split[2]);
				}
				else if (split[0].equalsIgnoreCase("add"))
				{
					return commandAdd(world, sender, split[1], split[2]);
				}				
				else
					showUsage(sender);
			}
			else
				showUsage(sender);

			return true;
		}
		return false;
	}

	private boolean commandCreate(World world, CommandSender sender, String schemName, String who)
	{
		// if (!(player.hasPermission("islandworld.islandev.create")))
		// return plugin.showError(player, plugin.getLoc("error-no-perms"));

		if (schemName == null || schemName.isEmpty())
			return plugin.showError(sender, "You need provide schematic");

		if (who == null || who.isEmpty())
			return plugin.showError(sender, "You need provide owner");

		if (!(sender.hasPermission("islandworld.islandev.create." + schemName)))
			return plugin.showError(sender, plugin.getLoc("error-schematic").replaceAll("%name%", schemName));

		Player owner = Bukkit.getPlayer(who);
		if (owner != null)
		{
			if (plugin.haveIsland(owner))
				return plugin.showError(sender, plugin.getLoc("error-have-island"));
			if (plugin.isHelping(owner))
				return plugin.showError(sender, plugin.getLoc("error-helping"));

			final SchematicFormat schema = plugin.getSchematicFromFile(schemName, false);
			if (schema != null)
			{
				if (plugin.getFreeList() != null && !plugin.getFreeList().isEmpty())
				{
					SimpleIslandV6 newIsland = plugin.getFreeList().iterator().next();

					if (newIsland != null)
					{
						// Clean inventory only if player is in Island World
						if (Config.CLEANINV && owner.getWorld() == world)
							owner.getInventory().clear();

						// Create Island
						plugin.onCreate(newIsland, owner, schemName);
						// Send info
						sender.sendMessage(ChatColor.YELLOW + plugin.getLoc("info-created"));
						// Send info
						owner.sendMessage(ChatColor.YELLOW + sender.getName() + " make island for you.");
						// Save Debug
						plugin.writeLog(newIsland, "Created by admin " + sender.getName());
					}
					else
						sender.sendMessage(ChatColor.RED + plugin.getLoc("error-get-free"));
				}
				else
					sender.sendMessage(ChatColor.RED + plugin.getLoc("error-no-free"));
			}
			else
				sender.sendMessage(ChatColor.RED + plugin.getLoc("error-schematic-not-exists").replaceAll("%name%", schemName));
		}
		else
			return plugin.showError(sender, "Invalid player");

		return true;
	}

	private boolean commandChallenges(World world, CommandSender sender, String plName, String ff)
	{
		if (!(sender.hasPermission("islandworld.islandev.challenges")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		int from = 0;
		if (plugin.isDigit(ff))
			from = Integer.valueOf(ff);

		if (plName.equalsIgnoreCase(""))
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev challenges <playerName> [page]" + ChatColor.AQUA + " - check player challenges\n");
			return false;
		}

		if (Bukkit.getOfflinePlayer(plName) != null)
		{
			if (plugin.isDigit(ff))
			{
				plugin.showChallengeList(sender, plName.toLowerCase(), from);
			}
			else
			{
				final List<Challenge> list = plugin.getChallenges();
				int count = 0;
				for (Challenge cha : list)
				{
					if (plugin.playerCompletedChallenge(plName, cha.getId()))
						count++;
				}
				sender.sendMessage(ChatColor.AQUA + "Player " + plName + " challenges: " + count + "/" + list.size());
				sender.sendMessage(ChatColor.YELLOW + "Use page number for details");
				sender.sendMessage(ChatColor.RED + "/islandev challenges <playerName> [page]");
			}
		}
		else
			plugin.showError(sender, "Invalid playername");

		return true;
	}

	private boolean commandPurge(World world, CommandSender sender, String days, String howmuch)
	{
		if (!(sender.hasPermission("islandworld.islandev.purge")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (!plugin.isDigit(days))
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev purge <days>" + ChatColor.AQUA
					+ " - Removes islands that have not been visited in <days> days.\n");
			return false;
		}

		if (IslandWorld.purgeInProgress)
			return plugin.showError(sender, "Purge in progress");

		int hmuch = 0;
		if (plugin.isDigit(howmuch))
			hmuch = Integer.valueOf(howmuch);

		final int intdays = Integer.valueOf(days);
		if (intdays > 0)
		{
			IslandWorld.purgeInProgress = true;

			plugin.purgeIslands(sender, intdays, hmuch);
		}
		else
			return plugin.showError(sender, "Days should be higher than 0");

		return true;
	}

	private boolean commandSetHome(World world, CommandSender sender, String who)
	{
		if (!(sender.hasPermission("islandworld.islandev.sethome")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (sender instanceof Player)
		{
			Player player = (Player) sender;

			if (who == null || who.isEmpty())
			{
				player.sendMessage(ChatColor.AQUA + "Usage:\n");
				player.sendMessage(ChatColor.RED + "/islandev sethome <playerName>" + ChatColor.AQUA + " - Change home location on player island\n");
				return false;
			}

			if (Bukkit.getOfflinePlayer(who) != null)
			{
				SimpleIslandV6 isle = plugin.getPlayerIsland(who);
				if (isle != null)
				{
					if (plugin.isSafeToTeleport(new MyLocation(player.getLocation())))
					{
						final Location loc = player.getLocation();
						// Set it
						isle.setLocation(loc);
						// Info
						player.sendMessage("Location changed.");
	
						plugin.debug("Location changed to : [" + loc.getBlockX() + "][" + loc.getBlockY() + "][" + loc.getBlockZ() + "]");
					}
					else
						return plugin.showError(player, plugin.getLoc("error-sethome-loc"));	
				}
				else
					return plugin.showError(player, "Player " + who + " doesn't have island");
			}
			else
				return plugin.showError(player, "Player " + who + " doesn't exists");
		}
		else
			sender.sendMessage("Cannot use that command from console!");

		return true;
	}

	private boolean commandFixHome(World world, CommandSender sender, String who)
	{
		if (!(sender.hasPermission("islandworld.islandev.fixhome")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (who == null || who.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev fixhome <playerName>" + ChatColor.AQUA + " - Change home location on player island\n");
			return false;
		}

		if (Bukkit.getOfflinePlayer(who) != null)
		{
			SimpleIslandV6 isle = plugin.getPlayerIsland(who);
			if (isle != null)
			{
				if (plugin.findIslandSpawn(isle))
					sender.sendMessage("Fixed home coords");
				else
					sender.sendMessage("There is problem with coords, cannot find safe point");
			}
			else
				return plugin.showError(sender, "Player " + who + " doesn't have island");
		}
		else
			return plugin.showError(sender, "Player " + who + " doesn't exists");

		return true;
	}

	private boolean commandTeleport(World world, CommandSender sender, String who)
	{
		if (!(sender.hasPermission("islandworld.islandev.tp")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (sender instanceof Player)
		{
			Player player = (Player) sender;

			if (who == null || who.isEmpty())
			{
				player.sendMessage(ChatColor.AQUA + "Usage:\n");
				player.sendMessage(ChatColor.RED + "/islandev tp <playerName>" + ChatColor.AQUA + " - Teleport to player island\n");
				return false;
			}

			if (Bukkit.getOfflinePlayer(who) != null)
			{
				SimpleIslandV6 isle = plugin.getPlayerIsland(who);
				if (isle != null)
				{
					// Teleport
					plugin.teleportPlayer(plugin.getIslandWorld(), player, isle.getLocation());
					// All done
					player.sendMessage(ChatColor.YELLOW + "Teleported to " + who + " island");
				}
				else
					return plugin.showError(player, "Player " + who + " doesn't have island");
			}
			else
				return plugin.showError(player, "Player " + who + " doesn't exists");
		}
		else
			sender.sendMessage("Cannot use that command from console!");

		return true;
	}

	private boolean commandDelete(World world, CommandSender sender, String who)
	{
		if (!(sender.hasPermission("islandworld.islandev.delete")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (who == null || who.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev delete <playerName>" + ChatColor.AQUA + " - Delete players island\n");
			return false;
		}

		if (Bukkit.getOfflinePlayer(who) != null)
		{
			SimpleIslandV6 isle = plugin.getPlayerIsland(who);
			if (isle != null)
			{
				// Teleport all player outside
				Player[] players = Bukkit.getOnlinePlayers();
				for (Player pl : players)
				{
					if (pl != null && plugin.isInsideIsland(pl, isle))
					{
						pl.teleport(plugin.getSpawnWorld().getSpawnLocation());
					}
				}
				// Delete island
				plugin.onDelete(isle, who);
				// All done
				sender.sendMessage(ChatColor.YELLOW + "Island deleted");
				// Save Debug
				plugin.writeLog(isle, "Deleted by admin " + sender.getName());
			}
			else
				return plugin.showError(sender, "Player " + who + " doesn't have island");
		}
		else
			return plugin.showError(sender, "Player " + who + " doesn't exists");

		return true;
	}

	private boolean commandInfo(World world, CommandSender sender, String who)
	{
		if (!(sender.hasPermission("islandworld.islandev.info")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (who == null || who.isEmpty())
		{
			if (sender instanceof Player)
			{
				boolean found = false;

				final HashMap<String, SimpleIslandV6> list = plugin.getIsleList();
				final Location curr = ((Player) sender).getLocation();

				final int isX = curr.getBlockX() / Config.ISLE_SIZE;
				final int isZ = curr.getBlockZ() / Config.ISLE_SIZE;

				for (Entry<String, SimpleIslandV6> e : list.entrySet())
				{

					final String ownerName = e.getKey();
					final SimpleIslandV6 island = e.getValue();
					if (island.getX() == isX && island.getZ() == isZ)
					{
						plugin.showInfo(sender, ownerName, island);
						found = true;
						break;
					}
				}
				if (!found)
					plugin.showError(sender, "You are not inside any island");

				return true;
			}
		}

		if (Bukkit.getOfflinePlayer(who) != null)
		{
			SimpleIslandV6 isle = plugin.getPlayerIsland(who);
			if (isle == null && plugin.isHelping(who))
				isle = plugin.getHelpingIsland(who);

			if (isle != null)
			{
				plugin.showInfo(sender, who, isle);
			}
			else
				return plugin.showError(sender, "Player " + who + " doesn't have island or help on island.");
		}
		else
			return plugin.showError(sender, "Player " + who + " doesn't exists");

		return true;
	}

	private boolean commandReload(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.reload")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		plugin.reloadConfig();
		Config cfg = new Config(plugin);
		cfg.setupDefaults();

		plugin.loadMessages();

		sender.sendMessage(ChatColor.YELLOW + "Configuration reloaded");

		return true;
	}

	private boolean commandSave(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.save")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		plugin.saveDatFiles();

		sender.sendMessage(ChatColor.YELLOW + "Saved dat files");

		return true;
	}

	private boolean commandClearDrop(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.cleardrop")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		int count = 0;
		for (Entity i : world.getEntities())
		{
			if (i != null && i.getType() == EntityType.DROPPED_ITEM)
			{
				i.remove();
				count++;
			}
		}
		plugin.showError(sender, "Removed " + count + " items from ground");

		return true;
	}

	private boolean commandStats(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.stats")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		plugin.showStats(sender);

		return true;
	}

	private boolean commandSetSpawn(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.setspawn")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (sender instanceof Player)
		{
			Player player = (Player) sender;

			final World w = player.getWorld();
			final Location l = player.getLocation();

			w.setSpawnLocation(l.getBlockX(), l.getBlockY(), l.getBlockZ());
			player.sendMessage(ChatColor.AQUA + "Changed " + w.getName() + " spawn location to: " + l.getBlockX() + ", " + l.getBlockY() + ", "
					+ l.getBlockZ());
		}
		else
			sender.sendMessage("Cannot use that command from console!");

		return true;
	}

	private boolean commandVisitClear(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.visitclear")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		plugin.getVisitList().clear();
		sender.sendMessage(ChatColor.AQUA + "Visitlist cleared.");

		return true;
	}

	private boolean commandChallengesClear(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.chaclear")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		plugin.getCompletedChallenges().clear();
		sender.sendMessage(ChatColor.AQUA + "Completed challenges cleared.");

		return true;
	}

	private boolean commandBiomeShow(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.biomeshow")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (sender instanceof Player)
		{
			Player player = (Player) sender;

			Biome bio = player.getWorld().getBiome(player.getLocation().getBlockX(), player.getLocation().getBlockZ());
			if (bio != null)
				player.sendMessage(ChatColor.AQUA + "Biome at your location: " + ChatColor.YELLOW + bio.toString());

		}
		else
			sender.sendMessage("Cannot use that command from console!");

		return true;
	}

	private boolean commandBiomeList(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.biomelist")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		Biome[] bm = Biome.values();

		sender.sendMessage(ChatColor.AQUA + "Biomes:");
		sender.sendMessage(ChatColor.GREEN + "" + StringUtils.join(bm, ", "));

		return true;
	}

	private boolean commandBiomeSet(World world, CommandSender sender, String owner, String biome)
	{
		if (!(sender.hasPermission("islandworld.islandev.biomeset")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (Bukkit.getOfflinePlayer(owner) != null)
		{
			SimpleIslandV6 isle = plugin.getPlayerIsland(owner);
			if (isle != null)
			{
				Biome newbiome = null;

				Biome[] bm = Biome.values();

				for (Biome b : bm)
				{
					if (b.toString().equalsIgnoreCase(biome))
						newbiome = b;
				}

				if (newbiome != null)
				{
					int x = isle.getX() * Config.ISLE_SIZE;
					int z = isle.getZ() * Config.ISLE_SIZE;

					for (int x_operate = x; x_operate < (x + Config.ISLE_SIZE); x_operate++)
					{
						for (int z_operate = z; z_operate < (z + Config.ISLE_SIZE); z_operate++)
						{
							plugin.getIslandWorld().setBiome(x_operate, z_operate, newbiome);
							plugin.showMessage(sender, "Biome set to " + newbiome.toString());
						}
					}
				}
				else
					plugin.showError(sender, "Incorrect biome");

			}
			else
				return plugin.showError(sender, "Player " + owner + " doesn't have island");
		}
		else
			return plugin.showError(sender, "Player " + owner + " doesn't exists");

		return false;
	}

	private boolean commandCalc(World world, CommandSender sender, String who)
	{
		if (!(sender.hasPermission("islandworld.islandev.calc")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (who == null || who.isEmpty())
			who = sender.getName();

		if (Bukkit.getOfflinePlayer(who) != null)
		{
			SimpleIslandV6 isle = plugin.getPlayerIsland(who);
			if (isle == null)
				isle = plugin.getHelpingIsland(who);

			if (isle != null)
			{
				int points = plugin.calcIslandPoints(isle);

				String str = plugin.getLoc("info-for-points");
				str = str.replaceAll("%name%", who);
				str = str.replaceAll("%points%", String.valueOf(points));

				sender.sendMessage(ChatColor.AQUA + str);

				plugin.storePoints(isle.getOwner(), points);
			}
			else
				return plugin.showError(sender, "Player " + who + " doesn't have island");
		}
		else
			return plugin.showError(sender, "Player " + who + " doesn't exists");

		return true;
	}

	private boolean commandRank(World world, CommandSender sender)
	{
		if (!(sender.hasPermission("islandworld.islandev.rank")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		plugin.readPoints();

		if (plugin.getRankLastUpdate() <= 0)
			return plugin.showError(sender, plugin.getLoc("error-rank-not-updated"));
		else
			sender.sendMessage(ChatColor.YELLOW + "Rank reloaded");

		return true;
	}

	private boolean commandLock(World world, CommandSender sender, String who)
	{
		if (!(sender.hasPermission("islandworld.islandev.lock")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (who == null || who.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev lock <playerName>" + ChatColor.AQUA + " - Lock player island\n");
			return false;
		}

		if (Bukkit.getOfflinePlayer(who) != null)
		{
			SimpleIslandV6 isle = plugin.getPlayerIsland(who);
			if (isle != null)
			{
				if (!isle.isProtected())
				{
					isle.setProtected(true);
					plugin.debug(who + "`s island is now protected.");
				}
				else
					return plugin.showError(sender, who + "`s island is already protected");
			}
			else
				return plugin.showError(sender, "Player " + who + " doesn't have island");
		}
		else
			return plugin.showError(sender, "Player " + who + " doesn't exists");

		return true;
	}

	private boolean commandUnLock(World world, CommandSender sender, String who)
	{
		if (!(sender.hasPermission("islandworld.islandev.unlock")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (who == null || who.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev unlock <playerName>" + ChatColor.AQUA + " - Unlock player island\n");
			return false;
		}

		if (Bukkit.getOfflinePlayer(who) != null)
		{
			SimpleIslandV6 isle = plugin.getPlayerIsland(who);
			if (isle != null)
			{
				if (isle.isProtected())
				{
					isle.setProtected(false);
					plugin.debug(who + "`s island is now protected.");
				}
				else
					return plugin.showError(sender, who + "`s island is not protected.");
			}
			else
				return plugin.showError(sender, "Player " + who + " doesn't have island");
		}
		else
			return plugin.showError(sender, "Player " + who + " doesn't exists");

		return true;
	}

	private boolean commandPvpFlag(World world, CommandSender sender, String val)
	{
		if (!(sender.hasPermission("islandworld.islandev.unprotect")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (val == null || val.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev pvpflag <on|off>" + ChatColor.AQUA + " - Change PVP Flag state\n");
			return false;
		}

		if (val.equalsIgnoreCase("on"))
		{
			Config.FLAG_PVP = true;
			sender.sendMessage("Pvp on islands enabled.");
		}
		else if (val.equalsIgnoreCase("off"))
		{
			Config.FLAG_PVP = false;
			sender.sendMessage("Pvp on islands disabled.");
		}
		else
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev pvpflag <on|off>" + ChatColor.AQUA + " - Change PVP Flag state\n");
		}

		return true;
	}

	private boolean commandSendHome(World world, CommandSender sender, String val)
	{
		if (!(sender.hasPermission("islandworld.islandev.sendhome")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (val == null || val.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev sendhome <player>" + ChatColor.AQUA + " - Send player to his island.\n");
			return false;
		}
		
		final Player owner = Bukkit.getPlayer(val);
		
		if (owner != null && owner.isOnline())
		{
			SimpleIslandV6 island = plugin.getPlayerIsland(owner);
			if (island == null)
				island = plugin.getHelpingIsland(owner);
			
			if (island != null)
			{
				MyLocation dest_loc = island.getLocation();
				if (dest_loc != null)
				{
					plugin.teleportPlayer(plugin.getIslandWorld(), owner, dest_loc);
					plugin.showMessage(owner, plugin.getLoc("info-admin-teleported"));

					plugin.showMessage(sender, "Player teleported to his island");
				}
			}
			else
				sender.sendMessage(ChatColor.RED + "Player doesnt have island.");
		}
		else
			sender.sendMessage(ChatColor.RED + "Player not online");
		
		return true;
	}
	
	private boolean commandSendAllHome(World world, CommandSender sender, String val)
	{
		if (!(sender.hasPermission("islandworld.islandev.sendallhome")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (val == null || val.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev sendallhome <owner>" + ChatColor.AQUA + " - Send all players to island.\n");
			return false;
		}
		
		final Player owner = Bukkit.getPlayer(val);
		
		if (owner != null && owner.isOnline())
		{
			SimpleIslandV6 island = plugin.getPlayerIsland(owner);
			if (island == null)
				island = plugin.getHelpingIsland(owner);
			
			if (island != null)
			{
				MyLocation dest_loc = island.getLocation();
				if (dest_loc != null)
				{
					int count = 0;
					plugin.teleportPlayer(plugin.getIslandWorld(), owner, dest_loc);
					plugin.showMessage(owner, plugin.getLoc("info-admin-teleported"));
					count++;
					
					List<String> lista = island.getMembers();
					if (lista != null && !lista.isEmpty())
					{
						for(String mem : lista)
						{
							final Player member = Bukkit.getPlayer(mem);
							if (member != null && member.isOnline())
							{
								plugin.teleportPlayer(plugin.getIslandWorld(), member, dest_loc);
								plugin.showMessage(member, plugin.getLoc("info-admin-teleported"));
								count++;								
							}
						}
					}
					
					plugin.showMessage(sender, "Teleported " + count + " players to island.");
				}
			}
			else
				sender.sendMessage(ChatColor.RED + "Player doesnt have island.");
		}
		else
			sender.sendMessage(ChatColor.RED + "Player not online");
		
		return true;
	}
	
	private boolean commandAdd(World world, CommandSender sender, String owner, String player)
	{
		if (!(sender.hasPermission("islandworld.islandev.add")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (owner == null || owner.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev add <owner> <player>" + ChatColor.AQUA + " - Add player to owner island.\n");
			return false;
		}
		if (player == null || player.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev add <owner> <player>" + ChatColor.AQUA + " - Add player to owner island.\n");
			return false;
		}
		if (plugin.haveIsland(player) || plugin.isHelping(player))
		{
			return plugin.showError(sender, "Player " + player + " have own island, or is already in party");
		}
		
		final SimpleIslandV6 island = plugin.getPlayerIsland(owner);
		if (island != null)
		{
			island.addMember(player.toLowerCase());
			plugin.setIsHelping(player.toLowerCase(), island);
			
			final Player np = Bukkit.getPlayer(player);
			if (np != null)
				np.sendMessage(plugin.getLoc("info-party-joined-admin-player").replaceAll("%name%", owner));
			
			final Player ow = Bukkit.getPlayer(owner);
			if (ow != null)
				ow.sendMessage(plugin.getLoc("info-party-joined-admin-owner").replaceAll("%name%", player));
		}
		else
			return plugin.showError(sender, "Player " + owner + " doesnt have island.");
		
		return true;
	}
	
	private boolean commandRemove(World world, CommandSender sender, String val)
	{
		if (!(sender.hasPermission("islandworld.islandev.add")))
			return plugin.showError(sender, plugin.getLoc("error-no-perms"));

		if (val == null || val.isEmpty())
		{
			sender.sendMessage(ChatColor.AQUA + "Usage:\n");
			sender.sendMessage(ChatColor.RED + "/islandev remove <player>" + ChatColor.AQUA + " - Remove player from party.\n");
			return false;
		}

		final SimpleIslandV6 island = plugin.getHelpingIsland(val);
		if (island != null)
		{
			final List<String> members = island.getMembers();
			if (members != null && members.contains(val.toLowerCase()))
			{
				island.removeMember(val.toLowerCase());
				plugin.removeHelping(val.toLowerCase());

				final Player owner = Bukkit.getPlayer(island.getOwner());
				if (owner != null)
					owner.sendMessage(ChatColor.YELLOW + plugin.getLoc("info-remove-admin").replaceAll("%name%", val));
				
				final Player friend = Bukkit.getPlayer(val);
				if (friend != null && plugin.isInsideIsland(friend, island))
				{
					// Teleport player
					friend.teleport(plugin.getSpawnWorld().getSpawnLocation());
					// Send message
					friend.sendMessage(ChatColor.YELLOW + plugin.getLoc("info-removed-admin"));
				}
			}
			else
				return plugin.showError(sender, "Player " + val + " is not member of party");
		}
		else
			return plugin.showError(sender, "Player " + val + " is not in party");
		
		return true;
	}
	
	public void showUsage(CommandSender sender)
	{
		if (sender instanceof Player)
		{
			Player player = (Player) sender;

			// Player use only /island without params
			player.sendMessage(ChatColor.YELLOW + "Island World v" + plugin.getDescription().getVersion());
			player.sendMessage(ChatColor.AQUA + "Dev commands:");
			player.sendMessage(ChatColor.RED + "/islandev reload" + ChatColor.AQUA + " - reload configuration from file");
			player.sendMessage(ChatColor.RED + "/islandev save" + ChatColor.AQUA + " - save islands and world guard regions");
			player.sendMessage(ChatColor.RED + "/islandev stats" + ChatColor.AQUA + " - show stats");
			player.sendMessage(ChatColor.RED + "/islandev visitclear" + ChatColor.AQUA + " - clear visit list cache");
			player.sendMessage(ChatColor.RED + "/islandev info [playerName]" + ChatColor.AQUA + " - show info about player isle");
			player.sendMessage(ChatColor.RED + "/islandev create <schematic> <player>" + ChatColor.AQUA + " - create for player island using schematic");
			player.sendMessage(ChatColor.RED + "/islandev delete <playerName>" + ChatColor.AQUA + " - delete player island");
			player.sendMessage(ChatColor.RED + "/islandev tp <playerName>" + ChatColor.AQUA + " - teleport to player island");
			player.sendMessage(ChatColor.RED + "/islandev sethome <playerName>" + ChatColor.AQUA + " - change home location on player island");
			player.sendMessage(ChatColor.RED + "/islandev add <owner> <player>" + ChatColor.AQUA + " - Add player to owner island.\n");
			
			player.sendMessage(ChatColor.RED + "/islandev challenges <playerName> [page]" + ChatColor.AQUA + " - check player challenges");
			player.sendMessage(ChatColor.RED + "/islandev purge <days> [mowmuch]" + ChatColor.AQUA + " - Removes islands that have not been visited in <days> days.");
			player.sendMessage(ChatColor.RED + "/islandev setspawn" + ChatColor.AQUA + " - Change world spawn location");
			player.sendMessage(ChatColor.RED + "/islandev cleardrop" + ChatColor.AQUA + " - Remove items dropped on ground");
			player.sendMessage(ChatColor.RED + "/islandev biomeshow" + ChatColor.AQUA + " - Show biome at your location");
			player.sendMessage(ChatColor.RED + "/islandev biomelist" + ChatColor.AQUA + " - List all possible biomes");
			player.sendMessage(ChatColor.RED + "/islandev biomeset <playerName> <biome>" + ChatColor.AQUA + " - Change biome on player's island");
			player.sendMessage(ChatColor.RED + "/islandev calc <playerName>" + ChatColor.AQUA + " - Calculate points for player");
			player.sendMessage(ChatColor.RED + "/islandev rank" + ChatColor.AQUA + " - Reload rank");
			player.sendMessage(ChatColor.RED + "/islandev protect <playerName>" + ChatColor.AQUA + " - Protect player island\n");
			player.sendMessage(ChatColor.RED + "/islandev unprotect <playerName>" + ChatColor.AQUA + " - Unprotect player island\n");
			player.sendMessage(ChatColor.RED + "/islandev sendhome <player>" + ChatColor.AQUA + " - Send player to his island.\n");
			player.sendMessage(ChatColor.RED + "/islandev sendallhome <owner>" + ChatColor.AQUA + " - Send all players to island.\n");
		}
	}
}