package pl.islandworld.entity;

import java.io.Serializable;

import org.bukkit.Location;

/**
 * 
 * @author Gnacik
 * 
 */
public class SimpleIsland implements Serializable
{
	private static final long serialVersionUID = 2L;

	public int isle_x;
	public int isle_z;

	public int spawn_x;
	public int spawn_z;
	public int spawn_y;

	public long createTime;

	public String schematic;

	public SimpleIsland(int x, int z)
	{
		isle_x = x;
		isle_z = z;
	}

	public void clear()
	{
		spawn_x = 0;
		spawn_z = 0;
		spawn_y = 0;

		createTime = 0;

		schematic = null;
	}

	public void setSpawnXYZ(Location loc)
	{
		spawn_x = loc.getBlockX();
		spawn_y = loc.getBlockY();
		spawn_z = loc.getBlockZ();
	}

	public void setCreateTime(long time)
	{
		createTime = time;
	}

	public long getCreateTime()
	{
		return createTime;
	}

	public void setSchematic(String schema)
	{
		schematic = schema;
	}

	public String getSchematic()
	{
		return schematic;
	}
}