package pl.islandworld.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.bukkit.Location;

/**
 * 
 * @author Gnacik
 * 
 */
public class SimpleIslandV4 implements Serializable
{
	private static final long serialVersionUID = 4L;

	public int isle_x;
	public int isle_z;
	public int spawn_x;
	public int spawn_z;
	public int spawn_y;

	public long createTime;
	public long ownerLoginTime;

	public String schematic;

	public List<String> members;

	public SimpleIslandV4(int x, int z)
	{
		isle_x = x;
		isle_z = z;

		createTime = System.currentTimeMillis();
		ownerLoginTime = System.currentTimeMillis();

		schematic = "normal";

		members = new ArrayList<String>();
	}

	public void clear()
	{
		spawn_x = 0;
		spawn_z = 0;
		spawn_y = 0;

		createTime = 0;
		ownerLoginTime = 0;

		schematic = null;

		members.clear();
	}

	public void setSpawnXYZ(Location loc)
	{
		spawn_x = loc.getBlockX();
		spawn_y = loc.getBlockY();
		spawn_z = loc.getBlockZ();
	}

	public void setCreateTime(long time)
	{
		createTime = time;
	}

	public long getCreateTime()
	{
		return createTime;
	}

	public void setOwnerLoginTime(long time)
	{
		ownerLoginTime = time;
	}

	public long getOwnerLoginTime()
	{
		return ownerLoginTime;
	}

	public void setSchematic(String schema)
	{
		schematic = schema;
	}

	public String getSchematic()
	{
		return schematic;
	}

	public List<String> getMembers()
	{
		return members;
	}

	public void addMember(String member)
	{
		members.add(member);
	}

	public void removeMember(String member)
	{
		if (members.contains(member))
			members.remove(member);
	}
}