package pl.islandworld.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import org.bukkit.Location;

/**
 * 
 * @author Gnacik
 * 
 */
public class SimpleIslandV6 implements Serializable
{
	private static final long serialVersionUID = 4L;

	private String owner;

	private int isle_x;
	private int isle_z;

	private MyLocation isle_loc;

	private boolean isProtected;

	private long createTime;
	private long ownerLoginTime;

	private String schematic;

	private ArrayList<String> members;
	private HashMap<String, MyLocation> homes;

	private long points;

	public SimpleIslandV6(int x, int z)
	{
		isle_x = x;
		isle_z = z;

		createTime = System.currentTimeMillis();
		ownerLoginTime = System.currentTimeMillis();

		schematic = "normal";

		members = new ArrayList<String>();
		homes = new HashMap<String, MyLocation>();
	}

	public SimpleIslandV6(SimpleIslandV4 old)
	{
		isle_x = old.isle_x;
		isle_z = old.isle_z;

		isle_loc = new MyLocation(old.spawn_x, old.spawn_y, old.spawn_z, 0, 0);

		final long cre = old.getCreateTime();
		if (cre == 0)
			createTime = System.currentTimeMillis();
		else
			createTime = cre;

		final long own = old.getOwnerLoginTime();
		if (own == 0)
			ownerLoginTime = System.currentTimeMillis();
		else
			ownerLoginTime = own;

		schematic = old.getSchematic();

		members = new ArrayList<String>();

		List<String> oldm = old.getMembers();
		if (oldm != null && !oldm.isEmpty())
		{
			for (String member : oldm)
			{
				if (member != null && !member.isEmpty())
					members.add(member.toLowerCase());
			}
		}
		homes = new HashMap<String, MyLocation>();
	}

	public SimpleIslandV6(SimpleIslandV5 old)
	{
		owner = old.getOwner();

		isle_x = old.getX();
		isle_z = old.getZ();

		isle_loc = old.getLocation();

		final long cre = old.getCreateTime();
		if (cre == 0)
			createTime = System.currentTimeMillis();
		else
			createTime = cre;

		final long own = old.getOwnerLoginTime();
		if (own == 0)
			ownerLoginTime = System.currentTimeMillis();
		else
			ownerLoginTime = own;

		schematic = old.getSchematic();

		members = new ArrayList<String>();

		List<String> oldm = old.getMembers();
		if (oldm != null && !oldm.isEmpty())
		{
			for (String member : oldm)
			{
				if (member != null && !member.isEmpty())
					members.add(member.toLowerCase());
			}
		}
		homes = new HashMap<String, MyLocation>();

		if (homes != null && !homes.isEmpty())
		{
			for (Entry<String, MyLocation> oh : homes.entrySet())
				homes.put(oh.getKey(), oh.getValue());
		}

		points = 0;
	}

	@Override
	public String toString()
	{
		return "[" + isle_x + "x" + isle_z + "][" + owner + "]";
	}

	public void clear()
	{
		isle_loc = null;

		createTime = 0;
		ownerLoginTime = 0;

		schematic = null;

		members.clear();
		homes.clear();
	}

	public String getOwner()
	{
		return owner;
	}

	public void setOwner(String ow)
	{
		owner = ow;
	}

	public int getX()
	{
		return isle_x;
	}

	public int getZ()
	{
		return isle_z;
	}

	public void setLocation(Location loc)
	{
		isle_loc = new MyLocation(loc);
	}

	public MyLocation getLocation()
	{
		return isle_loc;
	}

	public void setCreateTime(long time)
	{
		createTime = time;
	}

	public long getCreateTime()
	{
		return createTime;
	}

	public void setOwnerLoginTime(long time)
	{
		ownerLoginTime = time;
	}

	public long getOwnerLoginTime()
	{
		return ownerLoginTime;
	}

	public void setSchematic(String schema)
	{
		schematic = schema;
	}

	public String getSchematic()
	{
		return schematic;
	}

	public List<String> getMembers()
	{
		return members;
	}

	public void addMember(String member)
	{
		members.add(member.toLowerCase());
	}

	public void removeMember(String member)
	{
		if (members.contains(member.toLowerCase()))
			members.remove(member.toLowerCase());
	}

	public HashMap<String, MyLocation> getHomes()
	{
		return homes;
	}

	public void addHome(String name, MyLocation loc)
	{
		homes.put(name, loc);
	}

	public void removeHome(String name)
	{
		homes.remove(name);
	}

	public MyLocation getHome(String name)
	{
		if (homes.containsKey(name))
			return homes.get(name);

		return null;
	}

	public boolean isProtected()
	{
		return isProtected;
	}

	public void setProtected(boolean state)
	{
		isProtected = state;
	}

	public void setPoints(long p)
	{
		points = p;
	}

	public long getPoints()
	{
		return points;
	}
}