package pl.islandworld.listeners;

import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatEvent;

import pl.islandworld.Config;
import pl.islandworld.IslandWorld;
import pl.islandworld.entity.SimpleIslandV6;

/**
 * 
 * @author Gnacik
 * 
 */
@SuppressWarnings("deprecation")
public class ChatListener implements Listener
{
	private final IslandWorld plugin;

	public ChatListener(IslandWorld iw)
	{
		this.plugin = iw;
	}

	@EventHandler
	public void onPlayerChat(PlayerChatEvent event)
	{
		final Player player = event.getPlayer();
		final String plName = player.getName().toLowerCase();
		final String mess = event.getMessage();

		if (player != null && !Config.CHAT_PREFIX.equalsIgnoreCase("none") && mess.startsWith(Config.CHAT_PREFIX))
		{
			SimpleIslandV6 is = plugin.getPlayerIsland(player);
			if (is == null)
				is = plugin.getHelpingIsland(player);

			if (is != null)
			{
				event.setCancelled(true);

				final List<String> members = is.getMembers();

				if (is.getOwner().equalsIgnoreCase(plName))
				{
					final Player owner = Bukkit.getPlayer(plName);

					if (owner != null && owner.isOnline())
						owner.sendMessage(ChatColor.GOLD + player.getName() + ": " + ChatColor.GRAY + ""
								+ mess.substring(Config.CHAT_PREFIX.length()));
				}
				if (members != null && !members.isEmpty())
				{
					for (String m : members)
					{
						final Player member = Bukkit.getPlayer(m);

						if (member != null && member.isOnline())
							member.sendMessage(ChatColor.GOLD + player.getName() + ": " + ChatColor.GRAY + ""
									+ mess.substring(Config.CHAT_PREFIX.length()));
					}
				}
			}
		}
	}
}