package pl.islandworld.listeners;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Monster;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.ItemStack;

import pl.islandworld.Config;
import pl.islandworld.IslandWorld;

/**
 * 
 * @author Gnacik
 * 
 */
public class IslandProtectionListeners implements Listener
{
	private final IslandWorld plugin;

	public IslandProtectionListeners(IslandWorld iw)
	{
		this.plugin = iw;
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerBlockBreak(BlockBreakEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Block block = event.getBlock();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (block != null && !plugin.canBuildOnLocation(player, block.getLocation()))
			event.setCancelled(true);

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerBlockPlace(BlockPlaceEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Block block = event.getBlock();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (block != null && !plugin.canBuildOnLocation(player, block.getLocation()))
			event.setCancelled(true);

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemDrop (PlayerDropItemEvent event)
    {
		if (event.isCancelled())
			return;

        final Player player = event.getPlayer();
        final Item item = event.getItemDrop();

		if (item == null)
			return;
		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (!(plugin.getConfig().getBoolean("flags.item-drop", false) || plugin.canBuildOnLocation(player, item.getLocation())))
			event.setCancelled(true);

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
    }
    
	@EventHandler(priority = EventPriority.LOWEST)
	public void onInventoryOpenEvent(InventoryOpenEvent event)
	{
		if (event.isCancelled() || event.getInventory() == null)
			return;

		final Player player = (Player) event.getPlayer();
		
		if (event.getInventory().getHolder() instanceof Chest || event.getInventory().getHolder() instanceof DoubleChest)
		{
			if (player.getWorld() != plugin.getIslandWorld())
				return;
			if (player.isOp())
				return;
			if (player.hasPermission("islandworld.bypass.island"))
				return;
			
			Location loc = player.getLocation();
			
			if (event.getInventory().getHolder() instanceof Chest)
			{
				final Chest chest = (Chest) event.getInventory().getHolder();
				loc = chest.getLocation();
			}
			else if (event.getInventory().getHolder() instanceof DoubleChest)
			{
				final DoubleChest chest = (DoubleChest) event.getInventory().getHolder();
				loc = chest.getLocation();
			}
			
			if (!(plugin.getConfig().getBoolean("flags.chest-acces", false) || plugin.canBuildOnLocation(player, loc)))
				event.setCancelled(true);
        }
		
		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}
	
	@SuppressWarnings("deprecation")
	@EventHandler(priority = EventPriority.LOWEST)
	public void onPlayerInteract(PlayerInteractEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Block block = event.getClickedBlock();
		final ItemStack item = event.getItem();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (block != null)
		{
			final Material t = block.getType();

			plugin.debug("Interact with block: " + t.getId() + " : " + block);

			if (t == Material.MONSTER_EGG)
			{
				if (!(plugin.getConfig().getBoolean("flags.use-egg", false) || plugin.canBuildOnLocation(player, block.getLocation())))
					event.setCancelled(true);
			}
			else
			{
				if (!(isOnAllowedList(t) || (item != null && isOnAllowedList(item.getType())) || plugin.canBuildOnLocation(player,
						block.getLocation())))
					event.setCancelled(true);
			}
		}

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerInteractEntity(PlayerInteractEntityEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Entity e = event.getRightClicked();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (e instanceof Vehicle)
		{
			if (!(plugin.getConfig().getBoolean("flags.use-vehicle", false) || plugin.canBuildOnLocation(player, e.getLocation())))
				event.setCancelled(true);
		}
		else
		{
			if (e != null && !plugin.canBuildOnLocation(player, e.getLocation()))
				event.setCancelled(true);
		}

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerShearEntity(PlayerShearEntityEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Entity entity = event.getEntity();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (entity != null && !plugin.canBuildOnLocation(player, entity.getLocation()))
			event.setCancelled(true);

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerBucketFill(PlayerBucketFillEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Block block = event.getBlockClicked();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (block != null && !plugin.canBuildOnLocation(player, block.getLocation()))
			event.setCancelled(true);

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Block block = event.getBlockClicked();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (block != null && !plugin.canBuildOnLocation(player, block.getLocation()))
			event.setCancelled(true);

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onVehicleEnter(VehicleEnterEvent event)
	{
		if (event.isCancelled())
			return;

		if (event.getEntered() instanceof Player)
		{
			final Player player = (Player) event.getEntered();
			final Vehicle vehicle = event.getVehicle();

			if (player.getWorld() != plugin.getIslandWorld())
				return;
			if (player.isOp())
				return;
			if (player.hasPermission("islandworld.bypass.island"))
				return;

			if (vehicle != null
					&& !(plugin.getConfig().getBoolean("flags.use-vehicle", false) || plugin.canBuildOnLocation(player, vehicle.getLocation())))
				event.setCancelled(true);
		}

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onVehicleExit(VehicleExitEvent event)
	{
		if (event.isCancelled())
			return;

		if (event.getExited() instanceof Player)
		{
			final Player player = (Player) event.getExited();
			final Vehicle vehicle = event.getVehicle();

			if (player.getWorld() != plugin.getIslandWorld())
				return;
			if (player.isOp())
				return;
			if (player.hasPermission("islandworld.bypass.island"))
				return;

			if (vehicle != null
					&& !(plugin.getConfig().getBoolean("flags.use-vehicle", false) || plugin.canBuildOnLocation(player, vehicle.getLocation())))
				event.setCancelled(true);
		}

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onVehicleDamage(VehicleDamageEvent event)
	{
		if (event.isCancelled())
			return;

		if (event.getAttacker() instanceof Player)
		{
			final Player player = (Player) event.getAttacker();
			final Vehicle vehicle = event.getVehicle();

			if (player.getWorld() != plugin.getIslandWorld())
				return;
			if (player.isOp())
				return;
			if (player.hasPermission("islandworld.bypass.island"))
				return;

			if (vehicle != null
					&& !(plugin.getConfig().getBoolean("flags.use-vehicle", false) || plugin.canBuildOnLocation(player, vehicle.getLocation())))
				event.setCancelled(true);

			plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
		}
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerPortal(PlayerPortalEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (!(plugin.getConfig().getBoolean("flags.use-portal", false) || plugin.canBuildOnLocation(player, event.getFrom())))
			event.setCancelled(true);

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerPickupItemEvent(PlayerPickupItemEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Item item = event.getItem();

		if (player.getWorld() != plugin.getIslandWorld())
			return;
		if (player.isOp())
			return;
		if (player.hasPermission("islandworld.bypass.island"))
			return;

		if (item != null && !(plugin.getConfig().getBoolean("flags.item-pickup", false) || plugin.canBuildOnLocation(player, item.getLocation())))
			event.setCancelled(true);

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@SuppressWarnings("deprecation")
	@EventHandler(priority = EventPriority.HIGHEST)
	public void onProjectileLaunchEvent(ProjectileLaunchEvent event)
	{
		if (event.isCancelled())
			return;

		if (event.getEntity().getShooter() instanceof Player && event.getEntity() instanceof ThrownPotion)
		{
			final Player player = (Player) event.getEntity().getShooter();

			if (player.getWorld() != plugin.getIslandWorld())
				return;
			if (player.isOp())
				return;
			if (player.hasPermission("islandworld.bypass.island"))
				return;

			if (player != null
					&& !(plugin.getConfig().getBoolean("flags.potion-throw", false) || plugin.canBuildOnLocation(player, player.getLocation())))
				event.setCancelled(true);
		}

		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@SuppressWarnings("deprecation")
	@EventHandler(priority = EventPriority.HIGHEST)
	public void onEntityDamageByEntity(EntityDamageByEntityEvent event)
	{
		if (event.isCancelled())
			return;

		final Entity target = event.getEntity();

		Player attacker = null;
		if (event.getDamager() instanceof Player)
		{
			attacker = (Player) event.getDamager();
		}
		else if (event.getDamager() instanceof Projectile)
		{
			if (((Projectile) event.getDamager()).getShooter() instanceof Player)
				attacker = (Player) ((Projectile) event.getDamager()).getShooter();
		}

		if (target != null && attacker != null)
		{
			plugin.debug("Attacker: " + attacker + ", Target: " + target + "");

			if (attacker.getWorld() != plugin.getIslandWorld())
				return;
			if (attacker.isOp())
				return;
			if (attacker.hasPermission("islandworld.bypass.damage"))
				return;

			if (target instanceof Player)
			{
				if (!Config.FLAG_PVP)
					event.setCancelled(true);
			}
			else
			{
				if (target instanceof ItemFrame)
				{
					if (!plugin.canBuildOnLocation(attacker, target.getLocation()))
						event.setCancelled(true);
				}
				else if (target instanceof Monster || target instanceof WaterMob)
				{
					if (plugin.canBuildOnLocation(attacker, target.getLocation()) || plugin.getConfig().getBoolean("flags.kill-monster", false))
					{
					}
					else
					{
						event.setCancelled(true);
					}
				}
				else if (target instanceof Animals || target instanceof NPC)
				{
					if (plugin.canBuildOnLocation(attacker, target.getLocation()) || plugin.getConfig().getBoolean("flags.kill-animals", false))
					{
					}
					else
					{
						event.setCancelled(true);
					}
				}
			}
		}
		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@SuppressWarnings("deprecation")
	private boolean isOnAllowedList(Material t)
	{
		if (Config.ALLOWED_ITEM_LIST != null && !Config.ALLOWED_ITEM_LIST.isEmpty())
		{
			for (String blockDescr : Config.ALLOWED_ITEM_LIST)
			{
				if (blockDescr == null || blockDescr.isEmpty())
					continue;

				String[] split = blockDescr.split(":");

				if (split.length > 0 && isDigit(split[0]) && Integer.parseInt(split[0]) == t.getId())
				{
					plugin.debug("Is no allowed list: " + t.getId());
					return true;
				}
			}
		}

		plugin.debug("Is not on allowed list: " + t.getId());

		return false;
	}

	public static boolean isDigit(String text)
	{
		if ((text == null) || text.isEmpty())
		{
			return false;
		}
		for (char c : text.toCharArray())
		{
			if (!Character.isDigit(c))
			{
				return false;
			}
		}
		return true;
	}
}