package pl.islandworld.listeners;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

import pl.islandworld.Config;
import pl.islandworld.IslandWorld;
import pl.islandworld.entity.Challenge;
import pl.islandworld.entity.MyLocation;
import pl.islandworld.entity.SimpleIslandV6;

public class IslandWorldListener implements Listener
{
	private final IslandWorld plugin;

	public IslandWorldListener(IslandWorld iw)
	{
		this.plugin = iw;
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerJoin(PlayerJoinEvent event)
	{
		final Player player = event.getPlayer();

		if (player != null)
		{
			plugin.debug("Player " + player.getName() + " loged in.");

			// Tp to spawn
			if (plugin.getConfig().getBoolean("spawn-on-quit", false))
				player.teleport(plugin.getSpawnWorld().getSpawnLocation());

			SimpleIslandV6 island = plugin.getPlayerIsland(player);
			if (island != null)
			{
				plugin.debug("Changed owner last login to now.");
				island.setOwnerLoginTime(System.currentTimeMillis());

				if (Config.CALC_ON_ENTER)
				{
					plugin.debug("Calculate points for player island");
					int points = plugin.calcIslandPoints(island);
					island.setPoints(points);
					plugin.storePoints(island.getOwner(), points);
				}
				return;
			}
			else
				plugin.debug("Player doesn't have island");

			SimpleIslandV6 island2 = plugin.getHelpingIsland(player);
			if (island2 != null)
			{
				if (plugin.getConfig().getBoolean("purge-check-members", false))
				{
					plugin.debug("Changed member last login to now.");
					island2.setOwnerLoginTime(System.currentTimeMillis());
					return;
				}
				else
					plugin.debug("Player doesn't help on any island");
			}
		}
	}

	/*
	@EventHandler
	public void onPlayerQuit(PlayerQuitEvent event)
	{
		if (plugin.getConfig().getBoolean("spawn-on-quit", false))
		{
			final Player player = event.getPlayer();

			if (player != null)
				player.teleport(plugin.getSpawnWorld().getSpawnLocation());
		}
	}
	 */
	
	@EventHandler(priority = EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event)
    {
    	String tele = "";
    	final Player player = event.getPlayer();
    	final String resCfg = plugin.getConfig().getString("respawn-on-island", "skip");
    	if (resCfg.equalsIgnoreCase("skip"))
    		return;
    	
    	final boolean resp = Boolean.getBoolean(resCfg);
    	if (player != null)
    	{
	    	if (resp)
	    	{
	    		SimpleIslandV6 island = plugin.getPlayerIsland(player);
	    		if (island != null)
	    		{
	    			MyLocation loc = island.getLocation();
	    			if (plugin.isSafeToTeleport(loc))
	    			{
	    				tele = "is safe";
	    				event.setRespawnLocation(new Location(plugin.getIslandWorld(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch()));
	    			}
	    			else
	    			{
	    				tele = "is not safe";
	    				event.setRespawnLocation(plugin.getSpawnWorld().getSpawnLocation());
	    			}
	    		}
	    		else
	    			tele = "island null";
	    	}
	    	else
	    	{
				event.setRespawnLocation(plugin.getSpawnWorld().getSpawnLocation());
				tele = "respawn-on-island : false";
	    	}
    	}
    	else
    		tele = "player null";
    	
    	plugin.debug("Player Respawn Event: " + tele);
    }
    
	@EventHandler
	public void onPlayerMove(PlayerMoveEvent event)
	{
		if (plugin.getConfig().getInt("teleport-delay", 0) > 0 && plugin.getConfig().getBoolean("movement-break-tp", false))
		{
			final Player player = event.getPlayer();

			if (player != null && plugin.isOnTeleportList(player))
			{
				player.sendMessage(ChatColor.RED + plugin.getLoc("error-teleport-break"));
				plugin.removeFromTeleportList(player);
			}
		}
	}

	@EventHandler
	public void onSignChange(SignChangeEvent event)
	{
		if (!plugin.getConfig().getBoolean("use-signs", false))
			return;

		final Player player = event.getPlayer();
		if (player != null)
		{
			if (event.getLine(0).equalsIgnoreCase("[challenge]"))
			{
				if (player.hasPermission("islandworld.sign.create"))
				{
					if (plugin.isDigit(event.getLine(1)) || event.getLine(1).equals("all"))
					{
						player.sendMessage(ChatColor.YELLOW + plugin.getLoc("sign-created"));
						event.setLine(0, ChatColor.DARK_BLUE + "[Challenge]");
					}
					else
					{
						player.sendMessage(ChatColor.RED + plugin.getLoc("sign-second"));
						event.setLine(0, ChatColor.RED + "[Challenge]");
					}
				}
				else
					plugin.showError(player, plugin.getLoc("sign-perm-create"));
			}
		}
	}

	@SuppressWarnings("deprecation")
	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent e)
	{
		if (e.isCancelled())
			return;

		final Block b = e.getClickedBlock();
		final Player p = e.getPlayer();
		final Action a = e.getAction();

		if (a == null || b == null || p == null)
			return;

		if (a == Action.RIGHT_CLICK_BLOCK)
		{
			if (b.getType() == Material.OBSIDIAN)
			{
				final ItemStack i = p.getItemInHand();

				if (i != null && i.getType() == Material.BUCKET)
				{
					if (!plugin.getConfig().getBoolean("obsidian-break", false))
						return;
					if (!plugin.canBuildOnLocation(p, b.getLocation()))
						return;

					boolean obsnear = false;

					if (plugin.getConfig().getBoolean("obsidian-limit", true))
					{
						for (int x = -1; x <= 1; x++)
						{
							for (int y = -1; y <= 1; y++)
							{
								for (int z = -1; z <= 1; z++)
								{
									if (x == 0 && y == 0 && z == 0)
										continue;

									Block nb = plugin.getIslandWorld().getBlockAt(b.getX() + x, b.getY() + y, b.getZ() + z);

									if (nb != null && nb.getType() == Material.OBSIDIAN)
									{
										obsnear = true;
										break;
									}
								}
							}
						}
					}
					if (!obsnear)
					{
						final int ilosc = i.getAmount();

						plugin.debug("Bucket count : " + ilosc);

						if (ilosc == 1)
						{
							p.setItemInHand(null);
						}
						else
						{
							i.setAmount(ilosc - 1);
							p.setItemInHand(i);
						}
						b.setType(Material.AIR);
						p.getInventory().addItem(new ItemStack(Material.LAVA_BUCKET));
						p.updateInventory();
					}
				}
			}
			else if (b.getType() == Material.SIGN_POST || b.getType() == Material.WALL_SIGN)
			{
				if (!plugin.getConfig().getBoolean("use-signs", false))
					return;

				Sign sign = (Sign) b.getState();
				if (sign.getLine(0).equalsIgnoreCase(ChatColor.DARK_BLUE + "[challenge]"))
				{
					if (p.hasPermission("islandworld.sign.use"))
					{
						if (sign.getLine(1).equals("all"))
						{
							for (Challenge cha : plugin.getChallenges())
								plugin.completeChallenge(p, Integer.valueOf(cha.getId()));
						}
						else if (plugin.isDigit(sign.getLine(1)))
						{
							plugin.completeChallenge(p, Integer.valueOf(sign.getLine(1)));
						}
						else
							plugin.showError(p, plugin.getLoc("sign-unknown"));
					}
					else
						plugin.showError(p, plugin.getLoc("sign-perm-use"));
				}
			}
		}
	}
}
