package pl.islandworld.listeners;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

import pl.islandworld.Config;
import pl.islandworld.IslandWorld;

/**
 * 
 * @author Gnacik
 * 
 */
public class ItemProtectionListeners implements Listener
{
	private final IslandWorld plugin;

	public ItemProtectionListeners(IslandWorld iw)
	{
		this.plugin = iw;
	}

	@EventHandler
	public void onSignChange(SignChangeEvent event)
	{
		if (!Config.ITEM_PROTECTION)
			return;
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();
		final Block block = event.getBlock();

		if (player != null && block != null && player.getWorld() == plugin.getIslandWorld())
		{
			if (event.getLine(0).equalsIgnoreCase("[protect]"))
			{
				if (player.hasPermission("islandworld.vip.protection"))
				{
					if (event.getLine(1).equalsIgnoreCase(player.getName()))
					{
						final Location loc = block.getLocation();
						if (plugin.canBuildOnLocation(player, loc))
						{
							final Block under = plugin.getIslandWorld().getBlockAt(loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ());

							if (isProtectedBlock(under))
							{
								event.setLine(0, ChatColor.DARK_BLUE + "[PROTECT]");
								plugin.showMessage(player, ChatColor.AQUA + "Item under sign is protected now!");
							}
							else
							{
								event.setLine(0, ChatColor.RED + "[protect]");
								plugin.showError(player, "Item under sign cannot be protected!");
								plugin.debug("Protection " + under.toString());
							}
						}
						else
						{
							event.setLine(0, ChatColor.RED + "[protect]");
							plugin.showError(player, "Cannot make protection signs outside own island!");
						}
					}
					else
					{
						event.setLine(0, ChatColor.RED + "[protect]");
						plugin.showError(player, "You can only use own name on protection signs!");
					}
				}
				else
				{
					event.setLine(0, ChatColor.RED + "[protect]");
					plugin.showError(player, "You cannot make protect signs!");
				}
			}
		}
		plugin.debug("Event :" + event.getEventName() + ", cancelled:" + event.isCancelled());
	}

	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent e)
	{
		if (!Config.ITEM_PROTECTION)
			return;
		if (e.isCancelled())
			return;

		final Block b = e.getClickedBlock();
		final Player p = e.getPlayer();
		final Action a = e.getAction();

		if (a == null || b == null || p == null)
			return;

		if (p.isOp())
			return;

		if (a == Action.LEFT_CLICK_BLOCK)
		{
			if (b.getType() == Material.WALL_SIGN)
			{
				final Sign sign = (Sign) b.getState();

				if (sign.getLine(0).equalsIgnoreCase(ChatColor.DARK_BLUE + "[PROTECT]"))
				{
					if (!sign.getLine(1).equalsIgnoreCase(p.getName()))
					{
						plugin.showError(p, "Cannot destroy protection sign!");
						e.setCancelled(true);
					}
				}
			}
			else if (isProtectedBlock(b))
			{
				final Location loc = b.getLocation();
				final Block above = plugin.getIslandWorld().getBlockAt(loc.getBlockX(), loc.getBlockY() + 1, loc.getBlockZ());

				if (above.getType() == Material.WALL_SIGN)
				{
					final Sign sign = (Sign) above.getState();

					if (sign.getLine(0).equalsIgnoreCase(ChatColor.DARK_BLUE + "[PROTECT]"))
					{
						if (!sign.getLine(1).equalsIgnoreCase(p.getName()))
						{
							plugin.showError(p, "Cannot destroy that block, its protected!");
							e.setCancelled(true);
						}
					}
				}
			}
		}
		else if (a == Action.RIGHT_CLICK_BLOCK)
		{
			final Location loc = b.getLocation();

			Block above = plugin.getIslandWorld().getBlockAt(loc.getBlockX(), loc.getBlockY() + 1, loc.getBlockZ());
			if (above.getType() == Material.WOODEN_DOOR || above.getType() == Material.IRON_DOOR)
				above = plugin.getIslandWorld().getBlockAt(loc.getBlockX(), loc.getBlockY() + 2, loc.getBlockZ());

			if (above.getType() == Material.WALL_SIGN)
			{
				final Sign sign = (Sign) above.getState();

				if (sign.getLine(0).equalsIgnoreCase(ChatColor.DARK_BLUE + "[PROTECT]"))
				{
					if (!sign.getLine(1).equalsIgnoreCase(p.getName()))
					{
						plugin.showError(p, "Cannot use, item is protected!");
						e.setCancelled(true);
					}
				}
			}
		}
	}

	private boolean isProtectedBlock(Block block)
	{
		boolean isOk = false;

		switch (block.getType())
		{
			case IRON_DOOR:
			case WOODEN_DOOR:
			case CHEST:
			case FURNACE:
			case DISPENSER:
				isOk = true;
			break;
			default:
				isOk = false;
			break;
		}

		return isOk;
	}
}