package pl.islandworld.listeners;

import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

import pl.islandworld.Config;
import pl.islandworld.IslandWorld;
import pl.islandworld.entity.SimpleIslandV6;

public class MoveProtectionListener implements Listener
{
	private final IslandWorld plugin;

	public MoveProtectionListener(IslandWorld iw)
	{
		this.plugin = iw;
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerMove(PlayerMoveEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();

		if (!checkCoords(player, event.getTo().getWorld(), event.getTo().getBlockX(), event.getTo().getBlockZ()))
		{
			plugin.showError(player, plugin.getLoc("info-lock-move"));
			event.setCancelled(true);
			player.teleport(plugin.getSpawnWorld().getSpawnLocation());
		}
	}

	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerTeleport(PlayerTeleportEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();

		if (!checkCoords(player, event.getTo().getWorld(), event.getTo().getBlockX(), event.getTo().getBlockZ()))
		{
			plugin.showError(player, plugin.getLoc("info-lock-move"));
			event.setCancelled(true);
			player.teleport(plugin.getSpawnWorld().getSpawnLocation());
		}
	}

	private boolean checkCoords(Player player, World world, int blockX, int blockZ)
	{
		if (world != plugin.getIslandWorld())
			return true;
		if (player.isOp())
			return true;
		if (player.hasPermission("islandworld.bypass.lock"))
			return true;

		final String plName = player.getName().toLowerCase();
		final String coordHash = String.valueOf(blockX / Config.ISLE_SIZE) + "-" + String.valueOf(blockZ / Config.ISLE_SIZE);
		final SimpleIslandV6 is = plugin.getCoordList().get(coordHash);

		if (is != null && is.isProtected())
		{
			if (!(is.getOwner().equalsIgnoreCase(plName) || (is.getMembers() != null && is.getMembers().contains(plName))))
				return false;
		}

		return true;
	}
}